"""StressCyclesDataForTheContactSNCurveOfAPlasticMaterial"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
    pythonnet_property_set,
)
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private.materials import _249

_STRESS_CYCLES_DATA_FOR_THE_CONTACT_SN_CURVE_OF_A_PLASTIC_MATERIAL = python_net_import(
    "SMT.MastaAPI.Materials", "StressCyclesDataForTheContactSNCurveOfAPlasticMaterial"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar(
        "Self", bound="StressCyclesDataForTheContactSNCurveOfAPlasticMaterial"
    )
    CastSelf = TypeVar(
        "CastSelf",
        bound="StressCyclesDataForTheContactSNCurveOfAPlasticMaterial._Cast_StressCyclesDataForTheContactSNCurveOfAPlasticMaterial",
    )


__docformat__ = "restructuredtext en"
__all__ = ("StressCyclesDataForTheContactSNCurveOfAPlasticMaterial",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_StressCyclesDataForTheContactSNCurveOfAPlasticMaterial:
    """Special nested class for casting StressCyclesDataForTheContactSNCurveOfAPlasticMaterial to subclasses."""

    __parent__: "StressCyclesDataForTheContactSNCurveOfAPlasticMaterial"

    @property
    def abstract_stress_cycles_data_for_an_sn_curve_of_a_plastic_material(
        self: "CastSelf",
    ) -> "_249.AbstractStressCyclesDataForAnSNCurveOfAPlasticMaterial":
        return self.__parent__._cast(
            _249.AbstractStressCyclesDataForAnSNCurveOfAPlasticMaterial
        )

    @property
    def stress_cycles_data_for_the_contact_sn_curve_of_a_plastic_material(
        self: "CastSelf",
    ) -> "StressCyclesDataForTheContactSNCurveOfAPlasticMaterial":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class StressCyclesDataForTheContactSNCurveOfAPlasticMaterial(
    _249.AbstractStressCyclesDataForAnSNCurveOfAPlasticMaterial
):
    """StressCyclesDataForTheContactSNCurveOfAPlasticMaterial

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = (
        _STRESS_CYCLES_DATA_FOR_THE_CONTACT_SN_CURVE_OF_A_PLASTIC_MATERIAL
    )

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def contact_fatigue_strength_under_pulsating_stress(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(
            self.wrapped, "ContactFatigueStrengthUnderPulsatingStress"
        )

        if temp is None:
            return 0.0

        return temp

    @contact_fatigue_strength_under_pulsating_stress.setter
    @enforce_parameter_types
    def contact_fatigue_strength_under_pulsating_stress(
        self: "Self", value: "float"
    ) -> None:
        pythonnet_property_set(
            self.wrapped,
            "ContactFatigueStrengthUnderPulsatingStress",
            float(value) if value is not None else 0.0,
        )

    @property
    def cast_to(
        self: "Self",
    ) -> "_Cast_StressCyclesDataForTheContactSNCurveOfAPlasticMaterial":
        """Cast to another type.

        Returns:
            _Cast_StressCyclesDataForTheContactSNCurveOfAPlasticMaterial
        """
        return _Cast_StressCyclesDataForTheContactSNCurveOfAPlasticMaterial(self)
