"""Eigenmode"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private import _0
from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
)

_EIGENMODE = python_net_import("SMT.MastaAPI.MathUtility", "Eigenmode")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="Eigenmode")
    CastSelf = TypeVar("CastSelf", bound="Eigenmode._Cast_Eigenmode")


__docformat__ = "restructuredtext en"
__all__ = ("Eigenmode",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_Eigenmode:
    """Special nested class for casting Eigenmode to subclasses."""

    __parent__: "Eigenmode"

    @property
    def eigenmode(self: "CastSelf") -> "Eigenmode":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class Eigenmode(_0.APIBase):
    """Eigenmode

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _EIGENMODE

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def frequency(self: "Self") -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Frequency")

        if temp is None:
            return 0.0

        return temp

    @property
    def name(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Name")

        if temp is None:
            return ""

        return temp

    @property
    def cast_to(self: "Self") -> "_Cast_Eigenmode":
        """Cast to another type.

        Returns:
            _Cast_Eigenmode
        """
        return _Cast_Eigenmode(self)
