"""VectorWithLinearAndAngularComponents"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private import _0
from mastapy._private._internal import conversion, utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
    pythonnet_property_set,
)
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._math.vector_3d import Vector3D

_VECTOR_WITH_LINEAR_AND_ANGULAR_COMPONENTS = python_net_import(
    "SMT.MastaAPI.MathUtility.MeasuredVectors", "VectorWithLinearAndAngularComponents"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="VectorWithLinearAndAngularComponents")
    CastSelf = TypeVar(
        "CastSelf",
        bound="VectorWithLinearAndAngularComponents._Cast_VectorWithLinearAndAngularComponents",
    )


__docformat__ = "restructuredtext en"
__all__ = ("VectorWithLinearAndAngularComponents",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_VectorWithLinearAndAngularComponents:
    """Special nested class for casting VectorWithLinearAndAngularComponents to subclasses."""

    __parent__: "VectorWithLinearAndAngularComponents"

    @property
    def vector_with_linear_and_angular_components(
        self: "CastSelf",
    ) -> "VectorWithLinearAndAngularComponents":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class VectorWithLinearAndAngularComponents(_0.APIBase):
    """VectorWithLinearAndAngularComponents

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _VECTOR_WITH_LINEAR_AND_ANGULAR_COMPONENTS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def name(self: "Self") -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Name")

        if temp is None:
            return ""

        return temp

    @property
    def angular(self: "Self") -> "Vector3D":
        """Vector3D

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Angular")

        if temp is None:
            return None

        value = conversion.pn_to_mp_vector3d(temp)

        if value is None:
            return None

        return value

    @property
    def linear(self: "Self") -> "Vector3D":
        """Vector3D

        Note:
            This property is readonly.
        """
        temp = pythonnet_property_get(self.wrapped, "Linear")

        if temp is None:
            return None

        value = conversion.pn_to_mp_vector3d(temp)

        if value is None:
            return None

        return value

    @property
    def theta_x(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "ThetaX")

        if temp is None:
            return 0.0

        return temp

    @theta_x.setter
    @enforce_parameter_types
    def theta_x(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "ThetaX", float(value) if value is not None else 0.0
        )

    @property
    def theta_y(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "ThetaY")

        if temp is None:
            return 0.0

        return temp

    @theta_y.setter
    @enforce_parameter_types
    def theta_y(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "ThetaY", float(value) if value is not None else 0.0
        )

    @property
    def theta_z(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "ThetaZ")

        if temp is None:
            return 0.0

        return temp

    @theta_z.setter
    @enforce_parameter_types
    def theta_z(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "ThetaZ", float(value) if value is not None else 0.0
        )

    @property
    def x(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "X")

        if temp is None:
            return 0.0

        return temp

    @x.setter
    @enforce_parameter_types
    def x(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "X", float(value) if value is not None else 0.0
        )

    @property
    def y(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "Y")

        if temp is None:
            return 0.0

        return temp

    @y.setter
    @enforce_parameter_types
    def y(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "Y", float(value) if value is not None else 0.0
        )

    @property
    def z(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "Z")

        if temp is None:
            return 0.0

        return temp

    @z.setter
    @enforce_parameter_types
    def z(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "Z", float(value) if value is not None else 0.0
        )

    @property
    def cast_to(self: "Self") -> "_Cast_VectorWithLinearAndAngularComponents":
        """Cast to another type.

        Returns:
            _Cast_VectorWithLinearAndAngularComponents
        """
        return _Cast_VectorWithLinearAndAngularComponents(self)
