"""ThermalExpansionOrthotropicComponents"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private import _0
from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import (
    python_net_import,
    pythonnet_property_get,
    pythonnet_property_set,
)
from mastapy._private._internal.type_enforcement import enforce_parameter_types

_THERMAL_EXPANSION_ORTHOTROPIC_COMPONENTS = python_net_import(
    "SMT.MastaAPI.NodalAnalysis.DevToolsAnalyses.FullFEReporting",
    "ThermalExpansionOrthotropicComponents",
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="ThermalExpansionOrthotropicComponents")
    CastSelf = TypeVar(
        "CastSelf",
        bound="ThermalExpansionOrthotropicComponents._Cast_ThermalExpansionOrthotropicComponents",
    )


__docformat__ = "restructuredtext en"
__all__ = ("ThermalExpansionOrthotropicComponents",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_ThermalExpansionOrthotropicComponents:
    """Special nested class for casting ThermalExpansionOrthotropicComponents to subclasses."""

    __parent__: "ThermalExpansionOrthotropicComponents"

    @property
    def thermal_expansion_orthotropic_components(
        self: "CastSelf",
    ) -> "ThermalExpansionOrthotropicComponents":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class ThermalExpansionOrthotropicComponents(_0.APIBase):
    """ThermalExpansionOrthotropicComponents

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _THERMAL_EXPANSION_ORTHOTROPIC_COMPONENTS

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def x(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "X")

        if temp is None:
            return 0.0

        return temp

    @x.setter
    @enforce_parameter_types
    def x(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "X", float(value) if value is not None else 0.0
        )

    @property
    def y(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "Y")

        if temp is None:
            return 0.0

        return temp

    @y.setter
    @enforce_parameter_types
    def y(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "Y", float(value) if value is not None else 0.0
        )

    @property
    def z(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "Z")

        if temp is None:
            return 0.0

        return temp

    @z.setter
    @enforce_parameter_types
    def z(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "Z", float(value) if value is not None else 0.0
        )

    @property
    def cast_to(self: "Self") -> "_Cast_ThermalExpansionOrthotropicComponents":
        """Cast to another type.

        Returns:
            _Cast_ThermalExpansionOrthotropicComponents
        """
        return _Cast_ThermalExpansionOrthotropicComponents(self)
