"""NullNodalEntity"""

from __future__ import annotations

from typing import ClassVar, TYPE_CHECKING

from mastapy._private._internal import utility
from mastapy._private._internal.cast_exception import CastException
from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.python_net import python_net_import
from mastapy._private.nodal_analysis.nodal_entities import _146

_NULL_NODAL_ENTITY = python_net_import(
    "SMT.MastaAPI.NodalAnalysis.NodalEntities", "NullNodalEntity"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="NullNodalEntity")
    CastSelf = TypeVar("CastSelf", bound="NullNodalEntity._Cast_NullNodalEntity")


__docformat__ = "restructuredtext en"
__all__ = ("NullNodalEntity",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_NullNodalEntity:
    """Special nested class for casting NullNodalEntity to subclasses."""

    __parent__: "NullNodalEntity"

    @property
    def nodal_entity(self: "CastSelf") -> "_146.NodalEntity":
        return self.__parent__._cast(_146.NodalEntity)

    @property
    def null_nodal_entity(self: "CastSelf") -> "NullNodalEntity":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class NullNodalEntity(_146.NodalEntity):
    """NullNodalEntity

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _NULL_NODAL_ENTITY

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def cast_to(self: "Self") -> "_Cast_NullNodalEntity":
        """Cast to another type.

        Returns:
            _Cast_NullNodalEntity
        """
        return _Cast_NullNodalEntity(self)
