
import pytest
from langchain_anthropic import ChatAnthropic
from langchain_openai import ChatOpenAI

from esperanto.providers.llm.anthropic import AnthropicLanguageModel
from esperanto.providers.llm.openai import OpenAILanguageModel
from esperanto.providers.llm.openrouter import OpenRouterLanguageModel
from esperanto.providers.llm.xai import XAILanguageModel


@pytest.fixture
def openai_model():
    return OpenAILanguageModel(
        api_key="test-key",
        model_name="gpt-3.5-turbo",
        temperature=0.7,
        max_tokens=100,
        streaming=True,
        top_p=0.9
    )

@pytest.fixture
def anthropic_model():
    return AnthropicLanguageModel(
        api_key="test-key",
        model_name="claude-2.1",
        temperature=0.7,
        max_tokens=100,
        streaming=True,
        top_p=0.9
    )

@pytest.fixture
def openrouter_model():
    return OpenRouterLanguageModel(
        api_key="test-key",
        model_name="gpt-3.5-turbo",
        temperature=0.7,
        max_tokens=100,
        streaming=True,
        top_p=0.9
    )

@pytest.fixture
def xai_model():
    return XAILanguageModel(
        api_key="test-key",
        model_name="gpt-3.5-turbo",
        temperature=0.7,
        max_tokens=100,
        streaming=True,
        top_p=0.9
    )

def test_openai_langchain_conversion(openai_model):
    langchain_model = openai_model.to_langchain()
    assert isinstance(langchain_model, ChatOpenAI)
    assert langchain_model.model_name == "gpt-3.5-turbo"
    assert langchain_model.temperature == 0.7
    assert langchain_model.max_tokens == 100
    assert langchain_model.streaming is True
    assert langchain_model.top_p == 0.9

def test_anthropic_langchain_conversion(anthropic_model):
    langchain_model = anthropic_model.to_langchain()
    assert isinstance(langchain_model, ChatAnthropic)
    assert langchain_model.model == "claude-2.1"
    assert langchain_model.temperature == 0.7
    assert langchain_model.max_tokens == 100
    assert langchain_model.streaming is True
    assert langchain_model.top_p == 0.9

def test_openrouter_langchain_conversion(openrouter_model):
    langchain_model = openrouter_model.to_langchain()
    assert isinstance(langchain_model, ChatOpenAI)
    assert langchain_model.model_name == "gpt-3.5-turbo"
    assert langchain_model.temperature == 0.7
    assert langchain_model.max_tokens == 100
    assert langchain_model.streaming is True
    assert langchain_model.top_p == 0.9
    assert langchain_model.openai_api_base == "https://openrouter.ai/api/v1"

def test_xai_langchain_conversion(xai_model):
    langchain_model = xai_model.to_langchain()
    assert isinstance(langchain_model, ChatOpenAI)
    assert langchain_model.model_name == "gpt-3.5-turbo"
    assert langchain_model.temperature == 0.7
    assert langchain_model.max_tokens == 100
    assert langchain_model.streaming is True
    assert langchain_model.top_p == 0.9
    assert langchain_model.openai_api_base == "https://api.x.ai/v1"
