import { aws_iam as iam, aws_sns as sns } from 'aws-cdk-lib';
import { Construct } from 'constructs';
interface RequiredPoliciesProps {
    /**
     * The role to assign policies to
     */
    readonly role: iam.Role;
    /**
     * The SNS topic to send notifications to
     */
    readonly snsTopic: sns.Topic;
    /**
     * The hostedZones that will be required for DNS verification with certbot
     */
    readonly hostedZones: string[];
}
export declare function assignRequiredPoliciesToRole(scope: Construct, props: RequiredPoliciesProps): void;
export {};
