import { aws_iam as iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
interface SecretsManagerStorageProps {
    /**
     * The role to attach the Secrets Manager policy to
     */
    readonly role: iam.Role;
    /**
     * The path to store the certificates in AWS Secrets Manager
     */
    readonly secretsManagerPath: string;
    /**
     * The KMS key alias to use for encryption of the certificates in Secrets Manager
     *
     * @default `alias/aws/secretsmanager`
     */
    readonly kmsKeyAlias?: string;
}
export declare function configureSecretsManagerStorage(scope: Construct, props: SecretsManagerStorageProps): void;
interface SsmStorageProps {
    /**
     * The role to attach the Secrets Manager policy to
     */
    readonly role: iam.Role;
    /**
     * The path to store the certificates in Parameter Store
     */
    readonly parameterStorePath: string;
    /**
     * The KMS key alias to use for encryption of the certificates in Secrets Manager
     *
     * @default `alias/aws/secretsmanager`
     */
    readonly kmsKeyAlias?: string;
}
export declare function configureSSMStorage(scope: Construct, props: SsmStorageProps): void;
export {};
