# -*- coding: utf-8 -*-
"""Recruitment2.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1xn_ATvYwgL3UTvjq1x_VvsvTK4PCGATs
"""

#Import Libraries.
import numpy as np
import pandas as pd

#Reading excel file.
df=pd.read_excel('/content/candidate_data2.xlsx')
df.head()

#Renaming GPA to CGPA
df.rename(columns = {'GPA':'CGPA'}, inplace = True) 
df.head()

"""## Checking null values"""

df.isnull().sum()

df.shape

df.drop(['CandidateName','EmailId','EntryDate','RoleId','CurrentEmployer'],axis=1,inplace=True)
df.head()

#Checking unique values in "Qualification column"
df.Qualification.unique()

df.drop(['Qualification'],axis=1,inplace=True)
df.head()

df.SourceId.unique()

#Checking total count of each variable in "SourceId"
source_id = df['SourceId'].value_counts(ascending=False)
source_id

#Plotting "SourceId" to see distribution of data in it.
import matplotlib.pyplot as plt
objects = ('Shine', 'Naukri', 'Referrral', 'Consultant1', 'LinkedIn', 'Indeed')
y_pos = np.arange(len(objects))
performance = [10,8,6,4,2,1]
plt.bar(y_pos, performance, align='center', alpha=0.5)
plt.xticks(y_pos, objects)
plt.ylabel('Number of sources')
plt.title('SourceId visuals')
plt.show()

#Checking Datatype.
df.dtypes

df.LastStage.unique()

"""## Mapping "LastStage" column"""

df.LastStage = df.LastStage.map( {'S1':1 , 'S2':1, 'S3':1 , 'S4':2 , 'S5':2 , 'S6':2 , 'S7':3 , 'S8':3} )
df.head(10)

"""## Mapping "SourceId" column"""

df.SourceId = df.SourceId.map( {'LinkedIn':4 , 'Naukri':3, 'Shine':2 , 'Indeed':1 , 'Consultant1':5 , 'Consultant2':5 , 'Referral':6} )
df.head(10)

df.shape

x =df.drop(['LastStage','CurrentCTC','ExpectedCTC'],axis='columns')
x.head(10)

y=df.LastStage
y.head()

x.shape

y.shape

df.describe()

"""## Splitting dataset to train & test data"""

from sklearn.model_selection import train_test_split
x_train, x_test, y_train, y_test = train_test_split(x,y,test_size=0.2,random_state=10)

#Importing Classifiers
from sklearn.neighbors import KNeighborsClassifier
from sklearn.tree import DecisionTreeClassifier
from sklearn.ensemble import RandomForestClassifier
from sklearn.naive_bayes import GaussianNB
from sklearn.svm import SVC
from xgboost import XGBClassifier

#Import KFold cross val technique.
from sklearn.model_selection import KFold
from sklearn.model_selection import cross_val_score
k_fold = KFold(n_splits=10, shuffle=True, random_state=0)

"""## Decision Tree Classifier"""

dtc = DecisionTreeClassifier()
dtc.fit(x_train,y_train)
scoring = 'accuracy'
score = cross_val_score(dtc, x_train, y_train, cv=k_fold, n_jobs=1, scoring=scoring)
print(score)

dtc_score=round(np.mean(score)*100, 2)
dtc_score

"""## Random Forest Classifier"""

rfc = RandomForestClassifier(n_estimators=30)
rfc.fit(x_train,y_train)
scoring = 'accuracy'
score = cross_val_score(rfc, x_train, y_train, cv=k_fold, n_jobs=1, scoring=scoring)
print(score)

rfc_score=round(np.mean(score)*100, 2)
rfc_score

"""## KNN Classifier"""

knn = KNeighborsClassifier(n_neighbors = 3)
scoring='accuracy'
knn.fit(x_train, y_train)
score = cross_val_score(knn, x_train, y_train, cv=k_fold, n_jobs=1,)
print(score)

knn_score=round(np.mean(score)*100, 2)
knn_score

"""## NaiveBayes Classifier"""

gaussian = GaussianNB()
gaussian.fit(x_train, y_train)
guassian_score=round(gaussian.score(x_train, y_train) * 100, 2)
guassian_score

"""## Support Vector Machine"""

svc = SVC()
svc.fit(x_train, y_train)
svc_score= round(svc.score(x_train, y_train) * 100, 2)
svc_score

"""## XGBoost Classifier"""

xgb=XGBClassifier()
xgb.fit(x_train,y_train)
xgb_score=round(xgb.score(x_train,y_train)*100,2)
xgb_score

"""## Checking which is  the best model to predict"""

models = pd.DataFrame({
        'Model': ['Support Vector Machine', 'KNN', 'Random Forest', 'Naive Bayes Classifier', 'Decision Tree','XGBoost Classifier'],
        'Score': [svc_score, knn_score, rfc_score, 
              guassian_score, dtc_score, xgb_score]
    })
models.sort_values(by='Score', ascending=False)

x_test.head(10)

"""## Now, finally its time to predict the data."""

#Predicting on input data as: QualLevel=5 i.e MS/MTech, CGPA=9, CurrentExperience=3, SourceId=6 Referral.
rfc.predict([[3,3,3,4]])

"""#### Gives output as 3 i.e Stage  7 & 8 !!!!!"""

