"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRestoreTask = exports.RosDownload = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosDownloadProps`
 *
 * @param properties - the TypeScript properties of a `RosDownloadProps`
 *
 * @returns the result of the validation.
 */
function RosDownloadPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('bakSetId', ros.validateString)(properties.bakSetId));
    errors.collect(ros.propertyValidator('instanceName', ros.requiredValidator)(properties.instanceName));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    errors.collect(ros.propertyValidator('downloadPointInTime', ros.validateString)(properties.downloadPointInTime));
    errors.collect(ros.propertyValidator('bakSetType', ros.validateString)(properties.bakSetType));
    errors.collect(ros.propertyValidator('bakSetSize', ros.validateString)(properties.bakSetSize));
    errors.collect(ros.propertyValidator('targetPath', ros.validateString)(properties.targetPath));
    errors.collect(ros.propertyValidator('targetType', ros.validateString)(properties.targetType));
    errors.collect(ros.propertyValidator('targetOssRegion', ros.validateString)(properties.targetOssRegion));
    errors.collect(ros.propertyValidator('deleteBackupSetInOss', ros.validateBoolean)(properties.deleteBackupSetInOss));
    errors.collect(ros.propertyValidator('targetBucket', ros.validateString)(properties.targetBucket));
    errors.collect(ros.propertyValidator('formatType', ros.requiredValidator)(properties.formatType));
    errors.collect(ros.propertyValidator('formatType', ros.validateString)(properties.formatType));
    if (properties.downloadAddressDuration && (typeof properties.downloadAddressDuration) !== 'object') {
        errors.collect(ros.propertyValidator('downloadAddressDuration', ros.validateRange)({
            data: properties.downloadAddressDuration,
            min: 300,
            max: 86400,
        }));
    }
    errors.collect(ros.propertyValidator('downloadAddressDuration', ros.validateNumber)(properties.downloadAddressDuration));
    return errors.wrap('supplied properties not correct for "RosDownloadProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DBS::Download` resource
 *
 * @param properties - the TypeScript properties of a `RosDownloadProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DBS::Download` resource.
 */
// @ts-ignore TS6133
function rosDownloadPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDownloadPropsValidator(properties).assertSuccess();
    }
    return {
        FormatType: ros.stringToRosTemplate(properties.formatType),
        InstanceName: ros.stringToRosTemplate(properties.instanceName),
        BakSetId: ros.stringToRosTemplate(properties.bakSetId),
        BakSetSize: ros.stringToRosTemplate(properties.bakSetSize),
        BakSetType: ros.stringToRosTemplate(properties.bakSetType),
        DeleteBackupSetInOss: ros.booleanToRosTemplate(properties.deleteBackupSetInOss),
        DownloadAddressDuration: ros.numberToRosTemplate(properties.downloadAddressDuration),
        DownloadPointInTime: ros.stringToRosTemplate(properties.downloadPointInTime),
        TargetBucket: ros.stringToRosTemplate(properties.targetBucket),
        TargetOssRegion: ros.stringToRosTemplate(properties.targetOssRegion),
        TargetPath: ros.stringToRosTemplate(properties.targetPath),
        TargetType: ros.stringToRosTemplate(properties.targetType),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DBS::Download`, which is used to create an advanced download task.
 * @Note This class does not contain additional functions, so it is recommended to use the `Download` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-download
 */
class RosDownload extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDownload.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrBakSetId = this.getAtt('BakSetId');
        this.attrDownloadAddressInfo = this.getAtt('DownloadAddressInfo');
        this.attrInstanceName = this.getAtt('InstanceName');
        this.attrTaskId = this.getAtt('TaskId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.formatType = props.formatType;
        this.instanceName = props.instanceName;
        this.bakSetId = props.bakSetId;
        this.bakSetSize = props.bakSetSize;
        this.bakSetType = props.bakSetType;
        this.deleteBackupSetInOss = props.deleteBackupSetInOss;
        this.downloadAddressDuration = props.downloadAddressDuration;
        this.downloadPointInTime = props.downloadPointInTime;
        this.targetBucket = props.targetBucket;
        this.targetOssRegion = props.targetOssRegion;
        this.targetPath = props.targetPath;
        this.targetType = props.targetType;
    }
    get rosProperties() {
        return {
            formatType: this.formatType,
            instanceName: this.instanceName,
            bakSetId: this.bakSetId,
            bakSetSize: this.bakSetSize,
            bakSetType: this.bakSetType,
            deleteBackupSetInOss: this.deleteBackupSetInOss,
            downloadAddressDuration: this.downloadAddressDuration,
            downloadPointInTime: this.downloadPointInTime,
            targetBucket: this.targetBucket,
            targetOssRegion: this.targetOssRegion,
            targetPath: this.targetPath,
            targetType: this.targetType,
        };
    }
    renderProperties(props) {
        return rosDownloadPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDownload = RosDownload;
/**
 * The resource type name for this resource class.
 */
RosDownload.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DBS::Download";
/**
 * Determine whether the given properties match those of a `RosRestoreTaskProps`
 *
 * @param properties - the TypeScript properties of a `RosRestoreTaskProps`
 *
 * @returns the result of the validation.
 */
function RosRestoreTaskPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('startTask', ros.validateBoolean)(properties.startTask));
    errors.collect(ros.propertyValidator('restoreDir', ros.validateString)(properties.restoreDir));
    if (properties.duplicateConflict && (typeof properties.duplicateConflict) !== 'object') {
        errors.collect(ros.propertyValidator('duplicateConflict', ros.validateAllowedValues)({
            data: properties.duplicateConflict,
            allowedValues: ["failure", "renamenew"],
        }));
    }
    errors.collect(ros.propertyValidator('duplicateConflict', ros.validateString)(properties.duplicateConflict));
    errors.collect(ros.propertyValidator('restoreHome', ros.validateString)(properties.restoreHome));
    errors.collect(ros.propertyValidator('destinationEndpointPassword', ros.validateString)(properties.destinationEndpointPassword));
    errors.collect(ros.propertyValidator('destinationEndpointIp', ros.validateString)(properties.destinationEndpointIp));
    errors.collect(ros.propertyValidator('destinationEndpointPort', ros.validateNumber)(properties.destinationEndpointPort));
    errors.collect(ros.propertyValidator('destinationEndpointOracleSid', ros.validateString)(properties.destinationEndpointOracleSid));
    errors.collect(ros.propertyValidator('backupSetId', ros.validateString)(properties.backupSetId));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceType', ros.requiredValidator)(properties.destinationEndpointInstanceType));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceType', ros.validateString)(properties.destinationEndpointInstanceType));
    errors.collect(ros.propertyValidator('restoreTime', ros.validateNumber)(properties.restoreTime));
    errors.collect(ros.propertyValidator('destinationEndpointRegion', ros.validateString)(properties.destinationEndpointRegion));
    errors.collect(ros.propertyValidator('destinationEndpointDatabaseName', ros.validateString)(properties.destinationEndpointDatabaseName));
    errors.collect(ros.propertyValidator('destinationEndpointUserName', ros.validateString)(properties.destinationEndpointUserName));
    errors.collect(ros.propertyValidator('restoreObjects', ros.validateString)(properties.restoreObjects));
    errors.collect(ros.propertyValidator('restoreTaskName', ros.requiredValidator)(properties.restoreTaskName));
    errors.collect(ros.propertyValidator('restoreTaskName', ros.validateString)(properties.restoreTaskName));
    errors.collect(ros.propertyValidator('backupPlanId', ros.requiredValidator)(properties.backupPlanId));
    errors.collect(ros.propertyValidator('backupPlanId', ros.validateString)(properties.backupPlanId));
    errors.collect(ros.propertyValidator('backupGatewayId', ros.validateNumber)(properties.backupGatewayId));
    errors.collect(ros.propertyValidator('destinationEndpointInstanceId', ros.validateString)(properties.destinationEndpointInstanceId));
    return errors.wrap('supplied properties not correct for "RosRestoreTaskProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DBS::RestoreTask` resource
 *
 * @param properties - the TypeScript properties of a `RosRestoreTaskProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DBS::RestoreTask` resource.
 */
// @ts-ignore TS6133
function rosRestoreTaskPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRestoreTaskPropsValidator(properties).assertSuccess();
    }
    return {
        BackupPlanId: ros.stringToRosTemplate(properties.backupPlanId),
        DestinationEndpointInstanceType: ros.stringToRosTemplate(properties.destinationEndpointInstanceType),
        RestoreTaskName: ros.stringToRosTemplate(properties.restoreTaskName),
        BackupGatewayId: ros.numberToRosTemplate(properties.backupGatewayId),
        BackupSetId: ros.stringToRosTemplate(properties.backupSetId),
        DestinationEndpointDatabaseName: ros.stringToRosTemplate(properties.destinationEndpointDatabaseName),
        DestinationEndpointInstanceID: ros.stringToRosTemplate(properties.destinationEndpointInstanceId),
        DestinationEndpointIP: ros.stringToRosTemplate(properties.destinationEndpointIp),
        DestinationEndpointOracleSID: ros.stringToRosTemplate(properties.destinationEndpointOracleSid),
        DestinationEndpointPassword: ros.stringToRosTemplate(properties.destinationEndpointPassword),
        DestinationEndpointPort: ros.numberToRosTemplate(properties.destinationEndpointPort),
        DestinationEndpointRegion: ros.stringToRosTemplate(properties.destinationEndpointRegion),
        DestinationEndpointUserName: ros.stringToRosTemplate(properties.destinationEndpointUserName),
        DuplicateConflict: ros.stringToRosTemplate(properties.duplicateConflict),
        RestoreDir: ros.stringToRosTemplate(properties.restoreDir),
        RestoreHome: ros.stringToRosTemplate(properties.restoreHome),
        RestoreObjects: ros.stringToRosTemplate(properties.restoreObjects),
        RestoreTime: ros.numberToRosTemplate(properties.restoreTime),
        StartTask: ros.booleanToRosTemplate(properties.startTask),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DBS::RestoreTask`, which is used to create a restore task.
 * @Note This class does not contain additional functions, so it is recommended to use the `RestoreTask` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-restoretask
 */
class RosRestoreTask extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRestoreTask.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrRestoreTaskId = this.getAtt('RestoreTaskId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.backupPlanId = props.backupPlanId;
        this.destinationEndpointInstanceType = props.destinationEndpointInstanceType;
        this.restoreTaskName = props.restoreTaskName;
        this.backupGatewayId = props.backupGatewayId;
        this.backupSetId = props.backupSetId;
        this.destinationEndpointDatabaseName = props.destinationEndpointDatabaseName;
        this.destinationEndpointInstanceId = props.destinationEndpointInstanceId;
        this.destinationEndpointIp = props.destinationEndpointIp;
        this.destinationEndpointOracleSid = props.destinationEndpointOracleSid;
        this.destinationEndpointPassword = props.destinationEndpointPassword;
        this.destinationEndpointPort = props.destinationEndpointPort;
        this.destinationEndpointRegion = props.destinationEndpointRegion;
        this.destinationEndpointUserName = props.destinationEndpointUserName;
        this.duplicateConflict = props.duplicateConflict;
        this.restoreDir = props.restoreDir;
        this.restoreHome = props.restoreHome;
        this.restoreObjects = props.restoreObjects;
        this.restoreTime = props.restoreTime;
        this.startTask = props.startTask;
    }
    get rosProperties() {
        return {
            backupPlanId: this.backupPlanId,
            destinationEndpointInstanceType: this.destinationEndpointInstanceType,
            restoreTaskName: this.restoreTaskName,
            backupGatewayId: this.backupGatewayId,
            backupSetId: this.backupSetId,
            destinationEndpointDatabaseName: this.destinationEndpointDatabaseName,
            destinationEndpointInstanceId: this.destinationEndpointInstanceId,
            destinationEndpointIp: this.destinationEndpointIp,
            destinationEndpointOracleSid: this.destinationEndpointOracleSid,
            destinationEndpointPassword: this.destinationEndpointPassword,
            destinationEndpointPort: this.destinationEndpointPort,
            destinationEndpointRegion: this.destinationEndpointRegion,
            destinationEndpointUserName: this.destinationEndpointUserName,
            duplicateConflict: this.duplicateConflict,
            restoreDir: this.restoreDir,
            restoreHome: this.restoreHome,
            restoreObjects: this.restoreObjects,
            restoreTime: this.restoreTime,
            startTask: this.startTask,
        };
    }
    renderProperties(props) {
        return rosRestoreTaskPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRestoreTask = RosRestoreTask;
/**
 * The resource type name for this resource class.
 */
RosRestoreTask.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DBS::RestoreTask";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGJzLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRicy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHlEQUF5RDs7O0FBRXpELDhDQUE4QztBQXNGOUM7Ozs7OztHQU1HO0FBQ0gsU0FBUyx5QkFBeUIsQ0FBQyxVQUFlO0lBQzlDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ3RHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDbkcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDcEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDbEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixJQUFHLFVBQVUsQ0FBQyx1QkFBdUIsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLHVCQUF1QixDQUFDLEtBQUssUUFBUSxFQUFFO1FBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUMvRSxJQUFJLEVBQUUsVUFBVSxDQUFDLHVCQUF1QjtZQUN4QyxHQUFHLEVBQUUsR0FBRztZQUNSLEdBQUcsRUFBRSxLQUFLO1NBQ1gsQ0FBQyxDQUFDLENBQUM7S0FDVDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQ3pILE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyx3REFBd0QsQ0FBQyxDQUFDO0FBQ2pGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2QkFBNkIsQ0FBQyxVQUFlLEVBQUUsZ0NBQXlDO0lBQzdGLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxJQUFHLGdDQUFnQyxFQUFFO1FBQ2pDLHlCQUF5QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0tBQ3pEO0lBQ0QsT0FBTztRQUNMLFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxZQUFZLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUM7UUFDOUQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3RELFVBQVUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUMxRCxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDMUQsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLG9CQUFvQixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUMvRSx1QkFBdUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO1FBQ3BGLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDNUUsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzlELGVBQWUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUNwRSxVQUFVLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDMUQsVUFBVSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO0tBQzNELENBQUM7QUFDTixDQUFDO0FBRUQ7Ozs7R0FJRztBQUNILE1BQWEsV0FBWSxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBMEc1Qzs7OztPQUlHO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUF1QixFQUFFLGdDQUF5QztRQUM1RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxXQUFXLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7UUFDbEYsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDbEUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDcEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBRXhDLElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUN6RSxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsb0JBQW9CLENBQUM7UUFDdkQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztRQUM3RCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUN2QyxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBQ25DLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztJQUN2QyxDQUFDO0lBR0QsSUFBYyxhQUFhO1FBQ3ZCLE9BQU87WUFDSCxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLG9CQUFvQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDL0MsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QjtZQUNyRCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzdDLFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQixlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtTQUM5QixDQUFDO0lBQ04sQ0FBQztJQUNTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sNkJBQTZCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ3ZGLENBQUM7O0FBeEpMLGtDQXlKQztBQXhKRzs7R0FFRztBQUNvQixrQ0FBc0IsR0FBRyx1QkFBdUIsQ0FBQztBQXFSNUU7Ozs7OztHQU1HO0FBQ0gsU0FBUyw0QkFBNEIsQ0FBQyxVQUFlO0lBQ2pELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUMvRixJQUFHLFVBQVUsQ0FBQyxpQkFBaUIsSUFBSSxDQUFDLE9BQU8sVUFBVSxDQUFDLGlCQUFpQixDQUFDLEtBQUssUUFBUSxFQUFFO1FBQ25GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQ25GLElBQUksRUFBRSxVQUFVLENBQUMsaUJBQWlCO1lBQ2xDLGFBQWEsRUFBRSxDQUFDLFNBQVMsRUFBQyxXQUFXLENBQUM7U0FDdkMsQ0FBQyxDQUFDLENBQUM7S0FDUDtJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDakksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsdUJBQXVCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUM7SUFDckgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDekgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsOEJBQThCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLENBQUM7SUFDbkksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNqRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQ0FBaUMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsK0JBQStCLENBQUMsQ0FBQyxDQUFDO0lBQzVJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlDQUFpQyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsK0JBQStCLENBQUMsQ0FBQyxDQUFDO0lBQ3pJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDakcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMkJBQTJCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDLENBQUM7SUFDN0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsaUNBQWlDLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDLENBQUM7SUFDekksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsNkJBQTZCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDLENBQUM7SUFDakksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxlQUFlLENBQUMsQ0FBQyxDQUFDO0lBQzVHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQztJQUN6RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDdEcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUNuRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxpQkFBaUIsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUM7SUFDekcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsK0JBQStCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDLENBQUM7SUFDckksT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLDJEQUEyRCxDQUFDLENBQUM7QUFDcEYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLGdDQUFnQyxDQUFDLFVBQWUsRUFBRSxnQ0FBeUM7SUFDaEcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELElBQUcsZ0NBQWdDLEVBQUU7UUFDakMsNEJBQTRCLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7S0FDNUQ7SUFDRCxPQUFPO1FBQ0wsWUFBWSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzlELCtCQUErQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsK0JBQStCLENBQUM7UUFDcEcsZUFBZSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDO1FBQ3BFLGVBQWUsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUNwRSxXQUFXLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDNUQsK0JBQStCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQywrQkFBK0IsQ0FBQztRQUNwRyw2QkFBNkIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLDZCQUE2QixDQUFDO1FBQ2hHLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDaEYsNEJBQTRCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyw0QkFBNEIsQ0FBQztRQUM5RiwyQkFBMkIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDO1FBQzVGLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDcEYseUJBQXlCLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyx5QkFBeUIsQ0FBQztRQUN4RiwyQkFBMkIsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLDJCQUEyQixDQUFDO1FBQzVGLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDeEUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDO1FBQzFELFdBQVcsRUFBRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUM1RCxjQUFjLEVBQUUsR0FBRyxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7UUFDbEUsV0FBVyxFQUFFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQzVELFNBQVMsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztLQUMxRCxDQUFDO0FBQ04sQ0FBQztBQUVEOzs7O0dBSUc7QUFDSCxNQUFhLGNBQWUsU0FBUSxHQUFHLENBQUMsV0FBVztJQXFJL0M7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBMEIsRUFBRSxnQ0FBeUM7UUFDL0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsY0FBYyxDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDO1FBQ3JGLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBRXRELElBQUksQ0FBQyxnQ0FBZ0MsR0FBRyxnQ0FBZ0MsQ0FBQztRQUN6RSxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLCtCQUErQixHQUFHLEtBQUssQ0FBQywrQkFBK0IsQ0FBQztRQUM3RSxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDN0MsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsZUFBZSxDQUFDO1FBQzdDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsK0JBQStCLEdBQUcsS0FBSyxDQUFDLCtCQUErQixDQUFDO1FBQzdFLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUMsNkJBQTZCLENBQUM7UUFDekUsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztRQUN6RCxJQUFJLENBQUMsNEJBQTRCLEdBQUcsS0FBSyxDQUFDLDRCQUE0QixDQUFDO1FBQ3ZFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUMsMkJBQTJCLENBQUM7UUFDckUsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyx1QkFBdUIsQ0FBQztRQUM3RCxJQUFJLENBQUMseUJBQXlCLEdBQUcsS0FBSyxDQUFDLHlCQUF5QixDQUFDO1FBQ2pFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxLQUFLLENBQUMsMkJBQTJCLENBQUM7UUFDckUsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztRQUNqRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO0lBQ3JDLENBQUM7SUFHRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFlBQVksRUFBRSxJQUFJLENBQUMsWUFBWTtZQUMvQiwrQkFBK0IsRUFBRSxJQUFJLENBQUMsK0JBQStCO1lBQ3JFLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDckMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLCtCQUErQixFQUFFLElBQUksQ0FBQywrQkFBK0I7WUFDckUsNkJBQTZCLEVBQUUsSUFBSSxDQUFDLDZCQUE2QjtZQUNqRSxxQkFBcUIsRUFBRSxJQUFJLENBQUMscUJBQXFCO1lBQ2pELDRCQUE0QixFQUFFLElBQUksQ0FBQyw0QkFBNEI7WUFDL0QsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDJCQUEyQjtZQUM3RCx1QkFBdUIsRUFBRSxJQUFJLENBQUMsdUJBQXVCO1lBQ3JELHlCQUF5QixFQUFFLElBQUksQ0FBQyx5QkFBeUI7WUFDekQsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLDJCQUEyQjtZQUM3RCxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7U0FDNUIsQ0FBQztJQUNOLENBQUM7SUFDUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLGdDQUFnQyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUMxRixDQUFDOztBQTlMTCx3Q0ErTEM7QUE5TEc7O0dBRUc7QUFDb0IscUNBQXNCLEdBQUcsMEJBQTBCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cblxuaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYFJvc0Rvd25sb2FkYC5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWRicy1kb3dubG9hZFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJvc0Rvd25sb2FkUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGZvcm1hdFR5cGU6IFRoZSBmb3JtYXQgdG8gd2hpY2ggdGhlIGRvd25sb2FkZWQgYmFja3VwIHNldCBpcyBjb252ZXJ0ZWQuIFxuICAgICAqIFZhbGlkIHZhbHVlczogQ1NWfFNRTHxQYXJxdWV0XG4gICAgICovXG4gICAgcmVhZG9ubHkgZm9ybWF0VHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGluc3RhbmNlTmFtZTogVGhlIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBpbnN0YW5jZU5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBiYWtTZXRJZDogVGhlIElEIG9mIHRoZSBiYWNrdXAgc2V0LiBZb3UgY2FuIGNhbGwgdGhlIERlc2NyaWJlQmFja3VwcyBvcGVyYXRpb24gdG8gcXVlcnkgdGhlIElEIG9mIHRoZSBiYWNrdXAgc2V0LlxuICAgICAqIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIGlmIHRoZSBCYWtTZXRUeXBlIHBhcmFtZXRlciBpcyBzZXQgdG8gZnVsbC5cbiAgICAgKi9cbiAgICByZWFkb25seSBiYWtTZXRJZD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBiYWtTZXRTaXplOiBUaGUgc2l6ZSBvZiB0aGUgZnVsbCBiYWNrdXAgc2V0LiBVbml0OiBieXRlcy4gXG4gICAgICogWW91IGNhbiBjYWxsIHRoZSBEZXNjcmliZUJhY2t1cHMgb3BlcmF0aW9uIHRvIHF1ZXJ5IHRoZSBzaXplIG9mIHRoZSBmdWxsIGJhY2t1cCBzZXQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmFrU2V0U2l6ZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBiYWtTZXRUeXBlOiBUaGUgdHlwZSBvZiB0aGUgZG93bmxvYWQgdGFzay4gVmFsaWQgdmFsdWVzOlxuICAgICAqIGZ1bGw6IGRvd25sb2FkcyBhIGZ1bGwgYmFja3VwIHNldFxuICAgICAqIHBpdHI6IGRvd25sb2FkcyBhIGJhY2t1cCBzZXQgYXQgYSBzcGVjaWZpYyBwb2ludCBpbiB0aW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJha1NldFR5cGU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVsZXRlQmFja3VwU2V0SW5Pc3M6IFdoZXRoZXIgdG8gZGVsZXRlIHRoZSBiYWNrdXAgc2V0IGluIE9TUyB3aGVuIGRlbGV0aW5nIHRoZSBzdGFjay5cbiAgICAgKiBWYWxpZCB2YWx1ZXM6IHRydWV8ZmFsc2UsIGRlZmF1bHQgaXMgdHJ1ZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZWxldGVCYWNrdXBTZXRJbk9zcz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZG93bmxvYWRBZGRyZXNzRHVyYXRpb246IFdoZW4gdGhlIGRvd25sb2FkIHRhcmdldCBpcyBhIFVSTCwgc2V0IHRoZSBsaW5rIHZhbGlkaXR5IHBlcmlvZC4gXG4gICAgICogVGhlIGRlZmF1bHQgVVJMIHZhbGlkaXR5IHBlcmlvZCBpcyA3MjAwIHNlY29uZHMuIFxuICAgICAqIFRoZSBlZmZlY3RpdmUgZHVyYXRpb24gcmFuZ2UgY2FuIGJlIHNldCBmcm9tIDMwMCBzZWNvbmRzIHRvIDg2NDAwIHNlY29uZHNcbiAgICAgKi9cbiAgICByZWFkb25seSBkb3dubG9hZEFkZHJlc3NEdXJhdGlvbj86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkb3dubG9hZFBvaW50SW5UaW1lOiBUaGUgcG9pbnQgaW4gdGltZSBhdCB3aGljaCB0aGUgYmFja3VwIHNldCBpcyBkb3dubG9hZGVkLiBcbiAgICAgKiBTcGVjaWZ5IGEgVU5JWCB0aW1lc3RhbXAgcmVwcmVzZW50aW5nIHRoZSBudW1iZXIgb2YgbWlsbGlzZWNvbmRzIHRoYXQgaGF2ZSBlbGFwc2VkIHNpbmNlIEphbnVhcnkgMSwgMTk3MCwgMDA6MDA6MDAgVVRDLlxuICAgICAqIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIGlmIHRoZSBCYWtTZXRUeXBlIHBhcmFtZXRlciBpcyBzZXQgdG8gcGl0ci5cbiAgICAgKi9cbiAgICByZWFkb25seSBkb3dubG9hZFBvaW50SW5UaW1lPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRhcmdldEJ1Y2tldDogVGhlIG5hbWUgb2YgdGhlIE9TUyBidWNrZXQgdGhhdCBpcyB1c2VkIHRvIHN0b3JlIHRoZSBiYWNrdXAgc2V0LlxuICAgICAqIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIGlmIHRoZSBUYXJnZXRUeXBlIHBhcmFtZXRlciBpcyBzZXQgdG8gT1NTLlxuICAgICAqIE1ha2Ugc3VyZSB0aGF0IHlvdXIgYWNjb3VudCBpcyBncmFudGVkIHRoZSBBbGl5dW5EQlNEZWZhdWx0Um9sZSBwZXJtaXNzaW9uLiBcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFVzZSBSQU0gZm9yIHJlc291cmNlIGF1dGhvcml6YXRpb24uIFxuICAgICAqIFlvdSBjYW4gYWxzbyBncmFudCBwZXJtaXNzaW9ucyBiYXNlZCBvbiB0aGUgb3BlcmF0aW9uIGluc3RydWN0aW9ucyBpbiB0aGUgUmVzb3VyY2UgQWNjZXNzIE1hbmFnZW1lbnQgKFJBTSkgY29uc29sZS5cbiAgICAgKi9cbiAgICByZWFkb25seSB0YXJnZXRCdWNrZXQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdGFyZ2V0T3NzUmVnaW9uOiBUaGUgcmVnaW9uIGluIHdoaWNoIHRoZSBPU1MgYnVja2V0IHJlc2lkZXMuXG4gICAgICogVGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgaWYgdGhlIFRhcmdldFR5cGUgcGFyYW1ldGVyIGlzIHNldCB0byBPU1MuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0T3NzUmVnaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRhcmdldFBhdGg6IFRoZSBkZXN0aW5hdGlvbiBwYXRoIHRvIHdoaWNoIHRoZSBiYWNrdXAgc2V0IGlzIGRvd25sb2FkZWQuXG4gICAgICogVGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgaWYgdGhlIFRhcmdldFR5cGUgcGFyYW1ldGVyIGlzIHNldCB0byBPU1MuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0UGF0aD86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSB0YXJnZXRUeXBlOiBUaGUgdHlwZSBvZiB0aGUgZGVzdGluYXRpb24gdG8gd2hpY2ggdGhlIGJhY2t1cCBzZXQgaXMgZG93bmxvYWRlZC4gXG4gICAgICogVmFsaWQgdmFsdWVzOiBPU1N8VVJMXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGFyZ2V0VHlwZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBSb3NEb3dubG9hZFByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NEb3dubG9hZFByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIFJvc0Rvd25sb2FkUHJvcHNWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogcm9zLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHJvcy5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgcm9zLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdiYWtTZXRJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5iYWtTZXRJZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VOYW1lJywgcm9zLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmluc3RhbmNlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignaW5zdGFuY2VOYW1lJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmluc3RhbmNlTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZG93bmxvYWRQb2ludEluVGltZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kb3dubG9hZFBvaW50SW5UaW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdiYWtTZXRUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmJha1NldFR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Jha1NldFNpemUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYmFrU2V0U2l6ZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGFyZ2V0UGF0aCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy50YXJnZXRQYXRoKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCd0YXJnZXRUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnRhcmdldFR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3RhcmdldE9zc1JlZ2lvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy50YXJnZXRPc3NSZWdpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2RlbGV0ZUJhY2t1cFNldEluT3NzJywgcm9zLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5kZWxldGVCYWNrdXBTZXRJbk9zcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcigndGFyZ2V0QnVja2V0Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnRhcmdldEJ1Y2tldCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZm9ybWF0VHlwZScsIHJvcy5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5mb3JtYXRUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdmb3JtYXRUeXBlJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmZvcm1hdFR5cGUpKTtcbiAgICBpZihwcm9wZXJ0aWVzLmRvd25sb2FkQWRkcmVzc0R1cmF0aW9uICYmICh0eXBlb2YgcHJvcGVydGllcy5kb3dubG9hZEFkZHJlc3NEdXJhdGlvbikgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZG93bmxvYWRBZGRyZXNzRHVyYXRpb24nLCByb3MudmFsaWRhdGVSYW5nZSkoe1xuICAgICAgICAgICAgZGF0YTogcHJvcGVydGllcy5kb3dubG9hZEFkZHJlc3NEdXJhdGlvbixcbiAgICAgICAgICAgIG1pbjogMzAwLFxuICAgICAgICAgICAgbWF4OiA4NjQwMCxcbiAgICAgICAgICB9KSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZG93bmxvYWRBZGRyZXNzRHVyYXRpb24nLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZG93bmxvYWRBZGRyZXNzRHVyYXRpb24pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUm9zRG93bmxvYWRQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6REJTOjpEb3dubG9hZGAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zRG93bmxvYWRQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIHByb3BlcnRpZXMgb2YgYW4gYEFMSVlVTjo6REJTOjpEb3dubG9hZGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiByb3NEb3dubG9hZFByb3BzVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzOiBhbnksIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKTogYW55IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgaWYoZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpIHtcbiAgICAgICAgUm9zRG93bmxvYWRQcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgfVxuICAgIHJldHVybiB7XG4gICAgICBGb3JtYXRUeXBlOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmZvcm1hdFR5cGUpLFxuICAgICAgSW5zdGFuY2VOYW1lOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmluc3RhbmNlTmFtZSksXG4gICAgICBCYWtTZXRJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5iYWtTZXRJZCksXG4gICAgICBCYWtTZXRTaXplOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmJha1NldFNpemUpLFxuICAgICAgQmFrU2V0VHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5iYWtTZXRUeXBlKSxcbiAgICAgIERlbGV0ZUJhY2t1cFNldEluT3NzOiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5kZWxldGVCYWNrdXBTZXRJbk9zcyksXG4gICAgICBEb3dubG9hZEFkZHJlc3NEdXJhdGlvbjogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5kb3dubG9hZEFkZHJlc3NEdXJhdGlvbiksXG4gICAgICBEb3dubG9hZFBvaW50SW5UaW1lOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRvd25sb2FkUG9pbnRJblRpbWUpLFxuICAgICAgVGFyZ2V0QnVja2V0OiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnRhcmdldEJ1Y2tldCksXG4gICAgICBUYXJnZXRPc3NSZWdpb246IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudGFyZ2V0T3NzUmVnaW9uKSxcbiAgICAgIFRhcmdldFBhdGg6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMudGFyZ2V0UGF0aCksXG4gICAgICBUYXJnZXRUeXBlOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnRhcmdldFR5cGUpLFxuICAgIH07XG59XG5cbi8qKlxuICogVGhpcyBjbGFzcyBpcyBhIGJhc2UgZW5jYXBzdWxhdGlvbiBhcm91bmQgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkRCUzo6RG93bmxvYWRgLCB3aGljaCBpcyB1c2VkIHRvIGNyZWF0ZSBhbiBhZHZhbmNlZCBkb3dubG9hZCB0YXNrLlxuICogQE5vdGUgVGhpcyBjbGFzcyBkb2VzIG5vdCBjb250YWluIGFkZGl0aW9uYWwgZnVuY3Rpb25zLCBzbyBpdCBpcyByZWNvbW1lbmRlZCB0byB1c2UgdGhlIGBEb3dubG9hZGAgY2xhc3MgaW5zdGVhZCBvZiB0aGlzIGNsYXNzIGZvciBhIG1vcmUgY29udmVuaWVudCBkZXZlbG9wbWVudCBleHBlcmllbmNlLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tZGJzLWRvd25sb2FkXG4gKi9cbmV4cG9ydCBjbGFzcyBSb3NEb3dubG9hZCBleHRlbmRzIHJvcy5Sb3NSZXNvdXJjZSB7XG4gICAgLyoqXG4gICAgICogVGhlIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFJPU19SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFMSVlVTjo6REJTOjpEb3dubG9hZFwiO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBCYWtTZXRJZDogVGhlIElEIG9mIHRoZSBiYWNrdXAgc2V0LlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyQmFrU2V0SWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBBdHRyaWJ1dGUgRG93bmxvYWRBZGRyZXNzSW5mbzogVGhlIGRvd25sb2FkIGFkZHJlc3MgaW5mb3JtYXRpb24uXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJEb3dubG9hZEFkZHJlc3NJbmZvOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAQXR0cmlidXRlIEluc3RhbmNlTmFtZTogVGhlIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckluc3RhbmNlTmFtZTogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQEF0dHJpYnV0ZSBUYXNrSWQ6IFRoZSBJRCBvZiB0aGUgZG93bmxvYWQgdGFzay5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0clRhc2tJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgcHVibGljIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZm9ybWF0VHlwZTogVGhlIGZvcm1hdCB0byB3aGljaCB0aGUgZG93bmxvYWRlZCBiYWNrdXAgc2V0IGlzIGNvbnZlcnRlZC4gXG4gICAgICogVmFsaWQgdmFsdWVzOiBDU1Z8U1FMfFBhcnF1ZXRcbiAgICAgKi9cbiAgICBwdWJsaWMgZm9ybWF0VHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGluc3RhbmNlTmFtZTogVGhlIElEIG9mIHRoZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zdGFuY2VOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYmFrU2V0SWQ6IFRoZSBJRCBvZiB0aGUgYmFja3VwIHNldC4gWW91IGNhbiBjYWxsIHRoZSBEZXNjcmliZUJhY2t1cHMgb3BlcmF0aW9uIHRvIHF1ZXJ5IHRoZSBJRCBvZiB0aGUgYmFja3VwIHNldC5cbiAgICAgKiBUaGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZCBpZiB0aGUgQmFrU2V0VHlwZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIGZ1bGwuXG4gICAgICovXG4gICAgcHVibGljIGJha1NldElkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYmFrU2V0U2l6ZTogVGhlIHNpemUgb2YgdGhlIGZ1bGwgYmFja3VwIHNldC4gVW5pdDogYnl0ZXMuIFxuICAgICAqIFlvdSBjYW4gY2FsbCB0aGUgRGVzY3JpYmVCYWNrdXBzIG9wZXJhdGlvbiB0byBxdWVyeSB0aGUgc2l6ZSBvZiB0aGUgZnVsbCBiYWNrdXAgc2V0LlxuICAgICAqL1xuICAgIHB1YmxpYyBiYWtTZXRTaXplOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYmFrU2V0VHlwZTogVGhlIHR5cGUgb2YgdGhlIGRvd25sb2FkIHRhc2suIFZhbGlkIHZhbHVlczpcbiAgICAgKiBmdWxsOiBkb3dubG9hZHMgYSBmdWxsIGJhY2t1cCBzZXRcbiAgICAgKiBwaXRyOiBkb3dubG9hZHMgYSBiYWNrdXAgc2V0IGF0IGEgc3BlY2lmaWMgcG9pbnQgaW4gdGltZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYmFrU2V0VHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlbGV0ZUJhY2t1cFNldEluT3NzOiBXaGV0aGVyIHRvIGRlbGV0ZSB0aGUgYmFja3VwIHNldCBpbiBPU1Mgd2hlbiBkZWxldGluZyB0aGUgc3RhY2suXG4gICAgICogVmFsaWQgdmFsdWVzOiB0cnVlfGZhbHNlLCBkZWZhdWx0IGlzIHRydWUuXG4gICAgICovXG4gICAgcHVibGljIGRlbGV0ZUJhY2t1cFNldEluT3NzOiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRvd25sb2FkQWRkcmVzc0R1cmF0aW9uOiBXaGVuIHRoZSBkb3dubG9hZCB0YXJnZXQgaXMgYSBVUkwsIHNldCB0aGUgbGluayB2YWxpZGl0eSBwZXJpb2QuIFxuICAgICAqIFRoZSBkZWZhdWx0IFVSTCB2YWxpZGl0eSBwZXJpb2QgaXMgNzIwMCBzZWNvbmRzLiBcbiAgICAgKiBUaGUgZWZmZWN0aXZlIGR1cmF0aW9uIHJhbmdlIGNhbiBiZSBzZXQgZnJvbSAzMDAgc2Vjb25kcyB0byA4NjQwMCBzZWNvbmRzXG4gICAgICovXG4gICAgcHVibGljIGRvd25sb2FkQWRkcmVzc0R1cmF0aW9uOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZG93bmxvYWRQb2ludEluVGltZTogVGhlIHBvaW50IGluIHRpbWUgYXQgd2hpY2ggdGhlIGJhY2t1cCBzZXQgaXMgZG93bmxvYWRlZC4gXG4gICAgICogU3BlY2lmeSBhIFVOSVggdGltZXN0YW1wIHJlcHJlc2VudGluZyB0aGUgbnVtYmVyIG9mIG1pbGxpc2Vjb25kcyB0aGF0IGhhdmUgZWxhcHNlZCBzaW5jZSBKYW51YXJ5IDEsIDE5NzAsIDAwOjAwOjAwIFVUQy5cbiAgICAgKiBUaGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZCBpZiB0aGUgQmFrU2V0VHlwZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIHBpdHIuXG4gICAgICovXG4gICAgcHVibGljIGRvd25sb2FkUG9pbnRJblRpbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSB0YXJnZXRCdWNrZXQ6IFRoZSBuYW1lIG9mIHRoZSBPU1MgYnVja2V0IHRoYXQgaXMgdXNlZCB0byBzdG9yZSB0aGUgYmFja3VwIHNldC5cbiAgICAgKiBUaGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZCBpZiB0aGUgVGFyZ2V0VHlwZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIE9TUy5cbiAgICAgKiBNYWtlIHN1cmUgdGhhdCB5b3VyIGFjY291bnQgaXMgZ3JhbnRlZCB0aGUgQWxpeXVuREJTRGVmYXVsdFJvbGUgcGVybWlzc2lvbi4gXG4gICAgICogRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSBVc2UgUkFNIGZvciByZXNvdXJjZSBhdXRob3JpemF0aW9uLiBcbiAgICAgKiBZb3UgY2FuIGFsc28gZ3JhbnQgcGVybWlzc2lvbnMgYmFzZWQgb24gdGhlIG9wZXJhdGlvbiBpbnN0cnVjdGlvbnMgaW4gdGhlIFJlc291cmNlIEFjY2VzcyBNYW5hZ2VtZW50IChSQU0pIGNvbnNvbGUuXG4gICAgICovXG4gICAgcHVibGljIHRhcmdldEJ1Y2tldDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHRhcmdldE9zc1JlZ2lvbjogVGhlIHJlZ2lvbiBpbiB3aGljaCB0aGUgT1NTIGJ1Y2tldCByZXNpZGVzLlxuICAgICAqIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIGlmIHRoZSBUYXJnZXRUeXBlIHBhcmFtZXRlciBpcyBzZXQgdG8gT1NTLlxuICAgICAqL1xuICAgIHB1YmxpYyB0YXJnZXRPc3NSZWdpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSB0YXJnZXRQYXRoOiBUaGUgZGVzdGluYXRpb24gcGF0aCB0byB3aGljaCB0aGUgYmFja3VwIHNldCBpcyBkb3dubG9hZGVkLlxuICAgICAqIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIGlmIHRoZSBUYXJnZXRUeXBlIHBhcmFtZXRlciBpcyBzZXQgdG8gT1NTLlxuICAgICAqL1xuICAgIHB1YmxpYyB0YXJnZXRQYXRoOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgdGFyZ2V0VHlwZTogVGhlIHR5cGUgb2YgdGhlIGRlc3RpbmF0aW9uIHRvIHdoaWNoIHRoZSBiYWNrdXAgc2V0IGlzIGRvd25sb2FkZWQuIFxuICAgICAqIFZhbGlkIHZhbHVlczogT1NTfFVSTFxuICAgICAqL1xuICAgIHB1YmxpYyB0YXJnZXRUeXBlOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICAgKiBAcGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUm9zRG93bmxvYWRQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IFJvc0Rvd25sb2FkLlJPU19SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICB0aGlzLmF0dHJCYWtTZXRJZCA9IHRoaXMuZ2V0QXR0KCdCYWtTZXRJZCcpO1xuICAgICAgICB0aGlzLmF0dHJEb3dubG9hZEFkZHJlc3NJbmZvID0gdGhpcy5nZXRBdHQoJ0Rvd25sb2FkQWRkcmVzc0luZm8nKTtcbiAgICAgICAgdGhpcy5hdHRySW5zdGFuY2VOYW1lID0gdGhpcy5nZXRBdHQoJ0luc3RhbmNlTmFtZScpO1xuICAgICAgICB0aGlzLmF0dHJUYXNrSWQgPSB0aGlzLmdldEF0dCgnVGFza0lkJyk7XG5cbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuICAgICAgICB0aGlzLmZvcm1hdFR5cGUgPSBwcm9wcy5mb3JtYXRUeXBlO1xuICAgICAgICB0aGlzLmluc3RhbmNlTmFtZSA9IHByb3BzLmluc3RhbmNlTmFtZTtcbiAgICAgICAgdGhpcy5iYWtTZXRJZCA9IHByb3BzLmJha1NldElkO1xuICAgICAgICB0aGlzLmJha1NldFNpemUgPSBwcm9wcy5iYWtTZXRTaXplO1xuICAgICAgICB0aGlzLmJha1NldFR5cGUgPSBwcm9wcy5iYWtTZXRUeXBlO1xuICAgICAgICB0aGlzLmRlbGV0ZUJhY2t1cFNldEluT3NzID0gcHJvcHMuZGVsZXRlQmFja3VwU2V0SW5Pc3M7XG4gICAgICAgIHRoaXMuZG93bmxvYWRBZGRyZXNzRHVyYXRpb24gPSBwcm9wcy5kb3dubG9hZEFkZHJlc3NEdXJhdGlvbjtcbiAgICAgICAgdGhpcy5kb3dubG9hZFBvaW50SW5UaW1lID0gcHJvcHMuZG93bmxvYWRQb2ludEluVGltZTtcbiAgICAgICAgdGhpcy50YXJnZXRCdWNrZXQgPSBwcm9wcy50YXJnZXRCdWNrZXQ7XG4gICAgICAgIHRoaXMudGFyZ2V0T3NzUmVnaW9uID0gcHJvcHMudGFyZ2V0T3NzUmVnaW9uO1xuICAgICAgICB0aGlzLnRhcmdldFBhdGggPSBwcm9wcy50YXJnZXRQYXRoO1xuICAgICAgICB0aGlzLnRhcmdldFR5cGUgPSBwcm9wcy50YXJnZXRUeXBlO1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGZvcm1hdFR5cGU6IHRoaXMuZm9ybWF0VHlwZSxcbiAgICAgICAgICAgIGluc3RhbmNlTmFtZTogdGhpcy5pbnN0YW5jZU5hbWUsXG4gICAgICAgICAgICBiYWtTZXRJZDogdGhpcy5iYWtTZXRJZCxcbiAgICAgICAgICAgIGJha1NldFNpemU6IHRoaXMuYmFrU2V0U2l6ZSxcbiAgICAgICAgICAgIGJha1NldFR5cGU6IHRoaXMuYmFrU2V0VHlwZSxcbiAgICAgICAgICAgIGRlbGV0ZUJhY2t1cFNldEluT3NzOiB0aGlzLmRlbGV0ZUJhY2t1cFNldEluT3NzLFxuICAgICAgICAgICAgZG93bmxvYWRBZGRyZXNzRHVyYXRpb246IHRoaXMuZG93bmxvYWRBZGRyZXNzRHVyYXRpb24sXG4gICAgICAgICAgICBkb3dubG9hZFBvaW50SW5UaW1lOiB0aGlzLmRvd25sb2FkUG9pbnRJblRpbWUsXG4gICAgICAgICAgICB0YXJnZXRCdWNrZXQ6IHRoaXMudGFyZ2V0QnVja2V0LFxuICAgICAgICAgICAgdGFyZ2V0T3NzUmVnaW9uOiB0aGlzLnRhcmdldE9zc1JlZ2lvbixcbiAgICAgICAgICAgIHRhcmdldFBhdGg6IHRoaXMudGFyZ2V0UGF0aCxcbiAgICAgICAgICAgIHRhcmdldFR5cGU6IHRoaXMudGFyZ2V0VHlwZSxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gcm9zRG93bmxvYWRQcm9wc1RvUm9zVGVtcGxhdGUocHJvcHMsIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgIH1cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBSb3NSZXN0b3JlVGFza2AuXG4gKiBTZWUgaHR0cHM6Ly93d3cuYWxpYmFiYWNsb3VkLmNvbS9oZWxwL3Jvcy9kZXZlbG9wZXItcmVmZXJlbmNlL2FsaXl1bi1kYnMtcmVzdG9yZXRhc2tcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSb3NSZXN0b3JlVGFza1Byb3BzIHtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBiYWNrdXBQbGFuSWQ6IFRoZSBJRCBvZiB0aGUgYmFja3VwIHBsYW4uXG4gICAgICovXG4gICAgcmVhZG9ubHkgYmFja3VwUGxhbklkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZTogVGhlIGxvY2F0aW9uIG9mIHRoZSBkYXRhYmFzZS4gVmFsaWQgdmFsdWVzOiBcbiAgICAgKiAtIHJkcyBcbiAgICAgKiAtIGVjcyBcbiAgICAgKiAtIGV4cHJlc3M6IGEgZGF0YWJhc2UgY29ubmVjdGVkIG92ZXIgZXhwcmVzcyBjb25uZWN0LCBWUE4gR2F0ZXdheSwgb3Igc21hcnQgZ2F0ZXdheS4gXG4gICAgICogLSBhZ2VudDogVGhlIGRhdGFiYXNlIGNvbm5lY3RlZCB0aHJvdWdoIHRoZSBiYWNrdXAgR2F0ZXdheSBcbiAgICAgKiAtIGRkczogYXBzYXJhZGIgZm9yIE1vbmdvREIgXG4gICAgICogLSBrdnN0b3JlIFxuICAgICAqIC0gcG9sYXJkYiBcbiAgICAgKiAtIGRyZHMgXG4gICAgICogLSBkZzogdGhlIGRhdGFiYXNlIGlzIGRpcmVjdGx5IGNvbm5lY3RlZCB0aHJvdWdoIElQIEFkZHJlc3M6IFBvcnQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlc3RvcmVUYXNrTmFtZTogVGhlIG5hbWUgb2YgdGhlIHJlc3RvcmF0aW9uIHRhc2suXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdG9yZVRhc2tOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYmFja3VwR2F0ZXdheUlkOiBUaGUgSUQgb2YgdGhlIGJhY2t1cCBnYXRld2F5LlxuICAgICAqIE5vdGVEZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlIGlmIHlvdSBzZXQgdGhpcyBwYXJhbWV0ZXIgdG8gYWdlbnQsIHRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhY2t1cEdhdGV3YXlJZD86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBiYWNrdXBTZXRJZDogVGhlIElEIG9mIHRoZSBmdWxsIGJhY2t1cCBzZXQgdXNlZCBmb3IgcmVzdG9yYXRpb24sIHdoaWNoIGlzIG11dHVhbGx5IGV4Y2x1c2l2ZSB0b1xuICAgICAqIFJlc3RvcmVUaW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJhY2t1cFNldElkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnREYXRhYmFzZU5hbWU6IFRoZSBuYW1lIG9mIHRoZSBSRFMgZGF0YWJhc2UuXG4gICAgICogTm90ZSBXaGVuIHRoZSBkYXRhYmFzZSB0eXBlIGlzIFBvc3RncmVTUUwgb3IgTW9uZ29EQiwgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzdGluYXRpb25FbmRwb2ludERhdGFiYXNlTmFtZT86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VJZDogVGhlIElEIG9mIHRoZSBBcHNhcmFEQiBSRFMgaW5zdGFuY2UgdG8gcXVlcnkuXG4gICAgICogTm90ZURlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUgaWYgdGhlIHZhbHVlIGlzIFJEUywgRUNTLCBERFMsIG9yIEV4cHJlc3MsIHRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZUlkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnRJcDogVGhlIGVuZHBvaW50IHVzZWQgdG8gY29ubmVjdCB0byB0aGUgZGF0YWJhc2UuXG4gICAgICogTm90ZURlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUgaXMgZXhwcmVzcywgYWdlbnQsIG9yIG90aGVyLiBUaGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXN0aW5hdGlvbkVuZHBvaW50SXA/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVzdGluYXRpb25FbmRwb2ludE9yYWNsZVNpZDogVGhlIFNJRCBvZiB0aGUgT3JhY2xlIGluc3RhbmNlLlxuICAgICAqIE5vdGUgVGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgaWYgdGhlIGRhdGFiYXNlIHR5cGUgaXMgT3JhY2xlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGRlc3RpbmF0aW9uRW5kcG9pbnRPcmFjbGVTaWQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkOiBUaGUgcGFzc3dvcmQgdGhhdCBpcyB1c2VkIHRvIGxvZyBvbiB0byB0aGUgUkRTIGluc3RhbmNlLlxuICAgICAqIE5vdGUgWW91IG11c3Qgc3BlY2lmeSB0aGlzIHBhcmFtZXRlciB3aGVuIHRoZSBkYXRhYmFzZSB0eXBlIGlzIFJlZGlzLCBvciB0aGUgZGF0YWJhc2UgbG9jYXRpb25cbiAgICAgKiBpcyBhZ2VudCBhbmQgdGhlIGRhdGFiYXNlIHR5cGUgaXMgTVNTUUwuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnRQb3J0OiBUaGUgcG9ydCB0aGF0IGlzIHVzZWQgdG8gYWNjZXNzIHRoZSBkYXRhYmFzZSBvZiB0aGUgcHJpbWFyeSBNeVNRTCBzZXJ2ZXIuXG4gICAgICogTm90ZURlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUgaXMgaW4gdGhlIGZvcm1hdCBvZiBleHByZXNzLCBhZ2VudCwgb3RoZXIsIG9yIEVDUy4gVGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGVzdGluYXRpb25FbmRwb2ludFBvcnQ/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVzdGluYXRpb25FbmRwb2ludFJlZ2lvbjogVGhlIHJlZ2lvbiBvZiB0aGUgZGF0YWJhc2UuXG4gICAgICogTm90ZURlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUgZm9yIFJEUywgRUNTLCBERFMsIEV4cHJlc3MsIG9yIEFnZW50LCB0aGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXN0aW5hdGlvbkVuZHBvaW50UmVnaW9uPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnRVc2VyTmFtZTogVGhlIGRhdGFiYXNlIGFjY291bnQuXG4gICAgICogTm90ZSBZb3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIHdoZW4gdGhlIGRhdGFiYXNlIHR5cGUgaXMgUmVkaXMsIG9yIHRoZSBkYXRhYmFzZSBsb2NhdGlvblxuICAgICAqIGlzIGFnZW50IGFuZCB0aGUgZGF0YWJhc2UgdHlwZSBpcyBNU1NRTC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXN0aW5hdGlvbkVuZHBvaW50VXNlck5hbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZHVwbGljYXRlQ29uZmxpY3Q6IFRoZSBoYW5kbGluZyBtZXRob2QgZm9yIGNvbmZsaWN0cyBiZXR3ZWVuIG9iamVjdHMgd2l0aCB0aGUgc2FtZSBuYW1lLiBWYWxpZCB2YWx1ZXM6XG4gICAgICogZmFpbHVyZTogVGhlIG9iamVjdCB3aXRoIHRoZSBzYW1lIG5hbWUgZmFpbHMgKGRlZmF1bHQpLlxuICAgICAqIHJlbmFtZW5ldzogcmVuYW1lcyBhbiBvYmplY3Qgd2l0aCB0aGUgc2FtZSBuYW1lLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGR1cGxpY2F0ZUNvbmZsaWN0Pzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlc3RvcmVEaXI6IERlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgd2hlbiBhZ2VudCBpcyBzcGVjaWZpZWQgYW5kIHRoZSBiYWNrdXAgc2NoZWR1bGUgaXMgTXlTUUwuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdG9yZURpcj86IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSByZXN0b3JlSG9tZTogRGF0YWJhc2UgUHJvZ3JhbSBEaXJlY3RvcnkuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdG9yZUhvbWU/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVzdG9yZU9iamVjdHM6IFJlc3RvcmUgYW4gb2JqZWN0LlxuICAgICAqIE5vdGUgRm9yIGRldGFpbHMsIHNlZSB0aGUgZm9sbG93aW5nIFJlc3RvcmVPYmplY3RzIGlmIHRoZSBkYXRhYmFzZSBpcyBsb2NhdGVkIGluIGFuIGFnZW50LCB0aGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZCBpbiBvdGhlciBzY2VuYXJpb3MuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdG9yZU9iamVjdHM/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVzdG9yZVRpbWU6IFRoZSB0aW1lIHdoZW4gdGhlIGZhdWx0IGlzIHJlc3RvcmVkLiBTZXQgdGhlIHZhbHVlIHRvIDE1NTQ1NjA0NzcwMDAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzdG9yZVRpbWU/OiBudW1iZXIgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgc3RhcnRUYXNrOiBTdGFydCByZXN0b3JlIHRhc2sgYWZ0ZXIgY3JlYXRpbmcgYSByZWNvdmVyeSB0YXNrLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHN0YXJ0VGFzaz86IGJvb2xlYW4gfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgUm9zUmVzdG9yZVRhc2tQcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUm9zUmVzdG9yZVRhc2tQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBSb3NSZXN0b3JlVGFza1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IHJvcy5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIXJvcy5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiByb3MuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IHJvcy5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignc3RhcnRUYXNrJywgcm9zLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5zdGFydFRhc2spKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc3RvcmVEaXInLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVzdG9yZURpcikpO1xuICAgIGlmKHByb3BlcnRpZXMuZHVwbGljYXRlQ29uZmxpY3QgJiYgKHR5cGVvZiBwcm9wZXJ0aWVzLmR1cGxpY2F0ZUNvbmZsaWN0KSAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkdXBsaWNhdGVDb25mbGljdCcsIHJvcy52YWxpZGF0ZUFsbG93ZWRWYWx1ZXMpKHtcbiAgICAgICAgICBkYXRhOiBwcm9wZXJ0aWVzLmR1cGxpY2F0ZUNvbmZsaWN0LFxuICAgICAgICAgIGFsbG93ZWRWYWx1ZXM6IFtcImZhaWx1cmVcIixcInJlbmFtZW5ld1wiXSxcbiAgICAgICAgfSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2R1cGxpY2F0ZUNvbmZsaWN0Jywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmR1cGxpY2F0ZUNvbmZsaWN0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZXN0b3JlSG9tZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yZXN0b3JlSG9tZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRQYXNzd29yZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVzdGluYXRpb25FbmRwb2ludElwJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRJcCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVzdGluYXRpb25FbmRwb2ludFBvcnQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuZGVzdGluYXRpb25FbmRwb2ludFBvcnQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc3RpbmF0aW9uRW5kcG9pbnRPcmFjbGVTaWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZGVzdGluYXRpb25FbmRwb2ludE9yYWNsZVNpZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignYmFja3VwU2V0SWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYmFja3VwU2V0SWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZXN0b3JlVGltZScsIHJvcy52YWxpZGF0ZU51bWJlcikocHJvcGVydGllcy5yZXN0b3JlVGltZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KHJvcy5wcm9wZXJ0eVZhbGlkYXRvcignZGVzdGluYXRpb25FbmRwb2ludFJlZ2lvbicsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZXN0aW5hdGlvbkVuZHBvaW50UmVnaW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXN0aW5hdGlvbkVuZHBvaW50RGF0YWJhc2VOYW1lJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnREYXRhYmFzZU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ2Rlc3RpbmF0aW9uRW5kcG9pbnRVc2VyTmFtZScsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZXN0aW5hdGlvbkVuZHBvaW50VXNlck5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChyb3MucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc3RvcmVPYmplY3RzJywgcm9zLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJlc3RvcmVPYmplY3RzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZXN0b3JlVGFza05hbWUnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMucmVzdG9yZVRhc2tOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdyZXN0b3JlVGFza05hbWUnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVzdG9yZVRhc2tOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdiYWNrdXBQbGFuSWQnLCByb3MucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuYmFja3VwUGxhbklkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdiYWNrdXBQbGFuSWQnLCByb3MudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuYmFja3VwUGxhbklkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdiYWNrdXBHYXRld2F5SWQnLCByb3MudmFsaWRhdGVOdW1iZXIpKHByb3BlcnRpZXMuYmFja3VwR2F0ZXdheUlkKSk7XG4gICAgZXJyb3JzLmNvbGxlY3Qocm9zLnByb3BlcnR5VmFsaWRhdG9yKCdkZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VJZCcsIHJvcy52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5kZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VJZCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJSb3NSZXN0b3JlVGFza1Byb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpEQlM6OlJlc3RvcmVUYXNrYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSb3NSZXN0b3JlVGFza1Byb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgcHJvcGVydGllcyBvZiBhbiBgQUxJWVVOOjpEQlM6OlJlc3RvcmVUYXNrYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIHJvc1Jlc3RvcmVUYXNrUHJvcHNUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXM6IGFueSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6IGJvb2xlYW4pOiBhbnkge1xuICAgIGlmICghcm9zLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBpZihlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCkge1xuICAgICAgICBSb3NSZXN0b3JlVGFza1Byb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICB9XG4gICAgcmV0dXJuIHtcbiAgICAgIEJhY2t1cFBsYW5JZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5iYWNrdXBQbGFuSWQpLFxuICAgICAgRGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5kZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlKSxcbiAgICAgIFJlc3RvcmVUYXNrTmFtZTogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5yZXN0b3JlVGFza05hbWUpLFxuICAgICAgQmFja3VwR2F0ZXdheUlkOiByb3MubnVtYmVyVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmJhY2t1cEdhdGV3YXlJZCksXG4gICAgICBCYWNrdXBTZXRJZDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5iYWNrdXBTZXRJZCksXG4gICAgICBEZXN0aW5hdGlvbkVuZHBvaW50RGF0YWJhc2VOYW1lOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnREYXRhYmFzZU5hbWUpLFxuICAgICAgRGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSUQ6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMuZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSWQpLFxuICAgICAgRGVzdGluYXRpb25FbmRwb2ludElQOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRJcCksXG4gICAgICBEZXN0aW5hdGlvbkVuZHBvaW50T3JhY2xlU0lEOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRPcmFjbGVTaWQpLFxuICAgICAgRGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRQYXNzd29yZCksXG4gICAgICBEZXN0aW5hdGlvbkVuZHBvaW50UG9ydDogcm9zLm51bWJlclRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5kZXN0aW5hdGlvbkVuZHBvaW50UG9ydCksXG4gICAgICBEZXN0aW5hdGlvbkVuZHBvaW50UmVnaW9uOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRSZWdpb24pLFxuICAgICAgRGVzdGluYXRpb25FbmRwb2ludFVzZXJOYW1lOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLmRlc3RpbmF0aW9uRW5kcG9pbnRVc2VyTmFtZSksXG4gICAgICBEdXBsaWNhdGVDb25mbGljdDogcm9zLnN0cmluZ1RvUm9zVGVtcGxhdGUocHJvcGVydGllcy5kdXBsaWNhdGVDb25mbGljdCksXG4gICAgICBSZXN0b3JlRGlyOiByb3Muc3RyaW5nVG9Sb3NUZW1wbGF0ZShwcm9wZXJ0aWVzLnJlc3RvcmVEaXIpLFxuICAgICAgUmVzdG9yZUhvbWU6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVzdG9yZUhvbWUpLFxuICAgICAgUmVzdG9yZU9iamVjdHM6IHJvcy5zdHJpbmdUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVzdG9yZU9iamVjdHMpLFxuICAgICAgUmVzdG9yZVRpbWU6IHJvcy5udW1iZXJUb1Jvc1RlbXBsYXRlKHByb3BlcnRpZXMucmVzdG9yZVRpbWUpLFxuICAgICAgU3RhcnRUYXNrOiByb3MuYm9vbGVhblRvUm9zVGVtcGxhdGUocHJvcGVydGllcy5zdGFydFRhc2spLFxuICAgIH07XG59XG5cbi8qKlxuICogVGhpcyBjbGFzcyBpcyBhIGJhc2UgZW5jYXBzdWxhdGlvbiBhcm91bmQgdGhlIFJPUyByZXNvdXJjZSB0eXBlIGBBTElZVU46OkRCUzo6UmVzdG9yZVRhc2tgLCB3aGljaCBpcyB1c2VkIHRvIGNyZWF0ZSBhIHJlc3RvcmUgdGFzay5cbiAqIEBOb3RlIFRoaXMgY2xhc3MgZG9lcyBub3QgY29udGFpbiBhZGRpdGlvbmFsIGZ1bmN0aW9ucywgc28gaXQgaXMgcmVjb21tZW5kZWQgdG8gdXNlIHRoZSBgUmVzdG9yZVRhc2tgIGNsYXNzIGluc3RlYWQgb2YgdGhpcyBjbGFzcyBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLWRicy1yZXN0b3JldGFza1xuICovXG5leHBvcnQgY2xhc3MgUm9zUmVzdG9yZVRhc2sgZXh0ZW5kcyByb3MuUm9zUmVzb3VyY2Uge1xuICAgIC8qKlxuICAgICAqIFRoZSByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBST1NfUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBTElZVU46OkRCUzo6UmVzdG9yZVRhc2tcIjtcblxuICAgIC8qKlxuICAgICAqIEBBdHRyaWJ1dGUgUmVzdG9yZVRhc2tJZDogVGhlIElEIG9mIHRoZSByZXN0b3JhdGlvbiB0YXNrLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUmVzdG9yZVRhc2tJZDogcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgcHVibGljIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYmFja3VwUGxhbklkOiBUaGUgSUQgb2YgdGhlIGJhY2t1cCBwbGFuLlxuICAgICAqL1xuICAgIHB1YmxpYyBiYWNrdXBQbGFuSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlOiBUaGUgbG9jYXRpb24gb2YgdGhlIGRhdGFiYXNlLiBWYWxpZCB2YWx1ZXM6IFxuICAgICAqIC0gcmRzIFxuICAgICAqIC0gZWNzIFxuICAgICAqIC0gZXhwcmVzczogYSBkYXRhYmFzZSBjb25uZWN0ZWQgb3ZlciBleHByZXNzIGNvbm5lY3QsIFZQTiBHYXRld2F5LCBvciBzbWFydCBnYXRld2F5LiBcbiAgICAgKiAtIGFnZW50OiBUaGUgZGF0YWJhc2UgY29ubmVjdGVkIHRocm91Z2ggdGhlIGJhY2t1cCBHYXRld2F5IFxuICAgICAqIC0gZGRzOiBhcHNhcmFkYiBmb3IgTW9uZ29EQiBcbiAgICAgKiAtIGt2c3RvcmUgXG4gICAgICogLSBwb2xhcmRiIFxuICAgICAqIC0gZHJkcyBcbiAgICAgKiAtIGRnOiB0aGUgZGF0YWJhc2UgaXMgZGlyZWN0bHkgY29ubmVjdGVkIHRocm91Z2ggSVAgQWRkcmVzczogUG9ydC5cbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlc3RvcmVUYXNrTmFtZTogVGhlIG5hbWUgb2YgdGhlIHJlc3RvcmF0aW9uIHRhc2suXG4gICAgICovXG4gICAgcHVibGljIHJlc3RvcmVUYXNrTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGJhY2t1cEdhdGV3YXlJZDogVGhlIElEIG9mIHRoZSBiYWNrdXAgZ2F0ZXdheS5cbiAgICAgKiBOb3RlRGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZSBpZiB5b3Ugc2V0IHRoaXMgcGFyYW1ldGVyIHRvIGFnZW50LCB0aGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgYmFja3VwR2F0ZXdheUlkOiBudW1iZXIgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgYmFja3VwU2V0SWQ6IFRoZSBJRCBvZiB0aGUgZnVsbCBiYWNrdXAgc2V0IHVzZWQgZm9yIHJlc3RvcmF0aW9uLCB3aGljaCBpcyBtdXR1YWxseSBleGNsdXNpdmUgdG9cbiAgICAgKiBSZXN0b3JlVGltZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgYmFja3VwU2V0SWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXN0aW5hdGlvbkVuZHBvaW50RGF0YWJhc2VOYW1lOiBUaGUgbmFtZSBvZiB0aGUgUkRTIGRhdGFiYXNlLlxuICAgICAqIE5vdGUgV2hlbiB0aGUgZGF0YWJhc2UgdHlwZSBpcyBQb3N0Z3JlU1FMIG9yIE1vbmdvREIsIHRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHB1YmxpYyBkZXN0aW5hdGlvbkVuZHBvaW50RGF0YWJhc2VOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSWQ6IFRoZSBJRCBvZiB0aGUgQXBzYXJhREIgUkRTIGluc3RhbmNlIHRvIHF1ZXJ5LlxuICAgICAqIE5vdGVEZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlIGlmIHRoZSB2YWx1ZSBpcyBSRFMsIEVDUywgRERTLCBvciBFeHByZXNzLCB0aGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZC5cbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSWQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXN0aW5hdGlvbkVuZHBvaW50SXA6IFRoZSBlbmRwb2ludCB1c2VkIHRvIGNvbm5lY3QgdG8gdGhlIGRhdGFiYXNlLlxuICAgICAqIE5vdGVEZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlIGlzIGV4cHJlc3MsIGFnZW50LCBvciBvdGhlci4gVGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcHVibGljIGRlc3RpbmF0aW9uRW5kcG9pbnRJcDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnRPcmFjbGVTaWQ6IFRoZSBTSUQgb2YgdGhlIE9yYWNsZSBpbnN0YW5jZS5cbiAgICAgKiBOb3RlIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIGlmIHRoZSBkYXRhYmFzZSB0eXBlIGlzIE9yYWNsZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgZGVzdGluYXRpb25FbmRwb2ludE9yYWNsZVNpZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnRQYXNzd29yZDogVGhlIHBhc3N3b3JkIHRoYXQgaXMgdXNlZCB0byBsb2cgb24gdG8gdGhlIFJEUyBpbnN0YW5jZS5cbiAgICAgKiBOb3RlIFlvdSBtdXN0IHNwZWNpZnkgdGhpcyBwYXJhbWV0ZXIgd2hlbiB0aGUgZGF0YWJhc2UgdHlwZSBpcyBSZWRpcywgb3IgdGhlIGRhdGFiYXNlIGxvY2F0aW9uXG4gICAgICogaXMgYWdlbnQgYW5kIHRoZSBkYXRhYmFzZSB0eXBlIGlzIE1TU1FMLlxuICAgICAqL1xuICAgIHB1YmxpYyBkZXN0aW5hdGlvbkVuZHBvaW50UGFzc3dvcmQ6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXN0aW5hdGlvbkVuZHBvaW50UG9ydDogVGhlIHBvcnQgdGhhdCBpcyB1c2VkIHRvIGFjY2VzcyB0aGUgZGF0YWJhc2Ugb2YgdGhlIHByaW1hcnkgTXlTUUwgc2VydmVyLlxuICAgICAqIE5vdGVEZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlIGlzIGluIHRoZSBmb3JtYXQgb2YgZXhwcmVzcywgYWdlbnQsIG90aGVyLCBvciBFQ1MuIFRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkLlxuICAgICAqL1xuICAgIHB1YmxpYyBkZXN0aW5hdGlvbkVuZHBvaW50UG9ydDogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGRlc3RpbmF0aW9uRW5kcG9pbnRSZWdpb246IFRoZSByZWdpb24gb2YgdGhlIGRhdGFiYXNlLlxuICAgICAqIE5vdGVEZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlIGZvciBSRFMsIEVDUywgRERTLCBFeHByZXNzLCBvciBBZ2VudCwgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQuXG4gICAgICovXG4gICAgcHVibGljIGRlc3RpbmF0aW9uRW5kcG9pbnRSZWdpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSBkZXN0aW5hdGlvbkVuZHBvaW50VXNlck5hbWU6IFRoZSBkYXRhYmFzZSBhY2NvdW50LlxuICAgICAqIE5vdGUgWW91IG11c3Qgc3BlY2lmeSB0aGlzIHBhcmFtZXRlciB3aGVuIHRoZSBkYXRhYmFzZSB0eXBlIGlzIFJlZGlzLCBvciB0aGUgZGF0YWJhc2UgbG9jYXRpb25cbiAgICAgKiBpcyBhZ2VudCBhbmQgdGhlIGRhdGFiYXNlIHR5cGUgaXMgTVNTUUwuXG4gICAgICovXG4gICAgcHVibGljIGRlc3RpbmF0aW9uRW5kcG9pbnRVc2VyTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IGR1cGxpY2F0ZUNvbmZsaWN0OiBUaGUgaGFuZGxpbmcgbWV0aG9kIGZvciBjb25mbGljdHMgYmV0d2VlbiBvYmplY3RzIHdpdGggdGhlIHNhbWUgbmFtZS4gVmFsaWQgdmFsdWVzOlxuICAgICAqIGZhaWx1cmU6IFRoZSBvYmplY3Qgd2l0aCB0aGUgc2FtZSBuYW1lIGZhaWxzIChkZWZhdWx0KS5cbiAgICAgKiByZW5hbWVuZXc6IHJlbmFtZXMgYW4gb2JqZWN0IHdpdGggdGhlIHNhbWUgbmFtZS5cbiAgICAgKi9cbiAgICBwdWJsaWMgZHVwbGljYXRlQ29uZmxpY3Q6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEBQcm9wZXJ0eSByZXN0b3JlRGlyOiBEZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlIHRoaXMgcGFyYW1ldGVyIGlzIHJlcXVpcmVkIHdoZW4gYWdlbnQgaXMgc3BlY2lmaWVkIGFuZCB0aGUgYmFja3VwIHNjaGVkdWxlIGlzIE15U1FMLlxuICAgICAqL1xuICAgIHB1YmxpYyByZXN0b3JlRGlyOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBAUHJvcGVydHkgcmVzdG9yZUhvbWU6IERhdGFiYXNlIFByb2dyYW0gRGlyZWN0b3J5LlxuICAgICAqL1xuICAgIHB1YmxpYyByZXN0b3JlSG9tZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlc3RvcmVPYmplY3RzOiBSZXN0b3JlIGFuIG9iamVjdC5cbiAgICAgKiBOb3RlIEZvciBkZXRhaWxzLCBzZWUgdGhlIGZvbGxvd2luZyBSZXN0b3JlT2JqZWN0cyBpZiB0aGUgZGF0YWJhc2UgaXMgbG9jYXRlZCBpbiBhbiBhZ2VudCwgdGhpcyBwYXJhbWV0ZXIgaXMgcmVxdWlyZWQgaW4gb3RoZXIgc2NlbmFyaW9zLlxuICAgICAqL1xuICAgIHB1YmxpYyByZXN0b3JlT2JqZWN0czogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHJlc3RvcmVUaW1lOiBUaGUgdGltZSB3aGVuIHRoZSBmYXVsdCBpcyByZXN0b3JlZC4gU2V0IHRoZSB2YWx1ZSB0byAxNTU0NTYwNDc3MDAwLlxuICAgICAqL1xuICAgIHB1YmxpYyByZXN0b3JlVGltZTogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQFByb3BlcnR5IHN0YXJ0VGFzazogU3RhcnQgcmVzdG9yZSB0YXNrIGFmdGVyIGNyZWF0aW5nIGEgcmVjb3ZlcnkgdGFzay5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhcnRUYXNrOiBib29sZWFuIHwgcm9zLklSZXNvbHZhYmxlIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJvc1Jlc3RvcmVUYXNrUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBSb3NSZXN0b3JlVGFzay5ST1NfUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgdGhpcy5hdHRyUmVzdG9yZVRhc2tJZCA9IHRoaXMuZ2V0QXR0KCdSZXN0b3JlVGFza0lkJyk7XG5cbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuICAgICAgICB0aGlzLmJhY2t1cFBsYW5JZCA9IHByb3BzLmJhY2t1cFBsYW5JZDtcbiAgICAgICAgdGhpcy5kZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlID0gcHJvcHMuZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlVHlwZTtcbiAgICAgICAgdGhpcy5yZXN0b3JlVGFza05hbWUgPSBwcm9wcy5yZXN0b3JlVGFza05hbWU7XG4gICAgICAgIHRoaXMuYmFja3VwR2F0ZXdheUlkID0gcHJvcHMuYmFja3VwR2F0ZXdheUlkO1xuICAgICAgICB0aGlzLmJhY2t1cFNldElkID0gcHJvcHMuYmFja3VwU2V0SWQ7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25FbmRwb2ludERhdGFiYXNlTmFtZSA9IHByb3BzLmRlc3RpbmF0aW9uRW5kcG9pbnREYXRhYmFzZU5hbWU7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSWQgPSBwcm9wcy5kZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VJZDtcbiAgICAgICAgdGhpcy5kZXN0aW5hdGlvbkVuZHBvaW50SXAgPSBwcm9wcy5kZXN0aW5hdGlvbkVuZHBvaW50SXA7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25FbmRwb2ludE9yYWNsZVNpZCA9IHByb3BzLmRlc3RpbmF0aW9uRW5kcG9pbnRPcmFjbGVTaWQ7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkID0gcHJvcHMuZGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkO1xuICAgICAgICB0aGlzLmRlc3RpbmF0aW9uRW5kcG9pbnRQb3J0ID0gcHJvcHMuZGVzdGluYXRpb25FbmRwb2ludFBvcnQ7XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25FbmRwb2ludFJlZ2lvbiA9IHByb3BzLmRlc3RpbmF0aW9uRW5kcG9pbnRSZWdpb247XG4gICAgICAgIHRoaXMuZGVzdGluYXRpb25FbmRwb2ludFVzZXJOYW1lID0gcHJvcHMuZGVzdGluYXRpb25FbmRwb2ludFVzZXJOYW1lO1xuICAgICAgICB0aGlzLmR1cGxpY2F0ZUNvbmZsaWN0ID0gcHJvcHMuZHVwbGljYXRlQ29uZmxpY3Q7XG4gICAgICAgIHRoaXMucmVzdG9yZURpciA9IHByb3BzLnJlc3RvcmVEaXI7XG4gICAgICAgIHRoaXMucmVzdG9yZUhvbWUgPSBwcm9wcy5yZXN0b3JlSG9tZTtcbiAgICAgICAgdGhpcy5yZXN0b3JlT2JqZWN0cyA9IHByb3BzLnJlc3RvcmVPYmplY3RzO1xuICAgICAgICB0aGlzLnJlc3RvcmVUaW1lID0gcHJvcHMucmVzdG9yZVRpbWU7XG4gICAgICAgIHRoaXMuc3RhcnRUYXNrID0gcHJvcHMuc3RhcnRUYXNrO1xuICAgIH1cblxuXG4gICAgcHJvdGVjdGVkIGdldCByb3NQcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGJhY2t1cFBsYW5JZDogdGhpcy5iYWNrdXBQbGFuSWQsXG4gICAgICAgICAgICBkZXN0aW5hdGlvbkVuZHBvaW50SW5zdGFuY2VUeXBlOiB0aGlzLmRlc3RpbmF0aW9uRW5kcG9pbnRJbnN0YW5jZVR5cGUsXG4gICAgICAgICAgICByZXN0b3JlVGFza05hbWU6IHRoaXMucmVzdG9yZVRhc2tOYW1lLFxuICAgICAgICAgICAgYmFja3VwR2F0ZXdheUlkOiB0aGlzLmJhY2t1cEdhdGV3YXlJZCxcbiAgICAgICAgICAgIGJhY2t1cFNldElkOiB0aGlzLmJhY2t1cFNldElkLFxuICAgICAgICAgICAgZGVzdGluYXRpb25FbmRwb2ludERhdGFiYXNlTmFtZTogdGhpcy5kZXN0aW5hdGlvbkVuZHBvaW50RGF0YWJhc2VOYW1lLFxuICAgICAgICAgICAgZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSWQ6IHRoaXMuZGVzdGluYXRpb25FbmRwb2ludEluc3RhbmNlSWQsXG4gICAgICAgICAgICBkZXN0aW5hdGlvbkVuZHBvaW50SXA6IHRoaXMuZGVzdGluYXRpb25FbmRwb2ludElwLFxuICAgICAgICAgICAgZGVzdGluYXRpb25FbmRwb2ludE9yYWNsZVNpZDogdGhpcy5kZXN0aW5hdGlvbkVuZHBvaW50T3JhY2xlU2lkLFxuICAgICAgICAgICAgZGVzdGluYXRpb25FbmRwb2ludFBhc3N3b3JkOiB0aGlzLmRlc3RpbmF0aW9uRW5kcG9pbnRQYXNzd29yZCxcbiAgICAgICAgICAgIGRlc3RpbmF0aW9uRW5kcG9pbnRQb3J0OiB0aGlzLmRlc3RpbmF0aW9uRW5kcG9pbnRQb3J0LFxuICAgICAgICAgICAgZGVzdGluYXRpb25FbmRwb2ludFJlZ2lvbjogdGhpcy5kZXN0aW5hdGlvbkVuZHBvaW50UmVnaW9uLFxuICAgICAgICAgICAgZGVzdGluYXRpb25FbmRwb2ludFVzZXJOYW1lOiB0aGlzLmRlc3RpbmF0aW9uRW5kcG9pbnRVc2VyTmFtZSxcbiAgICAgICAgICAgIGR1cGxpY2F0ZUNvbmZsaWN0OiB0aGlzLmR1cGxpY2F0ZUNvbmZsaWN0LFxuICAgICAgICAgICAgcmVzdG9yZURpcjogdGhpcy5yZXN0b3JlRGlyLFxuICAgICAgICAgICAgcmVzdG9yZUhvbWU6IHRoaXMucmVzdG9yZUhvbWUsXG4gICAgICAgICAgICByZXN0b3JlT2JqZWN0czogdGhpcy5yZXN0b3JlT2JqZWN0cyxcbiAgICAgICAgICAgIHJlc3RvcmVUaW1lOiB0aGlzLnJlc3RvcmVUaW1lLFxuICAgICAgICAgICAgc3RhcnRUYXNrOiB0aGlzLnN0YXJ0VGFzayxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gcm9zUmVzdG9yZVRhc2tQcm9wc1RvUm9zVGVtcGxhdGUocHJvcHMsIHRoaXMuZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQpO1xuICAgIH1cbn1cbiJdfQ==