"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Download = exports.DownloadProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dbs_generated_1 = require("./dbs.generated");
Object.defineProperty(exports, "DownloadProperty", { enumerable: true, get: function () { return dbs_generated_1.RosDownload; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DBS::Download`, which is used to create an advanced download task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDownload`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-download
 */
class Download extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDownload = new dbs_generated_1.RosDownload(this, id, {
            bakSetId: props.bakSetId,
            instanceName: props.instanceName,
            downloadPointInTime: props.downloadPointInTime,
            bakSetType: props.bakSetType,
            bakSetSize: props.bakSetSize,
            targetPath: props.targetPath,
            targetType: props.targetType,
            targetOssRegion: props.targetOssRegion,
            deleteBackupSetInOss: props.deleteBackupSetInOss === undefined || props.deleteBackupSetInOss === null ? true : props.deleteBackupSetInOss,
            targetBucket: props.targetBucket,
            formatType: props.formatType,
            downloadAddressDuration: props.downloadAddressDuration === undefined || props.downloadAddressDuration === null ? 2700 : props.downloadAddressDuration,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDownload;
        this.attrBakSetId = rosDownload.attrBakSetId;
        this.attrDownloadAddressInfo = rosDownload.attrDownloadAddressInfo;
        this.attrInstanceName = rosDownload.attrInstanceName;
        this.attrTaskId = rosDownload.attrTaskId;
    }
}
exports.Download = Download;
//# sourceMappingURL=data:application/json;base64,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