"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreTask = exports.RestoreTaskProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dbs_generated_1 = require("./dbs.generated");
Object.defineProperty(exports, "RestoreTaskProperty", { enumerable: true, get: function () { return dbs_generated_1.RosRestoreTask; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DBS::RestoreTask`, which is used to create a restore task.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosRestoreTask`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-dbs-restoretask
 */
class RestoreTask extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosRestoreTask = new dbs_generated_1.RosRestoreTask(this, id, {
            startTask: props.startTask === undefined || props.startTask === null ? true : props.startTask,
            restoreDir: props.restoreDir,
            duplicateConflict: props.duplicateConflict,
            restoreHome: props.restoreHome,
            destinationEndpointPassword: props.destinationEndpointPassword,
            destinationEndpointIp: props.destinationEndpointIp,
            destinationEndpointPort: props.destinationEndpointPort,
            destinationEndpointOracleSid: props.destinationEndpointOracleSid,
            backupSetId: props.backupSetId,
            destinationEndpointInstanceType: props.destinationEndpointInstanceType,
            restoreTime: props.restoreTime,
            destinationEndpointRegion: props.destinationEndpointRegion,
            destinationEndpointDatabaseName: props.destinationEndpointDatabaseName,
            destinationEndpointUserName: props.destinationEndpointUserName,
            restoreObjects: props.restoreObjects,
            restoreTaskName: props.restoreTaskName,
            backupPlanId: props.backupPlanId,
            backupGatewayId: props.backupGatewayId,
            destinationEndpointInstanceId: props.destinationEndpointInstanceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRestoreTask;
        this.attrRestoreTaskId = rosRestoreTask.attrRestoreTaskId;
    }
}
exports.RestoreTask = RestoreTask;
//# sourceMappingURL=data:application/json;base64,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