/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.api;

import io.ray.api.BaseActorHandle;
import io.ray.api.PyActorHandle;
import io.ray.api.Ray;
import io.ray.api.call.PyActorCreator;
import io.ray.api.exception.RayActorException;
import io.ray.api.exception.RayTimeoutException;
import io.ray.api.function.PyActorClass;
import io.ray.api.function.PyActorMethod;
import io.ray.api.options.ActorLifetime;
import io.ray.serve.api.ServeControllerClient;
import io.ray.serve.deployment.Deployment;
import io.ray.serve.deployment.DeploymentCreator;
import io.ray.serve.deployment.DeploymentRoute;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.generated.ActorNameList;
import io.ray.serve.poll.LongPollClientFactory;
import io.ray.serve.replica.ReplicaContext;
import io.ray.serve.util.CollectionUtil;
import io.ray.serve.util.CommonUtil;
import io.ray.serve.util.LogUtil;
import io.ray.serve.util.ServeProtoUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Serve {
    private static final Logger LOGGER = LoggerFactory.getLogger(Serve.class);
    private static ReplicaContext INTERNAL_REPLICA_CONTEXT;
    private static ServeControllerClient GLOBAL_CLIENT;

    public static synchronized ServeControllerClient start(boolean detached, boolean dedicatedCpu, Map<String, String> config) {
        if (!Ray.isInitialized()) {
            System.setProperty("ray.job.namespace", "serve");
            Ray.init();
        }
        try {
            ServeControllerClient client = Serve.getGlobalClient(true);
            LOGGER.info("Connecting to existing Serve app in namespace {}", (Object)"serve");
            return client;
        }
        catch (RayServeException | IllegalStateException e) {
            LOGGER.info("There is no instance running on this Ray cluster. A new one will be started.");
            String controllerName = detached ? "SERVE_CONTROLLER_ACTOR" : CommonUtil.formatActorName("SERVE_CONTROLLER_ACTOR", RandomStringUtils.randomAlphabetic(6));
            int httpPort = Optional.ofNullable(config).map(m4 -> (String)m4.get("ray.serve.proxy.http.port")).map(Integer::parseInt).orElse(8000);
            PyActorHandle controllerAvatar = ((PyActorCreator)((PyActorCreator)((PyActorCreator)((PyActorCreator)Ray.actor(PyActorClass.of("ray.serve.controller", "ServeControllerAvatar"), (Object)controllerName, (Object)detached, (Object)dedicatedCpu, (Object)httpPort).setName(controllerName + "_AVATAR")).setLifetime(detached ? ActorLifetime.DETACHED : ActorLifetime.NON_DETACHED)).setMaxRestarts(-1)).setMaxConcurrency(1)).remote();
            controllerAvatar.task(PyActorMethod.of("check_alive")).remote().get();
            PyActorHandle controller = (PyActorHandle)Ray.getActor(controllerName, "serve").get();
            ActorNameList actorNameList = ServeProtoUtil.bytesToProto((byte[])controller.task(PyActorMethod.of("get_http_proxy_names")).remote().get(), ActorNameList::parseFrom);
            if (actorNameList != null && !CollectionUtil.isEmpty(actorNameList.getNamesList())) {
                try {
                    for (String name : actorNameList.getNamesList()) {
                        PyActorHandle proxyActorHandle = (PyActorHandle)Ray.getActor(name, "serve").get();
                        proxyActorHandle.task(PyActorMethod.of("ready")).remote().get(60000L);
                    }
                }
                catch (RayTimeoutException e2) {
                    String errMsg = LogUtil.format("Proxies not available after {}s.", 60);
                    LOGGER.error(errMsg, e2);
                    throw new RayServeException(errMsg, e2);
                }
            }
            ServeControllerClient client = new ServeControllerClient(controller, controllerName, detached);
            Serve.setGlobalClient(client);
            LOGGER.info("Started{}Serve instance in namespace {}", (Object)(detached ? " detached " : " "), (Object)"serve");
            return client;
        }
    }

    public static void shutdown() {
        ServeControllerClient client = null;
        try {
            client = Serve.getGlobalClient();
        }
        catch (RayServeException | IllegalStateException e) {
            LOGGER.info("Nothing to shut down. There's no Serve application running on this Ray cluster.");
            return;
        }
        LongPollClientFactory.stop();
        client.shutdown();
        Serve.clearContext();
    }

    public static void clearContext() {
        Serve.setGlobalClient(null);
        Serve.setInternalReplicaContext(null);
    }

    public static DeploymentCreator deployment() {
        return new DeploymentCreator();
    }

    public static void setInternalReplicaContext(String deploymentName, String replicaTag, String controllerName, Object servableObject, Map<String, String> config) {
        INTERNAL_REPLICA_CONTEXT = new ReplicaContext(deploymentName, replicaTag, controllerName, servableObject, config);
    }

    public static void setInternalReplicaContext(ReplicaContext replicaContext) {
        INTERNAL_REPLICA_CONTEXT = replicaContext;
    }

    public static ReplicaContext getReplicaContext() {
        if (INTERNAL_REPLICA_CONTEXT == null) {
            throw new RayServeException("`Serve.getReplicaContext()` may only be called from within a Ray Serve deployment.");
        }
        return INTERNAL_REPLICA_CONTEXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServeControllerClient getGlobalClient(boolean healthCheckController) {
        try {
            if (GLOBAL_CLIENT != null) {
                if (healthCheckController) {
                    ((PyActorHandle)GLOBAL_CLIENT.getController()).task(PyActorMethod.of("check_alive")).remote();
                }
                return GLOBAL_CLIENT;
            }
        }
        catch (RayActorException e) {
            LOGGER.info("The cached controller has died. Reconnecting.");
            Serve.setGlobalClient(null);
        }
        Class<ServeControllerClient> clazz = ServeControllerClient.class;
        synchronized (ServeControllerClient.class) {
            if (GLOBAL_CLIENT != null) {
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return GLOBAL_CLIENT;
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return Serve.connect();
        }
    }

    public static ServeControllerClient getGlobalClient() {
        return Serve.getGlobalClient(false);
    }

    private static void setGlobalClient(ServeControllerClient client) {
        GLOBAL_CLIENT = client;
    }

    public static ServeControllerClient connect() {
        if (!Ray.isInitialized()) {
            System.setProperty("ray.job.namespace", "serve");
            Ray.init();
        }
        String controllerName = INTERNAL_REPLICA_CONTEXT != null ? INTERNAL_REPLICA_CONTEXT.getInternalControllerName() : "SERVE_CONTROLLER_ACTOR";
        Optional optional = Ray.getActor(controllerName, "serve");
        Preconditions.checkState(optional.isPresent(), LogUtil.format("There is no instance running on this Ray cluster. Please call `serve.start(detached=True) to start one.", new Object[0]));
        LOGGER.info("Got controller handle with name `{}` in namespace `{}`.", (Object)controllerName, (Object)"serve");
        ServeControllerClient client = new ServeControllerClient((BaseActorHandle)optional.get(), controllerName, true);
        Serve.setGlobalClient(client);
        return client;
    }

    public static Deployment getDeployment(String name) {
        DeploymentRoute deploymentRoute = Serve.getGlobalClient().getDeploymentInfo(name);
        if (deploymentRoute == null) {
            throw new RayServeException(LogUtil.format("Deployment {} was not found. Did you call Deployment.deploy?", name));
        }
        return new Deployment(deploymentRoute.getDeploymentInfo().getReplicaConfig().getDeploymentDef(), name, deploymentRoute.getDeploymentInfo().getDeploymentConfig(), deploymentRoute.getDeploymentInfo().getVersion(), null, deploymentRoute.getDeploymentInfo().getReplicaConfig().getInitArgs(), deploymentRoute.getRoute(), deploymentRoute.getDeploymentInfo().getReplicaConfig().getRayActorOptions());
    }

    public static Map<String, Deployment> listDeployments() {
        Map<String, DeploymentRoute> infos = Serve.getGlobalClient().listDeployments();
        if (infos == null || infos.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Deployment> deployments = new HashMap<String, Deployment>(infos.size());
        for (Map.Entry<String, DeploymentRoute> entry : infos.entrySet()) {
            deployments.put(entry.getKey(), new Deployment(entry.getValue().getDeploymentInfo().getReplicaConfig().getDeploymentDef(), entry.getKey(), entry.getValue().getDeploymentInfo().getDeploymentConfig(), entry.getValue().getDeploymentInfo().getVersion(), null, entry.getValue().getDeploymentInfo().getReplicaConfig().getInitArgs(), entry.getValue().getRoute(), entry.getValue().getDeploymentInfo().getReplicaConfig().getRayActorOptions()));
        }
        return deployments;
    }
}

