/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BioRadReader
extends FormatReader {
    private static final int PIC_FILE_ID = 12345;
    private static final boolean LITTLE_ENDIAN = true;
    private static final String[] MERGE_NAMES = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    public static final String[] NOTE_NAMES = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE", "4D SERIES"};
    public static final int NOTE_TYPE_LIVE = 1;
    public static final int NOTE_TYPE_FILE1 = 2;
    public static final int NOTE_TYPE_NUMBER = 3;
    public static final int NOTE_TYPE_USER = 4;
    public static final int NOTE_TYPE_LINE = 5;
    public static final int NOTE_TYPE_COLLECT = 6;
    public static final int NOTE_TYPE_FILE2 = 7;
    public static final int NOTE_TYPE_SCALEBAR = 8;
    public static final int NOTE_TYPE_MERGE = 9;
    public static final int NOTE_TYPE_THRUVIEW = 10;
    public static final int NOTE_TYPE_ARROW = 11;
    public static final int NOTE_TYPE_VARIABLE = 20;
    public static final int NOTE_TYPE_STRUCTURE = 21;
    public static final int NOTE_TYPE_4D_SERIES = 22;
    public static final String[] STRUCTURE_LABELS_1 = new String[]{"Scan Channel", "Both mode", "Speed", "Filter", "Factor", "Number of scans", "Photon counting mode (channel 1)", "Photon counting detector (channel 1)", "Photon counting mode (channel 2)", "Photon counting detector (channel 2)", "Photon mode", "Objective magnification", "Zoom factor", "Motor on", "Z Step Size"};
    public static final String[] STRUCTURE_LABELS_2 = new String[]{"Z Start", "Z Stop", "Scan area X coordinate", "Scan area Y coordinate", "Scan area width", "Scan area height"};
    public static final String[] STRUCTURE_LABELS_3 = new String[]{"Iris for PMT", "Gain for PMT", "Black level for PMT", "Emission filter for PMT", "Multiplier for channel"};
    public static final String[] STRUCTURE_LABELS_4 = new String[]{"enhanced", "PMT 1 percentage", "PMT 2 percentage", "Transmission 1 percentage", "Transmission 2 percentage", "Transmission 3 percentage"};
    public static final String[] STRUCTURE_LABELS_5 = new String[]{"laser ", "excitation filter for laser ", "ND filter for laser ", "emission filter for laser "};
    public static final String[] STRUCTURE_LABELS_6 = new String[]{"Part number for laser 3", "Part number for excitation filter for laser 3", "Part number for ND filter for laser 3", "Part number for emission filter for laser 3", "Part number for filter block 1", "Part number for filter block 2"};
    public static final String[] PIC_SUFFIX = new String[]{"pic"};
    public static final int LUT_LENGTH = 256;
    private List<String> used;
    private String[] picFiles;
    private byte[][][] lut;
    private int lastChannel = 0;
    private boolean brokenNotes = false;
    private List<Note> noteStrings;
    private List<Double> offset;
    private List<Double> gain;

    public BioRadReader() {
        super("Bio-Rad PIC", new String[]{"pic", "xml", "raw"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One or more .pic files and an optional lse.xml file";
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (BioRadReader.checkSuffix(name, PIC_SUFFIX)) {
            return true;
        }
        String fname = new File(name.toLowerCase()).getName();
        return fname.equals("lse.xml") || fname.equals("data.raw");
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 56;
        if (!FormatTools.validStream(stream, 56, true)) {
            return false;
        }
        String c = stream.readString(56);
        stream.seek(54L);
        return stream.readShort() == 12345 || c.startsWith("[Input Sources]");
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        String[] list;
        Location thisFile = new Location(id).getAbsoluteFile();
        Location parent = thisFile.getParentFile();
        for (String f : list = parent.list(true)) {
            if (!BioRadReader.checkSuffix(f, "raw") && !BioRadReader.checkSuffix(f, "xml")) continue;
            return 0;
        }
        return 1;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut == null ? (byte[][])null : this.lut[this.lastChannel];
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            ArrayList<String> files = new ArrayList<String>();
            for (String f : this.used) {
                if (BioRadReader.checkSuffix(f, PIC_SUFFIX)) continue;
                files.add(f);
            }
            return files.toArray(new String[files.size()]);
        }
        return this.used.toArray(new String[this.used.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastChannel = this.getZCTCoords(no)[1];
        if (this.picFiles != null) {
            int file2 = no % this.picFiles.length;
            try (RandomAccessInputStream ras = new RandomAccessInputStream(this.picFiles[file2]);){
                long offset = no / this.picFiles.length * FormatTools.getPlaneSize(this);
                ras.seek(offset + 76L);
                this.readPlane(ras, x, y, w, h2, buf);
            }
        } else {
            this.in.seek(no * FormatTools.getPlaneSize(this) + 76);
            this.readPlane(this.in, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.used = null;
            this.picFiles = null;
            this.lut = null;
            this.lastChannel = 0;
            this.noteStrings = null;
            this.gain = null;
            this.offset = null;
            this.brokenNotes = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Object handler;
        int i;
        if (!BioRadReader.checkSuffix(id, PIC_SUFFIX)) {
            Location dir = new Location(id).getAbsoluteFile().getParentFile();
            String[] list = dir.list(true);
            for (int i2 = 0; i2 < list.length; ++i2) {
                if (!BioRadReader.checkSuffix(list[i2], PIC_SUFFIX)) continue;
                id = new Location(dir.getAbsolutePath(), list[i2]).getAbsolutePath();
            }
            if (!BioRadReader.checkSuffix(id, PIC_SUFFIX)) {
                throw new FormatException("No .pic files found - invalid dataset.");
            }
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        this.offset = new ArrayList<Double>();
        this.gain = new ArrayList<Double>();
        this.used = new ArrayList<String>();
        this.used.add(new Location(this.currentId).getAbsolutePath());
        LOGGER.info("Reading image dimensions");
        this.noteStrings = new ArrayList<Note>();
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeX = this.in.readShort();
        m3.sizeY = this.in.readShort();
        short npic = this.in.readShort();
        m3.imageCount = npic;
        short ramp1min = this.in.readShort();
        short ramp1max = this.in.readShort();
        boolean notes = this.in.readInt() != 0;
        m3.pixelType = this.in.readShort() == 0 ? 3 : 1;
        short imageNumber = this.in.readShort();
        String name = this.in.readString(32);
        for (int i3 = 0; i3 < name.length(); ++i3) {
            if (name.charAt(i3) != '\u0000') continue;
            name = name.substring(0, i3);
            break;
        }
        float magFactor = 1.0f;
        short lens = 0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            short merged = this.in.readShort();
            short color1 = this.in.readShort();
            short fileId = this.in.readShort();
            short ramp2min = this.in.readShort();
            short ramp2max = this.in.readShort();
            short color2 = this.in.readShort();
            short edited = this.in.readShort();
            lens = this.in.readShort();
            magFactor = this.in.readFloat();
            if (fileId != 12345) {
                throw new FormatException("Invalid file header : " + fileId);
            }
            this.addGlobalMeta("nx", this.getSizeX());
            this.addGlobalMeta("ny", this.getSizeY());
            this.addGlobalMeta("npic", this.getImageCount());
            this.addGlobalMeta("ramp1_min", (int)ramp1min);
            this.addGlobalMeta("ramp1_max", (int)ramp1max);
            this.addGlobalMeta("notes", notes);
            this.addGlobalMeta("image_number", (int)imageNumber);
            this.addGlobalMeta("name", name);
            this.addGlobalMeta("merged", MERGE_NAMES[merged]);
            this.addGlobalMeta("color1", (int)color1);
            this.addGlobalMeta("file_id", (int)fileId);
            this.addGlobalMeta("ramp2_min", (int)ramp2min);
            this.addGlobalMeta("ramp2_max", (int)ramp2max);
            this.addGlobalMeta("color2", (int)color2);
            this.addGlobalMeta("edited", (int)edited);
            this.addGlobalMeta("lens", (int)lens);
            this.addGlobalMeta("mag_factor", magFactor);
        } else {
            this.in.skipBytes(20);
        }
        int imageLen = this.getSizeX() * this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        this.in.skipBytes((long)bpp * (long)this.getImageCount() * (long)imageLen + 6L);
        m3.sizeZ = this.getImageCount();
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.orderCertain = false;
        m3.rgb = false;
        m3.interleaved = false;
        m3.littleEndian = true;
        m3.metadataComplete = true;
        m3.falseColor = true;
        LOGGER.info("Reading notes");
        MetadataStore store = this.makeFilterMetadata();
        this.readNotes(this.in, true);
        LOGGER.info("Populating metadata");
        ArrayList<String> pics = new ArrayList<String>();
        if (this.isGroupFiles()) {
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            String parentPath = parent.getAbsolutePath();
            Object[] list = parent.list(true);
            Arrays.sort(list);
            for (i = 0; i < list.length; ++i) {
                if (((String)list[i]).endsWith("lse.xml")) {
                    String path = new Location(parentPath, (String)list[i]).getAbsolutePath();
                    this.used.add(path);
                    handler = new BioRadHandler();
                    try (RandomAccessInputStream xml = new RandomAccessInputStream(path);){
                        XMLTools.parseXML(xml, (DefaultHandler)handler);
                    }
                    this.used.remove(this.currentId);
                    for (int q = 0; q < list.length; ++q) {
                        if (!BioRadReader.checkSuffix((String)list[q], PIC_SUFFIX)) continue;
                        path = new Location(parentPath, (String)list[q]).getAbsolutePath();
                        pics.add(path);
                        if (this.used.contains(path)) continue;
                        this.used.add(path);
                    }
                    continue;
                }
                if (!((String)list[i]).endsWith("data.raw")) continue;
                this.used.add(new Location(parentPath, (String)list[i]).getAbsolutePath());
            }
        }
        m3.dimensionOrder = "XYCTZ";
        boolean multipleFiles = this.parseNotes(store);
        if (multipleFiles && this.isGroupFiles() && pics.isEmpty()) {
            this.used.remove(this.currentId);
            long length = new Location(this.currentId).length();
            FilePattern pattern = new FilePattern(new Location(id).getAbsoluteFile());
            String[] patternFiles = pattern.getFiles();
            for (String file2 : patternFiles) {
                Location f = new Location(file2);
                if (f.length() != length) continue;
                pics.add(file2);
                if (this.used.contains(f.getAbsolutePath())) continue;
                this.used.add(f.getAbsolutePath());
            }
            if (pics.size() == 1) {
                m3.sizeC = 1;
            }
        }
        this.picFiles = pics.toArray(new String[pics.size()]);
        Arrays.sort(this.picFiles);
        if (this.picFiles.length > 0) {
            if (this.getSizeC() == 0) {
                m3.sizeC = 1;
            }
            m3.imageCount = npic * this.picFiles.length;
            if (multipleFiles) {
                m3.sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
            } else {
                m3.sizeC = this.getImageCount() / (this.getSizeZ() * this.getSizeT());
            }
        } else {
            this.picFiles = null;
        }
        if (this.getEffectiveSizeC() != this.getSizeC() && !this.isRGB()) {
            m3.sizeC = 1;
        }
        LOGGER.info("Reading lookup tables");
        this.lut = new byte[this.getEffectiveSizeC()][][];
        for (int channel = 0; channel < this.lut.length; ++channel) {
            int plane = this.getIndex(0, channel, 0);
            String file3 = this.picFiles == null ? this.currentId : this.picFiles[plane % this.picFiles.length];
            LOGGER.trace("reading table for C = {} from {}", (Object)channel, (Object)file3);
            RandomAccessInputStream s2 = new RandomAccessInputStream(file3);
            handler = null;
            try {
                s2.order(true);
                this.readLookupTables(s2);
            }
            catch (Throwable q) {
                handler = q;
                throw q;
            }
            finally {
                if (s2 != null) {
                    if (handler != null) {
                        try {
                            s2.close();
                        }
                        catch (Throwable q) {
                            ((Throwable)handler).addSuppressed(q);
                        }
                    } else {
                        s2.close();
                    }
                }
            }
            if (this.lut == null) break;
        }
        m3.indexed = this.lut != null;
        MetadataTools.populatePixels(store, this);
        store.setImageName(name, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
            store.setObjectiveLensNA(new Double(lens), 0, 0);
            store.setObjectiveNominalMagnification(new Double(magFactor), 0, 0);
            store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
            for (i = 0; i < this.getEffectiveSizeC(); ++i) {
                Double detectorGain;
                Double detectorOffset = i < this.offset.size() ? this.offset.get(i) : null;
                Double d = detectorGain = i < this.gain.size() ? this.gain.get(i) : null;
                if (detectorOffset != null || detectorGain != null) {
                    String detectorID = MetadataTools.createLSID("Detector", 0, i);
                    store.setDetectorSettingsID(detectorID, 0, i);
                    store.setDetectorID(detectorID, 0, i);
                    store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, i);
                }
                if (detectorOffset != null) {
                    store.setDetectorSettingsOffset(detectorOffset, 0, i);
                }
                if (detectorGain == null) continue;
                store.setDetectorSettingsGain(detectorGain, 0, i);
            }
        }
    }

    private void readNotes(RandomAccessInputStream s2, boolean add) throws IOException {
        s2.seek(70L);
        long imageLen = this.getSizeX() * this.getSizeY();
        imageLen = this.picFiles == null ? (imageLen *= (long)this.getImageCount()) : (imageLen *= (long)(this.getImageCount() / this.picFiles.length));
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        s2.skipBytes((long)bpp * imageLen + 6L);
        boolean notes = true;
        while (notes) {
            if (s2.getFilePointer() >= s2.length()) {
                this.brokenNotes = true;
                break;
            }
            Note n = new Note();
            n.level = s2.readShort();
            notes = s2.readInt() != 0;
            n.num = s2.readShort();
            n.status = s2.readShort();
            n.type = s2.readShort();
            n.x = s2.readShort();
            n.y = s2.readShort();
            n.p = s2.readString(80);
            if (n.type < 0 || n.type >= NOTE_NAMES.length) {
                notes = false;
                this.brokenNotes = true;
                break;
            }
            if (!add) continue;
            int ndx = n.p.length();
            for (int i = 0; i < n.p.length(); ++i) {
                if (n.p.charAt(i) != '\u0000') continue;
                ndx = i;
                break;
            }
            n.p = n.p.substring(0, ndx).trim();
            String value = n.p.replaceAll("=", "");
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(value, " ");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.length() <= 0) continue;
                v.add(token);
            }
            String[] tokens = v.toArray(new String[v.size()]);
            try {
                int noteType;
                if (tokens.length > 1 && (noteType = Integer.parseInt(tokens[1])) == 2 && value.indexOf("AXIS_4") != -1) {
                    CoreMetadata m3 = (CoreMetadata)this.core.get(0);
                    m3.sizeZ = 1;
                    m3.sizeT = this.getImageCount();
                    m3.orderCertain = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.noteStrings.add(n);
        }
    }

    private boolean parseNotes(MetadataStore store) throws FormatException {
        boolean multipleFiles = false;
        int nextDetector = 0;
        int nLasers = 0;
        for (Note n : this.noteStrings) {
            block88: {
                if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) break block88;
                block2 : switch (n.type) {
                    case 4: {
                        this.addGlobalMetaList("Note", n.toString());
                        break;
                    }
                    case 8: {
                        this.addGlobalMetaList("Note", n.toString());
                        break;
                    }
                    case 11: {
                        this.addGlobalMetaList("Note", n.toString());
                        break;
                    }
                    case 20: {
                        if (n.p.indexOf(61) >= 0) {
                            String key = n.p.substring(0, n.p.indexOf(61)).trim();
                            String value = n.p.substring(n.p.indexOf(61) + 1).trim();
                            this.addGlobalMeta(key, value);
                            if (key.equals("INFO_OBJECTIVE_NAME")) {
                                store.setObjectiveModel(value, 0, 0);
                                break;
                            }
                            if (key.equals("INFO_OBJECTIVE_MAGNIFICATION")) {
                                Double mag = Double.parseDouble(value);
                                store.setObjectiveNominalMagnification(mag, 0, 0);
                                break;
                            }
                            if (key.equals("LENS_MAGNIFICATION")) {
                                Double magnification = Double.parseDouble(value);
                                store.setObjectiveNominalMagnification(magnification, 0, 0);
                                break;
                            }
                            if (key.startsWith("SETTING")) {
                                if (key.indexOf("_DET_") == -1) break;
                                int index = key.indexOf("_DET_") + 5;
                                if (key.lastIndexOf("_") <= index) break;
                                String detectorID = MetadataTools.createLSID("Detector", 0, nextDetector);
                                store.setDetectorID(detectorID, 0, nextDetector);
                                store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, nextDetector);
                                if (key.endsWith("OFFSET")) {
                                    if (nextDetector < this.offset.size()) {
                                        this.offset.set(nextDetector, Double.parseDouble(value));
                                    } else {
                                        while (nextDetector > this.offset.size()) {
                                            this.offset.add(null);
                                        }
                                        this.offset.add(new Double(value));
                                    }
                                } else if (key.endsWith("GAIN")) {
                                    if (nextDetector < this.gain.size()) {
                                        this.gain.set(nextDetector, Double.parseDouble(value));
                                    } else {
                                        while (nextDetector > this.gain.size()) {
                                            this.gain.add(null);
                                        }
                                        this.gain.add(new Double(value));
                                    }
                                }
                                ++nextDetector;
                                break;
                            }
                            String[] values = value.split(" ");
                            if (values.length <= 1) break;
                            try {
                                Length size;
                                int type = Integer.parseInt(values[0]);
                                if (type != 257 || values.length < 3) break;
                                Double pixelSize = new Double(values[2]);
                                if (key.equals("AXIS_2")) {
                                    Length size2 = FormatTools.getPhysicalSizeX(pixelSize);
                                    if (size2 == null) break;
                                    store.setPixelsPhysicalSizeX(size2, 0);
                                    break;
                                }
                                if (!key.equals("AXIS_3") || (size = FormatTools.getPhysicalSizeY(pixelSize)) == null) break;
                                store.setPixelsPhysicalSizeY(size, 0);
                            }
                            catch (NumberFormatException type) {}
                            break;
                        }
                        if (n.p.startsWith("AXIS_2")) {
                            String[] values = n.p.split(" ");
                            Double pixelSize = new Double(values[3]);
                            Length size = FormatTools.getPhysicalSizeX(pixelSize);
                            if (size == null) break;
                            store.setPixelsPhysicalSizeX(size, 0);
                            break;
                        }
                        if (n.p.startsWith("AXIS_3")) {
                            String[] values = n.p.split(" ");
                            Double pixelSize = new Double(values[3]);
                            Length size = FormatTools.getPhysicalSizeY(pixelSize);
                            if (size == null) break;
                            store.setPixelsPhysicalSizeY(size, 0);
                            break;
                        }
                        this.addGlobalMetaList("Note", n.toString());
                        break;
                    }
                    case 21: {
                        int structureType = (n.x & 0xFF00) >> 8;
                        int version = n.x & 0xFF;
                        String[] values = n.p.split(" ");
                        if (structureType != 1) break;
                        switch (n.y) {
                            case 1: {
                                for (int i = 0; i < STRUCTURE_LABELS_1.length; ++i) {
                                    this.addGlobalMeta(STRUCTURE_LABELS_1[i], values[i]);
                                }
                                Double mag = Double.parseDouble(values[11]);
                                store.setObjectiveNominalMagnification(mag, 0, 0);
                                Double sizeZ = new Double(values[14]);
                                Length size = FormatTools.getPhysicalSizeZ(sizeZ);
                                if (size != null) {
                                    store.setPixelsPhysicalSizeZ(size, 0);
                                    break;
                                }
                                break block88;
                            }
                            case 2: {
                                for (int i = 0; i < STRUCTURE_LABELS_2.length; ++i) {
                                    this.addGlobalMeta(STRUCTURE_LABELS_2[i], values[i]);
                                }
                                double x1 = Double.parseDouble(values[2]);
                                double x2 = Double.parseDouble(values[4]);
                                double width = x2 - x1;
                                double y1 = Double.parseDouble(values[3]);
                                double y2 = Double.parseDouble(values[5]);
                                double height = y2 - y1;
                                Length sizeX = FormatTools.getPhysicalSizeX(width /= (double)this.getSizeX());
                                Length sizeY = FormatTools.getPhysicalSizeY(height /= (double)this.getSizeY());
                                if (sizeX != null) {
                                    store.setPixelsPhysicalSizeX(sizeX, 0);
                                }
                                if (sizeY != null) {
                                    store.setPixelsPhysicalSizeY(sizeY, 0);
                                    break;
                                }
                                break block88;
                            }
                            case 3: {
                                for (int i = 0; i < 3; ++i) {
                                    for (int j = 0; j < STRUCTURE_LABELS_3.length; ++j) {
                                        String v = j == STRUCTURE_LABELS_3.length - 1 ? values[12 + i] : values[i * 4 + j];
                                        this.addGlobalMetaList(STRUCTURE_LABELS_3[j], v);
                                    }
                                }
                                break block2;
                            }
                            case 4: {
                                int i;
                                nLasers = Integer.parseInt(values[0]);
                                this.addGlobalMeta("Number of lasers", values[0]);
                                this.addGlobalMeta("Number of transmission detectors", values[1]);
                                this.addGlobalMeta("Number of PMTs", values[2]);
                                for (i = 1; i <= 3; ++i) {
                                    int idx = (i + 1) * 3;
                                    this.addGlobalMetaList("Shutter present for laser", values[i + 2]);
                                    this.addGlobalMetaList("Neutral density filter for laser", values[idx]);
                                    this.addGlobalMetaList("Excitation filter for laser", values[idx + 1]);
                                    this.addGlobalMetaList("Use laser", values[idx + 2]);
                                }
                                for (i = 0; i < nLasers; ++i) {
                                    this.addGlobalMetaList("Neutral density filter name - laser", values[15 + i]);
                                }
                                break block2;
                            }
                            case 5: {
                                int i;
                                String prefix = "Excitation filter name - laser";
                                for (i = 0; i < nLasers; ++i) {
                                    this.addGlobalMetaList(prefix, values[i]);
                                }
                                break block2;
                            }
                            case 6: {
                                int i;
                                String prefix = "Emission filter name - laser";
                                for (i = 0; i < nLasers; ++i) {
                                    this.addGlobalMeta(prefix, values[i]);
                                }
                                break block2;
                            }
                            case 7: {
                                int i;
                                for (i = 0; i < 2; ++i) {
                                    String prefix = "Mixer " + i + " - ";
                                    for (int j = 0; j < STRUCTURE_LABELS_4.length; ++j) {
                                        this.addGlobalMeta(prefix + STRUCTURE_LABELS_4[j], values[i * 7 + j]);
                                    }
                                }
                                this.addGlobalMeta("Mixer 0 - low signal on", values[14]);
                                this.addGlobalMeta("Mixer 1 - low signal on", values[15]);
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 10: {
                                this.addGlobalMeta("Laser name - laser " + (n.y - 7), values[0]);
                                break;
                            }
                            case 11: {
                                int i;
                                for (i = 0; i < 3; ++i) {
                                    String prefix = "Transmission detector " + (i + 1) + " - ";
                                    this.addGlobalMeta(prefix + "offset", values[i * 3]);
                                    this.addGlobalMeta(prefix + "gain", values[i * 3 + 1]);
                                    this.addGlobalMeta(prefix + "black level", values[i * 3 + 2]);
                                    String detectorID = MetadataTools.createLSID("Detector", 0, i);
                                    store.setDetectorID(detectorID, 0, i);
                                    store.setDetectorOffset(new Double(values[i * 3]), 0, i);
                                    store.setDetectorGain(new Double(values[i * 3 + 1]), 0, i);
                                    store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, i);
                                }
                                break block2;
                            }
                            case 12: {
                                int i;
                                for (i = 0; i < 2; ++i) {
                                    String prefix = "Part number for ";
                                    for (int j = 0; j < STRUCTURE_LABELS_5.length; ++j) {
                                        this.addGlobalMetaList(prefix + STRUCTURE_LABELS_5[j], values[i * 4 + j]);
                                    }
                                }
                                break block2;
                            }
                            case 13: {
                                int i;
                                for (i = 0; i < STRUCTURE_LABELS_6.length; ++i) {
                                    this.addGlobalMeta(STRUCTURE_LABELS_6[i], values[i]);
                                }
                                break block2;
                            }
                            case 14: {
                                String prefix = "Filter Block Name - filter block ";
                                this.addGlobalMetaList(prefix, values[0]);
                                this.addGlobalMetaList(prefix, values[1]);
                                break;
                            }
                            case 15: {
                                int i;
                                for (i = 0; i < 5; ++i) {
                                    this.addGlobalMetaList("Image bands status - band", values[i * 3]);
                                    this.addGlobalMetaList("Image bands min - band", values[i * 3 + 1]);
                                    this.addGlobalMetaList("Image bands max - band", values[i * 3 + 2]);
                                    if (!(store instanceof IMinMaxStore)) continue;
                                    ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(i, Double.parseDouble(values[i * 3 + 1]), Double.parseDouble(values[i * 3 + 2]), 0);
                                }
                                break block2;
                            }
                            case 17: {
                                int year = Integer.parseInt(values[5]) + 1900;
                                for (int i = 0; i < 5; ++i) {
                                    if (values[i].length() != 1) continue;
                                    values[i] = "0" + values[i];
                                }
                                String date = year + "-" + values[4] + "-" + values[3] + "T" + values[2] + ":" + values[1] + ":" + values[0];
                                this.addGlobalMeta("Acquisition date", date);
                                try {
                                    store.setImageAcquisitionDate(new Timestamp(date), 0);
                                }
                                catch (Exception e) {
                                    LOGGER.debug("Failed to parse acquisition date", e);
                                }
                                break;
                            }
                            case 18: {
                                this.addGlobalMeta("Mixer 3 - enhanced", values[0]);
                                for (int i = 1; i <= 3; ++i) {
                                    this.addGlobalMetaList("Mixer 3 - PMT percentage", values[i]);
                                    this.addGlobalMetaList("Mixer 3 - Transmission percentage", values[i + 3]);
                                    this.addGlobalMetaList("Mixer 3 - photon counting", values[i + 7]);
                                }
                                this.addGlobalMeta("Mixer 3 - low signal on", values[7]);
                                this.addGlobalMeta("Mixer 3 - mode", values[11]);
                                break;
                            }
                            case 19: {
                                for (int i = 1; i <= 2; ++i) {
                                    String prefix = "Mixer " + i + " - ";
                                    String photon = prefix + "photon counting ";
                                    this.addGlobalMetaList(photon, values[i * 4 - 4]);
                                    this.addGlobalMetaList(photon, values[i * 4 - 3]);
                                    this.addGlobalMetaList(photon, values[i * 4 - 2]);
                                    this.addGlobalMeta(prefix + "mode", values[i * 4 - 1]);
                                }
                                break block2;
                            }
                            case 20: {
                                this.addGlobalMeta("Display mode", values[0]);
                                this.addGlobalMeta("Course", values[1]);
                                this.addGlobalMeta("Time Course - experiment type", values[2]);
                                this.addGlobalMeta("Time Course - kd factor", values[3]);
                                String experimentID = MetadataTools.createLSID("Experiment", 0);
                                store.setExperimentID(experimentID, 0);
                                store.setExperimentType(MetadataTools.getExperimentType(values[2]), 0);
                                break;
                            }
                            case 21: {
                                this.addGlobalMeta("Time Course - ion name", values[0]);
                                break;
                            }
                            case 22: {
                                this.addGlobalMeta("PIC file generated on Isoscan (lite)", values[0]);
                                for (int i = 1; i <= 3; ++i) {
                                    this.addGlobalMetaList("Photon counting used - PMT", values[i]);
                                    this.addGlobalMetaList("Hot spot filter used - PMT", values[i + 3]);
                                    this.addGlobalMetaList("Tx Selector used - TX", values[i + 6]);
                                }
                            }
                        }
                        break;
                    }
                    default: {
                        this.addGlobalMetaList("Note", n.toString());
                    }
                }
            }
            if (n.p.indexOf("AXIS") == -1) continue;
            n.p = n.p.replaceAll("=", "");
            ArrayList<String> v = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(n.p, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                v.add(token);
            }
            String[] values = v.toArray(new String[v.size()]);
            String key = values[0];
            String noteType = values[1];
            int axisType = Integer.parseInt(noteType);
            if (axisType == 11 && values.length > 2) {
                this.addGlobalMeta(key + " RGB type (X)", values[2]);
                this.addGlobalMeta(key + " RGB type (Y)", values[3]);
                CoreMetadata m3 = (CoreMetadata)this.core.get(0);
                if (key.equals("AXIS_4")) {
                    m3.sizeC = this.getImageCount();
                    m3.sizeZ = 1;
                    m3.sizeT = 1;
                } else if (key.equals("AXIS_9")) {
                    multipleFiles = true;
                    m3.sizeC = (int)Double.parseDouble(values[3]);
                }
            }
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || values.length <= 2) continue;
            switch (axisType) {
                case 1: {
                    this.addGlobalMeta(key + " distance (X) in microns", values[2]);
                    this.addGlobalMeta(key + " distance (Y) in microns", values[3]);
                    break;
                }
                case 3: {
                    this.addGlobalMeta(key + " angle (X) in degrees", values[2]);
                    this.addGlobalMeta(key + " angle (Y) in degrees", values[3]);
                    break;
                }
                case 4: {
                    this.addGlobalMeta(key + " intensity (X)", values[2]);
                    this.addGlobalMeta(key + " intensity (Y)", values[3]);
                    break;
                }
                case 6: {
                    this.addGlobalMeta(key + " ratio (X)", values[2]);
                    this.addGlobalMeta(key + " ratio (Y)", values[3]);
                    break;
                }
                case 7: {
                    this.addGlobalMeta(key + " log ratio (X)", values[2]);
                    this.addGlobalMeta(key + " log ratio (Y)", values[3]);
                    break;
                }
                case 9: {
                    this.addGlobalMeta(key + " noncalibrated intensity min", values[2]);
                    this.addGlobalMeta(key + " noncalibrated intensity max", values[3]);
                    this.addGlobalMeta(key + " calibrated intensity min", values[4]);
                    this.addGlobalMeta(key + " calibrated intensity max", values[5]);
                    break;
                }
                case 14: {
                    this.addGlobalMeta(key + " time course type (X)", values[2]);
                    this.addGlobalMeta(key + " time course type (Y)", values[3]);
                    break;
                }
                case 15: {
                    String prefix = " inverse sigmoid calibrated intensity ";
                    this.addGlobalMeta(key + prefix + "(min)", values[2]);
                    this.addGlobalMeta(key + prefix + "(max)", values[3]);
                    this.addGlobalMeta(key + prefix + "(beta)", values[4]);
                    this.addGlobalMeta(key + prefix + "(Kd)", values[5]);
                    break;
                }
                case 16: {
                    String prefix = " log inverse sigmoid calibrated intensity ";
                    this.addGlobalMeta(key + prefix + "(min)", values[2]);
                    this.addGlobalMeta(key + prefix + "(max)", values[3]);
                    this.addGlobalMeta(key + prefix + "(beta)", values[4]);
                    this.addGlobalMeta(key + prefix + "(Kd)", values[5]);
                }
            }
        }
        return multipleFiles;
    }

    private void readLookupTables(RandomAccessInputStream s2) throws IOException {
        int channel;
        for (channel = 0; channel < this.lut.length && this.lut[channel] != null; ++channel) {
        }
        if (channel >= this.lut.length) {
            return;
        }
        this.readNotes(s2, false);
        boolean eof = false;
        int next = 0;
        while (!eof && channel < this.lut.length && !this.brokenNotes) {
            if (s2.getFilePointer() + 256L <= s2.length()) {
                if (this.lut[channel] == null) {
                    this.lut[channel] = new byte[3][256];
                }
                s2.read(this.lut[channel][next++]);
                if (next == 3) {
                    next = 0;
                    ++channel;
                }
            } else {
                eof = true;
            }
            if (!eof || channel != 0) continue;
            this.lut = null;
        }
        if (this.brokenNotes) {
            this.lut = null;
        }
    }

    class Note {
        public int num;
        public int level;
        public int status;
        public int type;
        public int x;
        public int y;
        public String p;

        Note() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(100);
            sb.append("level=");
            sb.append(this.level);
            sb.append("; num=");
            sb.append(this.num);
            sb.append("; status=");
            sb.append(this.status);
            sb.append("; type=");
            sb.append(NOTE_NAMES[this.type]);
            sb.append("; x=");
            sb.append(this.x);
            sb.append("; y=");
            sb.append(this.y);
            sb.append("; text=");
            sb.append(this.p == null ? "null" : this.p.trim());
            return sb.toString();
        }
    }

    class BioRadHandler
    extends BaseHandler {
        BioRadHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("Pixels")) {
                String sizeZ = attributes.getValue("SizeZ");
                String sizeC = attributes.getValue("SizeC");
                String sizeT = attributes.getValue("SizeT");
                int z = sizeZ == null ? 1 : Integer.parseInt(sizeZ);
                int c = sizeC == null ? 1 : Integer.parseInt(sizeC);
                int t = sizeT == null ? 1 : Integer.parseInt(sizeT);
                int count = BioRadReader.this.getSizeZ() * BioRadReader.this.getSizeC() * BioRadReader.this.getSizeT();
                CoreMetadata m3 = (CoreMetadata)BioRadReader.this.core.get(0);
                m3.sizeZ = z;
                m3.sizeC = c;
                m3.sizeT = t;
                if (count >= BioRadReader.this.getImageCount()) {
                    m3.imageCount = count;
                } else {
                    m3.sizeC = BioRadReader.this.getImageCount() / count;
                }
            } else if (qName.equals("Z") || qName.equals("C") || qName.equals("T")) {
                String stamp = attributes.getValue("TimeCompleted");
                BioRadReader.this.addGlobalMetaList("Timestamp", stamp);
            }
        }
    }
}

