/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class VarianFDFReader
extends FormatReader {
    private final List<String> files = new ArrayList<String>();
    private long[] pixelOffsets;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private Length originX;
    private Length originY;
    private Length originZ;
    private String[] units;

    public VarianFDFReader() {
        super("Varian FDF", "fdf");
        this.domains = new String[]{"Medical Imaging"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return null;
        }
        if (this.files.isEmpty()) {
            return new String[]{this.currentId};
        }
        return this.files.toArray(new String[this.files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        try {
            if (this.files.size() > 1) {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = new RandomAccessInputStream(this.files.get(no));
                this.in.order(this.isLittleEndian());
            }
            this.in.seek(this.pixelOffsets[no]);
            this.readPlane(this.in, x, this.getSizeY() - y - h2, w, h2, buf);
            int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
            byte[] rowBuf = new byte[w * bpp];
            for (int row = 0; row < h2 / 2; ++row) {
                int src = row * rowBuf.length;
                int dest = (h2 - row - 1) * rowBuf.length;
                System.arraycopy(buf, src, rowBuf, 0, rowBuf.length);
                System.arraycopy(buf, dest, buf, src, rowBuf.length);
                System.arraycopy(rowBuf, 0, buf, dest, rowBuf.length);
            }
        }
        finally {
            if (this.files.size() > 1) {
                this.in.close();
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffsets = null;
            this.files.clear();
            this.pixelSizeX = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeZ = 0.0;
            this.originX = null;
            this.originY = null;
            this.originZ = null;
            this.units = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeZ = 1;
        m3.sizeC = 1;
        m3.sizeT = 1;
        this.parseFDF(id);
        m3.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        m3.dimensionOrder = "XYTZC";
        if (this.files.size() > this.getImageCount()) {
            int rem = this.files.size() / this.getImageCount();
            m3.sizeT *= rem;
            m3.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        }
        this.pixelOffsets = new long[this.getImageCount()];
        int planeSize = FormatTools.getPlaneSize(this);
        for (int i = 0; i < this.pixelOffsets.length; ++i) {
            if (this.files.size() > 1) {
                this.in.close();
                this.in = new RandomAccessInputStream(this.files.get(i));
                this.pixelOffsets[i] = this.in.length() - (long)planeSize;
                continue;
            }
            this.pixelOffsets[i] = this.in.length() - (long)(planeSize * (this.getImageCount() - i));
        }
        boolean minMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, !minMetadata);
        if (!minMetadata) {
            Length sizeX = FormatTools.getPhysicalSizeX(this.pixelSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(this.pixelSizeY);
            Length sizeZ = FormatTools.getPhysicalSizeZ(this.pixelSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlanePositionX(this.originX, 0, i);
                store.setPlanePositionY(this.originY, 0, i);
                store.setPlanePositionZ(this.originZ, 0, i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFDF(String file2) throws FormatException, IOException {
        String[] lines;
        this.in = new RandomAccessInputStream(file2);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        boolean storedFloats = false;
        boolean multifile = false;
        String data = this.in.readString(Character.toString('\f'));
        for (String line : lines = data.split("\n")) {
            String[] values;
            if ((line = line.trim()).length() == 0) break;
            if (line.startsWith("#")) continue;
            int space = line.indexOf(32);
            int eq = line.indexOf(61);
            String type = line.substring(0, space).trim();
            String var = line.substring(space, eq).trim();
            String value = line.substring(eq + 1, line.indexOf(59)).trim();
            if (var.equals("*storage")) {
                storedFloats = value.equals("\"float\"");
            }
            if (var.equals("bits")) {
                m3.bitsPerPixel = Integer.parseInt(value);
                if (value.equals("8")) {
                    m3.pixelType = 1;
                } else if (value.equals("16")) {
                    m3.pixelType = 3;
                } else {
                    if (!value.equals("32")) throw new FormatException("Unsupported bits: " + value);
                    m3.pixelType = storedFloats ? 6 : 5;
                }
            } else if (var.equals("matrix[]")) {
                values = this.parseArray(value);
                m3.sizeX = (int)Double.parseDouble(values[0]);
                m3.sizeY = (int)Double.parseDouble(values[1]);
                if (values.length > 2) {
                    m3.sizeZ = (int)Double.parseDouble(values[2]);
                }
            } else if (var.equals("slices")) {
                m3.sizeZ = Integer.parseInt(value);
                multifile = true;
            } else if (var.equals("echoes")) {
                m3.sizeT = Integer.parseInt(value);
                multifile = true;
            } else if (var.equals("span[]")) {
                values = this.parseArray(value);
                if (values.length > 0) {
                    this.pixelSizeX = this.computePhysicalSize(this.getSizeX(), values[0], this.units[0]);
                }
                if (values.length > 1) {
                    this.pixelSizeY = this.computePhysicalSize(this.getSizeY(), values[1], this.units[1]);
                }
                if (values.length > 2) {
                    this.pixelSizeZ = this.computePhysicalSize(this.getSizeZ(), values[2], this.units[2]);
                }
            } else if (var.equals("origin[]")) {
                double size;
                values = this.parseArray(value);
                if (values.length > 0) {
                    size = this.computePhysicalSize(1, values[0], this.units[0]);
                    this.originX = new Length(size, UNITS.REFERENCEFRAME);
                    this.addGlobalMeta("X position for position #1", this.originX);
                }
                if (values.length > 1) {
                    size = this.computePhysicalSize(1, values[1], this.units[1]);
                    this.originY = new Length(size, UNITS.REFERENCEFRAME);
                    this.addGlobalMeta("Y position for position #1", this.originY);
                }
                if (values.length > 2) {
                    size = this.computePhysicalSize(1, values[2], this.units[2]);
                    this.originZ = new Length(size, UNITS.REFERENCEFRAME);
                    this.addGlobalMeta("Z position for position #1", this.originZ);
                }
            } else if (var.equals("*abscissa[]")) {
                this.units = this.parseArray(value);
            } else if (var.equals("bigendian")) {
                m3.littleEndian = value.equals("0");
                this.in.order(this.isLittleEndian());
            }
            this.addGlobalMeta(var, value);
        }
        if (!multifile || !this.files.isEmpty()) return;
        Location thisFile = new Location(file2).getAbsoluteFile();
        Location parent = thisFile.getParentFile();
        Object[] list = parent.list(true);
        Arrays.sort(list);
        for (Object f : list) {
            if (!VarianFDFReader.checkSuffix((String)f, "fdf") || ((String)f).length() != thisFile.getName().length()) continue;
            this.files.add(new Location(parent, (String)f).getAbsolutePath());
        }
    }

    private String[] parseArray(String value) {
        value = value.replaceAll("[{}]", "");
        String[] values = value.split(",");
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i].replaceAll("\"", "");
            values[i] = values[i].trim();
        }
        return values;
    }

    private double computePhysicalSize(int length, String physicalLength, String unit) {
        double size = Double.parseDouble(physicalLength) / (double)length;
        if (unit.equals("cm")) {
            size *= 1000.0;
        }
        return size;
    }
}

