# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObservabilityProjectArgs', 'ObservabilityProject']

@pulumi.input_type
class ObservabilityProjectArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[_builtins.str],
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ObservabilityProject resource.
        :param pulumi.Input[_builtins.str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[_builtins.str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[_builtins.str] name: Descriptive name for a project.
        """
        pulumi.set(__self__, "region_id", region_id)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[_builtins.str]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ObservabilityProjectState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['ObservabilityProjectCredentialsArgs']] = None,
                 endpoints: Optional[pulumi.Input['ObservabilityProjectEndpointsArgs']] = None,
                 metadata: Optional[pulumi.Input['ObservabilityProjectMetadataArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObservabilityProject resources.
        :param pulumi.Input[_builtins.str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[_builtins.str] cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        :param pulumi.Input['ObservabilityProjectCredentialsArgs'] credentials: Basic auth credentials to access the Elasticsearch API.
        :param pulumi.Input['ObservabilityProjectEndpointsArgs'] endpoints: The endpoints to access the different apps of the project.
        :param pulumi.Input['ObservabilityProjectMetadataArgs'] metadata: Additional details about the project.
        :param pulumi.Input[_builtins.str] name: Descriptive name for a project.
        :param pulumi.Input[_builtins.str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[_builtins.str] type: the type of the project
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ObservabilityProjectCredentialsArgs']]:
        """
        Basic auth credentials to access the Elasticsearch API.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ObservabilityProjectCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['ObservabilityProjectEndpointsArgs']]:
        """
        The endpoints to access the different apps of the project.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['ObservabilityProjectEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ObservabilityProjectMetadataArgs']]:
        """
        Additional details about the project.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ObservabilityProjectMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        the type of the project
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ec:index/observabilityProject:ObservabilityProject")
class ObservabilityProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Technical preview

        This functionality is in technical preview and may be changed or removed in a future release.
        Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ec as ec

        my_project = ec.ObservabilityProject("my_project",
            name="my_project",
            region_id="aws-us-east-1")
        ```

        ## Import

        Projects can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/observabilityProject:ObservabilityProject id 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[_builtins.str] name: Descriptive name for a project.
        :param pulumi.Input[_builtins.str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObservabilityProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Technical preview

        This functionality is in technical preview and may be changed or removed in a future release.
        Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ec as ec

        my_project = ec.ObservabilityProject("my_project",
            name="my_project",
            region_id="aws-us-east-1")
        ```

        ## Import

        Projects can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/observabilityProject:ObservabilityProject id 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param ObservabilityProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObservabilityProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObservabilityProjectArgs.__new__(ObservabilityProjectArgs)

            __props__.__dict__["alias"] = alias
            __props__.__dict__["name"] = name
            if region_id is None and not opts.urn:
                raise TypeError("Missing required property 'region_id'")
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["cloud_id"] = None
            __props__.__dict__["credentials"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["type"] = None
        super(ObservabilityProject, __self__).__init__(
            'ec:index/observabilityProject:ObservabilityProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            cloud_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Union['ObservabilityProjectCredentialsArgs', 'ObservabilityProjectCredentialsArgsDict']]] = None,
            endpoints: Optional[pulumi.Input[Union['ObservabilityProjectEndpointsArgs', 'ObservabilityProjectEndpointsArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Union['ObservabilityProjectMetadataArgs', 'ObservabilityProjectMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObservabilityProject':
        """
        Get an existing ObservabilityProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[_builtins.str] cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        :param pulumi.Input[Union['ObservabilityProjectCredentialsArgs', 'ObservabilityProjectCredentialsArgsDict']] credentials: Basic auth credentials to access the Elasticsearch API.
        :param pulumi.Input[Union['ObservabilityProjectEndpointsArgs', 'ObservabilityProjectEndpointsArgsDict']] endpoints: The endpoints to access the different apps of the project.
        :param pulumi.Input[Union['ObservabilityProjectMetadataArgs', 'ObservabilityProjectMetadataArgsDict']] metadata: Additional details about the project.
        :param pulumi.Input[_builtins.str] name: Descriptive name for a project.
        :param pulumi.Input[_builtins.str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[_builtins.str] type: the type of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObservabilityProjectState.__new__(_ObservabilityProjectState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["type"] = type
        return ObservabilityProject(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[_builtins.str]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        """
        return pulumi.get(self, "cloud_id")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.ObservabilityProjectCredentials']:
        """
        Basic auth credentials to access the Elasticsearch API.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output['outputs.ObservabilityProjectEndpoints']:
        """
        The endpoints to access the different apps of the project.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.ObservabilityProjectMetadata']:
        """
        Additional details about the project.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        the type of the project
        """
        return pulumi.get(self, "type")

