# -*- coding: utf-8 -*-
# (c) Copyright 2019 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.4.0
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdAnalogMeasurementBase(ShdlcCommand):
    """
    SHDLC command 0x80: "Analog Measurement".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdAnalogMeasurementBase, self).__init__(
            0x80, *args, **kwargs)


class SensorBridgeCmdAnalogMeasurement(SensorBridgeCmdAnalogMeasurementBase):

    def __init__(self, port):
        """
        Analog Measurement Command

        Triggers an analog measurement at the AIN pin of a specific port. The
        measured voltage is always positive and in the range of 0-5.5V.

        :param int port:
            The port where the measurement should be executed:
            
            -  0x00: Port 1
            -  0x01: Port 2
        """
        super(SensorBridgeCmdAnalogMeasurement, self).__init__(
            data=b"".join([pack(">1B", port)]),
            max_response_time=0.1,
            post_processing_time=0.0,
            min_response_length=4,
            max_response_length=4
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: Measured voltage in Volts.
        :rtype: float
        """
        voltage = float(unpack(">1f", data[0:4])[0])  # float
        return voltage
