# -*- coding: utf-8 -*-
# (c) Copyright 2019 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.4.0
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdDeviceInformationBase(ShdlcCommand):
    """
    SHDLC command 0xD0: "Device Information".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdDeviceInformationBase, self).__init__(
            0xD0, *args, **kwargs)


class SensorBridgeCmdGetProductType(SensorBridgeCmdDeviceInformationBase):

    def __init__(self):
        """
        Get Product Type Command

        Gets the product type from the device.
        """
        super(SensorBridgeCmdGetProductType, self).__init__(
            data=[0x00],
            max_response_time=0.005,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: String containing the product type.
        :rtype: string
        """
        prod_type = str(data[0:].decode('utf-8').rstrip('\0'))  # string
        return prod_type


class SensorBridgeCmdGetProductName(SensorBridgeCmdDeviceInformationBase):

    def __init__(self):
        """
        Get Product Name Command

        Gets the product name from the device.
        """
        super(SensorBridgeCmdGetProductName, self).__init__(
            data=[0x01],
            max_response_time=0.005,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: String containing the product name.
        :rtype: string
        """
        prod_name = str(data[0:].decode('utf-8').rstrip('\0'))  # string
        return prod_name


class SensorBridgeCmdGetArticleCode(SensorBridgeCmdDeviceInformationBase):

    def __init__(self):
        """
        Get Article Code Command

        Gets the article code from the device.
        """
        super(SensorBridgeCmdGetArticleCode, self).__init__(
            data=[0x02],
            max_response_time=0.005,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: String containing the article code.
        :rtype: string
        """
        article_code = str(data[0:].decode('utf-8').rstrip('\0'))  # string
        return article_code


class SensorBridgeCmdGetSerialNumber(SensorBridgeCmdDeviceInformationBase):

    def __init__(self):
        """
        Get Serial Number Command

        Gets the serial number from the device.
        """
        super(SensorBridgeCmdGetSerialNumber, self).__init__(
            data=[0x03],
            max_response_time=0.005,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: String containing the serial number.
        :rtype: string
        """
        serial_no = str(data[0:].decode('utf-8').rstrip('\0'))  # string
        return serial_no
