# -*- coding: utf-8 -*-
# (c) Copyright 2019 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.4.0
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdI2cRepeatedTransceiveBase(ShdlcCommand):
    """
    SHDLC command 0x12: "I2c Repeated Transceive".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdI2cRepeatedTransceiveBase, self).__init__(
            0x12, *args, **kwargs)


class SensorBridgeCmdI2cRepeatedTransceive(SensorBridgeCmdI2cRepeatedTransceiveBase):

    def __init__(self, interval_us, port, i2c_address, tx_length, rx_length, timeout_us, read_delay_us, tx_data):
        """
        I2c Repeated Transceive Command

        Starts an asynchronous transceive command in a specific interval.
        Multiple parallel repeated transceives are possible. The returned data
        is stored in a buffer and can be read out with the "Read Buffer"
        command. The amount of data to write or read is limited.

        :param int interval_us:
            The interval in microseconds.
        :param int port:
            The port(s) where the repeated transceive should be started:
            
            -  0x00: Port 1
            -  0x01: Port 2
            -  0xFF: All ports
        :param int i2c_address:
            I2C address of the targeted device.
        :param int tx_length:
            Number of bytes to send. This amount of bytes has to be attached to
            the command. Set to zero if only read header is needed.
        :param int rx_length:
            Number of bytes to receive. This amount of bytes are returned as
            response to the read buffer command. Set to zero if no read
            operation is needed.
        :param int timeout_us:
            I2C timeout in microseconds when reading bytes. If frame is NACK'd
            it will be retried up to the timeout value. Same applies for clock
            stretching.
        :param int read_delay_us:
            This time will be inserted between the write and the read frame. to
            allow a device taking a certain amount of time for its
            measurements. The delay must be smaller than the specified timeout.
        :param bytearray tx_data:
            Bytes to send (if any).
        """
        super(SensorBridgeCmdI2cRepeatedTransceive, self).__init__(
            data=b"".join([pack(">1I", interval_us),
                           pack(">1B", port),
                           pack(">1B", i2c_address),
                           pack(">1I", tx_length),
                           pack(">1I", rx_length),
                           pack(">1I", timeout_us),
                           pack(">1I", read_delay_us),
                           bytes(bytearray(tx_data))]),
            max_response_time=0.05,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: One or more unique handles with following information:
                 
                 -  Unique number (higher nibble, 0..7)
                 -  Channel number (lower nibble, 0..1)
                 
                 There are 8 available memory slots for the repeated transceive
                 tasks and they are identified by the unique number.
        :rtype: bytearray
        """
        handles = bytes(data[0:])  # bytes
        return handles
