# -*- coding: utf-8 -*-
# (c) Copyright 2019 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.4.0
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdSetI2cFrequencyBase(ShdlcCommand):
    """
    SHDLC command 0x02: "Set I2c Frequency".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdSetI2cFrequencyBase, self).__init__(
            0x02, *args, **kwargs)


class SensorBridgeCmdSetI2cFrequency(SensorBridgeCmdSetI2cFrequencyBase):

    def __init__(self, port, frequency):
        """
        Set I2c Frequency Command

        Sets the I2C frequency to the desired value. The default frequency is
        400kHz.

        :param int port:
            The port(s) where the frequency should be set:
            
            -  0x00: Port 1
            -  0x01: Port 2
            -  0xFF: All ports
        :param int frequency:
            The frequency to set:
            
            -  0x00: 100kHz
            -  0x01: 400kHz
            -  0x02: 1MHz
            -  0x03: 2MHz
            -  0x04: 10kHz (since FW v5.6)
            -  0x05: 50kHz (since FW v5.6)
        """
        super(SensorBridgeCmdSetI2cFrequency, self).__init__(
            data=b"".join([pack(">1B", port),
                           pack(">1B", frequency)]),
            max_response_time=0.05,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=0
        )
