# -*- coding: utf-8 -*-
# (c) Copyright 2019 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.4.0
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdSetPortVoltageBase(ShdlcCommand):
    """
    SHDLC command 0x00: "Set Port Voltage".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdSetPortVoltageBase, self).__init__(
            0x00, *args, **kwargs)


class SensorBridgeCmdSetPortVoltage(SensorBridgeCmdSetPortVoltageBase):

    def __init__(self, port, voltage):
        """
        Set Port Voltage Command

        Sets the voltage of a port to a certain value.

        :param int port:
            The port(s) where the voltage should be set:
            
            -  0x00: Port 1
            -  0x01: Port 2
            -  0xFF: All ports
        :param int voltage:
            The voltage to set:
            
            -  0x00: 1.2V
            -  0x01: 1.8V
            -  0x02: 3.3V
            -  0x03: 5.0V
            -  0x04: 1.5V
            -  0x05: 2.1V
            -  0x06: 2.4V
            -  0x07: 2.7V
            -  0x08: 3.0V
            -  0x09: 3.6V
            -  0x0A: 4.5V
            -  0x0B: 5.5V
        """
        super(SensorBridgeCmdSetPortVoltage, self).__init__(
            data=b"".join([pack(">1B", port),
                           pack(">1B", voltage)]),
            max_response_time=0.05,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=0
        )
