# -*- coding: utf-8 -*-
# (c) Copyright 2019 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.4.0
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.errors import ShdlcDeviceError

import logging
log = logging.getLogger(__name__)


class SensorBridgeFunctionalityNotImplementedError(ShdlcDeviceError):
    """
    SHDLC device error for functionality not implemented.
    """
    def __init__(self):
        super(SensorBridgeFunctionalityNotImplementedError, self).__init__(
            0x20,
            "The command is not supported by the device."
        )


class SensorBridgeNoMorePeriodicMeasurementsPossibleError(ShdlcDeviceError):
    """
    SHDLC device error for no more periodic measurements possible.
    """
    def __init__(self):
        super(SensorBridgeNoMorePeriodicMeasurementsPossibleError, self).__init__(
            0x21,
            "Too many repeated transceive operations are already running."
        )


class SensorBridgeFrameChecksumError(ShdlcDeviceError):
    """
    SHDLC device error for frame checksum error.
    """
    def __init__(self):
        super(SensorBridgeFrameChecksumError, self).__init__(
            0x22,
            "The received command contained a wrong checksum."
        )


class SensorBridgeFrameSizeInfoMismatchError(ShdlcDeviceError):
    """
    SHDLC device error for frame size info mismatch.
    """
    def __init__(self):
        super(SensorBridgeFrameSizeInfoMismatchError, self).__init__(
            0x26,
            "The received command had a different size than specified in the "
            "size field."
        )


class SensorBridgeI2cNackError(ShdlcDeviceError):
    """
    SHDLC device error for I2C NACK.
    """
    def __init__(self):
        super(SensorBridgeI2cNackError, self).__init__(
            0x29,
            "An I2C slave did not acknowledge the sent data."
        )


class SensorBridgeI2cTimeoutError(ShdlcDeviceError):
    """
    SHDLC device error for I2C timeout.
    """
    def __init__(self):
        super(SensorBridgeI2cTimeoutError, self).__init__(
            0x2B,
            "An I2C operation timed out."
        )


class SensorBridgeFatalError(ShdlcDeviceError):
    """
    SHDLC device error for fatal errors.
    """
    def __init__(self):
        super(SensorBridgeFatalError, self).__init__(
            0x7F,
            "An unknown error occurred."
        )


"""
List containing all device errors specified in this file.
"""
SENSORBRIDGE_DEVICE_ERROR_LIST = [
    SensorBridgeFunctionalityNotImplementedError(),
    SensorBridgeNoMorePeriodicMeasurementsPossibleError(),
    SensorBridgeFrameChecksumError(),
    SensorBridgeFrameSizeInfoMismatchError(),
    SensorBridgeI2cNackError(),
    SensorBridgeI2cTimeoutError(),
    SensorBridgeFatalError(),
]
