import * as events from '@aws-cdk/aws-events';
import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * Properties for TidyUp construct.
 *
 * @stability stable
 */
export interface TidyUpProps {
    /**
     * your custom function to process the garbage collection.
     *
     * @default - a default function will be created
     * @stability stable
     */
    readonly function?: lambda.IFunction;
    /**
     * The schedule to trigger the state machine.
     *
     * @default - every 4 hours
     * @stability stable
     */
    readonly schedule?: events.Schedule;
    /**
     * The ECR public repositories to check.
     *
     * @stability stable
     */
    readonly repository: string[];
}
/**
 * The primary consruct to tidy up ECR public images.
 *
 * @stability stable
 */
export declare class TidyUp extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly repository: string[];
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: TidyUpProps);
    private _addHandler;
}
/**
 * properties for the Handler.
 *
 * @stability stable
 */
export interface HandlerProps {
    /**
     * @stability stable
     */
    readonly repository: string[];
}
/**
 * The default handler.
 *
 * @stability stable
 */
export declare class Handler extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly function: lambda.IFunction;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: HandlerProps);
}
