import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_hub#name DataAzurermVirtualHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_hub#resource_group_name DataAzurermVirtualHub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_hub#timeouts DataAzurermVirtualHub#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualHubTimeouts;
}
export interface DataAzurermVirtualHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_hub#read DataAzurermVirtualHub#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualHubTimeoutsToTerraform(struct?: DataAzurermVirtualHubTimeoutsOutputReference | DataAzurermVirtualHubTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualHubTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualHubTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_hub azurerm_virtual_hub}
*/
export declare class DataAzurermVirtualHub extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_hub";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_hub azurerm_virtual_hub} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualHubConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualHubConfig);
    get addressPrefix(): string;
    get defaultRouteTableId(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get virtualWanId(): string;
    private _timeouts;
    get timeouts(): DataAzurermVirtualHubTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
