import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PostgresqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#administrator_login PostgresqlFlexibleServer#administrator_login}
    */
    readonly administratorLogin?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#administrator_password PostgresqlFlexibleServer#administrator_password}
    */
    readonly administratorPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#backup_retention_days PostgresqlFlexibleServer#backup_retention_days}
    */
    readonly backupRetentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#create_mode PostgresqlFlexibleServer#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#delegated_subnet_id PostgresqlFlexibleServer#delegated_subnet_id}
    */
    readonly delegatedSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#geo_redundant_backup_enabled PostgresqlFlexibleServer#geo_redundant_backup_enabled}
    */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#location PostgresqlFlexibleServer#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#name PostgresqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#point_in_time_restore_time_in_utc PostgresqlFlexibleServer#point_in_time_restore_time_in_utc}
    */
    readonly pointInTimeRestoreTimeInUtc?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#private_dns_zone_id PostgresqlFlexibleServer#private_dns_zone_id}
    */
    readonly privateDnsZoneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#resource_group_name PostgresqlFlexibleServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#sku_name PostgresqlFlexibleServer#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#source_server_id PostgresqlFlexibleServer#source_server_id}
    */
    readonly sourceServerId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#storage_mb PostgresqlFlexibleServer#storage_mb}
    */
    readonly storageMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#tags PostgresqlFlexibleServer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#version PostgresqlFlexibleServer#version}
    */
    readonly version?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#zone PostgresqlFlexibleServer#zone}
    */
    readonly zone?: string;
    /**
    * high_availability block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#high_availability PostgresqlFlexibleServer#high_availability}
    */
    readonly highAvailability?: PostgresqlFlexibleServerHighAvailability;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#maintenance_window PostgresqlFlexibleServer#maintenance_window}
    */
    readonly maintenanceWindow?: PostgresqlFlexibleServerMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#timeouts PostgresqlFlexibleServer#timeouts}
    */
    readonly timeouts?: PostgresqlFlexibleServerTimeouts;
}
export interface PostgresqlFlexibleServerHighAvailability {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#mode PostgresqlFlexibleServer#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#standby_availability_zone PostgresqlFlexibleServer#standby_availability_zone}
    */
    readonly standbyAvailabilityZone?: string;
}
export declare function postgresqlFlexibleServerHighAvailabilityToTerraform(struct?: PostgresqlFlexibleServerHighAvailabilityOutputReference | PostgresqlFlexibleServerHighAvailability): any;
export declare class PostgresqlFlexibleServerHighAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PostgresqlFlexibleServerHighAvailability | undefined;
    set internalValue(value: PostgresqlFlexibleServerHighAvailability | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _standbyAvailabilityZone?;
    get standbyAvailabilityZone(): string;
    set standbyAvailabilityZone(value: string);
    resetStandbyAvailabilityZone(): void;
    get standbyAvailabilityZoneInput(): string | undefined;
}
export interface PostgresqlFlexibleServerMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#day_of_week PostgresqlFlexibleServer#day_of_week}
    */
    readonly dayOfWeek?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#start_hour PostgresqlFlexibleServer#start_hour}
    */
    readonly startHour?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#start_minute PostgresqlFlexibleServer#start_minute}
    */
    readonly startMinute?: number;
}
export declare function postgresqlFlexibleServerMaintenanceWindowToTerraform(struct?: PostgresqlFlexibleServerMaintenanceWindowOutputReference | PostgresqlFlexibleServerMaintenanceWindow): any;
export declare class PostgresqlFlexibleServerMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PostgresqlFlexibleServerMaintenanceWindow | undefined;
    set internalValue(value: PostgresqlFlexibleServerMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): number;
    set dayOfWeek(value: number);
    resetDayOfWeek(): void;
    get dayOfWeekInput(): number | undefined;
    private _startHour?;
    get startHour(): number;
    set startHour(value: number);
    resetStartHour(): void;
    get startHourInput(): number | undefined;
    private _startMinute?;
    get startMinute(): number;
    set startMinute(value: number);
    resetStartMinute(): void;
    get startMinuteInput(): number | undefined;
}
export interface PostgresqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#create PostgresqlFlexibleServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#delete PostgresqlFlexibleServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#read PostgresqlFlexibleServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server#update PostgresqlFlexibleServer#update}
    */
    readonly update?: string;
}
export declare function postgresqlFlexibleServerTimeoutsToTerraform(struct?: PostgresqlFlexibleServerTimeoutsOutputReference | PostgresqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class PostgresqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PostgresqlFlexibleServerTimeouts | undefined;
    set internalValue(value: PostgresqlFlexibleServerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server azurerm_postgresql_flexible_server}
*/
export declare class PostgresqlFlexibleServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_postgresql_flexible_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_flexible_server azurerm_postgresql_flexible_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PostgresqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: PostgresqlFlexibleServerConfig);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    resetAdministratorLogin(): void;
    get administratorLoginInput(): string | undefined;
    private _administratorPassword?;
    get administratorPassword(): string;
    set administratorPassword(value: string);
    resetAdministratorPassword(): void;
    get administratorPasswordInput(): string | undefined;
    private _backupRetentionDays?;
    get backupRetentionDays(): number;
    set backupRetentionDays(value: number);
    resetBackupRetentionDays(): void;
    get backupRetentionDaysInput(): number | undefined;
    get cmkEnabled(): string;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    private _delegatedSubnetId?;
    get delegatedSubnetId(): string;
    set delegatedSubnetId(value: string);
    resetDelegatedSubnetId(): void;
    get delegatedSubnetIdInput(): string | undefined;
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    resetGeoRedundantBackupEnabled(): void;
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pointInTimeRestoreTimeInUtc?;
    get pointInTimeRestoreTimeInUtc(): string;
    set pointInTimeRestoreTimeInUtc(value: string);
    resetPointInTimeRestoreTimeInUtc(): void;
    get pointInTimeRestoreTimeInUtcInput(): string | undefined;
    private _privateDnsZoneId?;
    get privateDnsZoneId(): string;
    set privateDnsZoneId(value: string);
    resetPrivateDnsZoneId(): void;
    get privateDnsZoneIdInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _sourceServerId?;
    get sourceServerId(): string;
    set sourceServerId(value: string);
    resetSourceServerId(): void;
    get sourceServerIdInput(): string | undefined;
    private _storageMb?;
    get storageMb(): number;
    set storageMb(value: number);
    resetStorageMb(): void;
    get storageMbInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _highAvailability;
    get highAvailability(): PostgresqlFlexibleServerHighAvailabilityOutputReference;
    putHighAvailability(value: PostgresqlFlexibleServerHighAvailability): void;
    resetHighAvailability(): void;
    get highAvailabilityInput(): PostgresqlFlexibleServerHighAvailability | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): PostgresqlFlexibleServerMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: PostgresqlFlexibleServerMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): PostgresqlFlexibleServerMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): PostgresqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: PostgresqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PostgresqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
