import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SignalrServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#connectivity_logs_enabled SignalrService#connectivity_logs_enabled}
    */
    readonly connectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#live_trace_enabled SignalrService#live_trace_enabled}
    */
    readonly liveTraceEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#location SignalrService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#messaging_logs_enabled SignalrService#messaging_logs_enabled}
    */
    readonly messagingLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#name SignalrService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#resource_group_name SignalrService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#service_mode SignalrService#service_mode}
    */
    readonly serviceMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#tags SignalrService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#cors SignalrService#cors}
    */
    readonly cors?: SignalrServiceCors[] | cdktf.IResolvable;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#features SignalrService#features}
    */
    readonly features?: SignalrServiceFeatures[] | cdktf.IResolvable;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#sku SignalrService#sku}
    */
    readonly sku: SignalrServiceSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#timeouts SignalrService#timeouts}
    */
    readonly timeouts?: SignalrServiceTimeouts;
    /**
    * upstream_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#upstream_endpoint SignalrService#upstream_endpoint}
    */
    readonly upstreamEndpoint?: SignalrServiceUpstreamEndpoint[] | cdktf.IResolvable;
}
export interface SignalrServiceCors {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#allowed_origins SignalrService#allowed_origins}
    */
    readonly allowedOrigins: string[];
}
export declare function signalrServiceCorsToTerraform(struct?: SignalrServiceCors | cdktf.IResolvable): any;
export interface SignalrServiceFeatures {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#flag SignalrService#flag}
    */
    readonly flag: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#value SignalrService#value}
    */
    readonly value: string;
}
export declare function signalrServiceFeaturesToTerraform(struct?: SignalrServiceFeatures | cdktf.IResolvable): any;
export interface SignalrServiceSku {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#capacity SignalrService#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#name SignalrService#name}
    */
    readonly name: string;
}
export declare function signalrServiceSkuToTerraform(struct?: SignalrServiceSkuOutputReference | SignalrServiceSku): any;
export declare class SignalrServiceSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceSku | undefined;
    set internalValue(value: SignalrServiceSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface SignalrServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#create SignalrService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#delete SignalrService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#read SignalrService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#update SignalrService#update}
    */
    readonly update?: string;
}
export declare function signalrServiceTimeoutsToTerraform(struct?: SignalrServiceTimeoutsOutputReference | SignalrServiceTimeouts | cdktf.IResolvable): any;
export declare class SignalrServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceTimeouts | undefined;
    set internalValue(value: SignalrServiceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SignalrServiceUpstreamEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#category_pattern SignalrService#category_pattern}
    */
    readonly categoryPattern: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#event_pattern SignalrService#event_pattern}
    */
    readonly eventPattern: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#hub_pattern SignalrService#hub_pattern}
    */
    readonly hubPattern: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service#url_template SignalrService#url_template}
    */
    readonly urlTemplate: string;
}
export declare function signalrServiceUpstreamEndpointToTerraform(struct?: SignalrServiceUpstreamEndpoint | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service azurerm_signalr_service}
*/
export declare class SignalrService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_signalr_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/signalr_service azurerm_signalr_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SignalrServiceConfig
    */
    constructor(scope: Construct, id: string, config: SignalrServiceConfig);
    private _connectivityLogsEnabled?;
    get connectivityLogsEnabled(): boolean | cdktf.IResolvable;
    set connectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    resetConnectivityLogsEnabled(): void;
    get connectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get hostname(): string;
    get id(): string;
    get ipAddress(): string;
    private _liveTraceEnabled?;
    get liveTraceEnabled(): boolean | cdktf.IResolvable;
    set liveTraceEnabled(value: boolean | cdktf.IResolvable);
    resetLiveTraceEnabled(): void;
    get liveTraceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _messagingLogsEnabled?;
    get messagingLogsEnabled(): boolean | cdktf.IResolvable;
    set messagingLogsEnabled(value: boolean | cdktf.IResolvable);
    resetMessagingLogsEnabled(): void;
    get messagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    get publicPort(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get serverPort(): number;
    private _serviceMode?;
    get serviceMode(): string;
    set serviceMode(value: string);
    resetServiceMode(): void;
    get serviceModeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _cors?;
    get cors(): SignalrServiceCors[] | cdktf.IResolvable;
    set cors(value: SignalrServiceCors[] | cdktf.IResolvable);
    resetCors(): void;
    get corsInput(): cdktf.IResolvable | SignalrServiceCors[] | undefined;
    private _features?;
    get features(): SignalrServiceFeatures[] | cdktf.IResolvable;
    set features(value: SignalrServiceFeatures[] | cdktf.IResolvable);
    resetFeatures(): void;
    get featuresInput(): cdktf.IResolvable | SignalrServiceFeatures[] | undefined;
    private _sku;
    get sku(): SignalrServiceSkuOutputReference;
    putSku(value: SignalrServiceSku): void;
    get skuInput(): SignalrServiceSku | undefined;
    private _timeouts;
    get timeouts(): SignalrServiceTimeoutsOutputReference;
    putTimeouts(value: SignalrServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SignalrServiceTimeouts | undefined;
    private _upstreamEndpoint?;
    get upstreamEndpoint(): SignalrServiceUpstreamEndpoint[] | cdktf.IResolvable;
    set upstreamEndpoint(value: SignalrServiceUpstreamEndpoint[] | cdktf.IResolvable);
    resetUpstreamEndpoint(): void;
    get upstreamEndpointInput(): cdktf.IResolvable | SignalrServiceUpstreamEndpoint[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
