"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageManagementPolicy = exports.StorageManagementPolicyTimeoutsOutputReference = exports.storageManagementPolicyTimeoutsToTerraform = exports.storageManagementPolicyRuleToTerraform = exports.StorageManagementPolicyRuleFiltersOutputReference = exports.storageManagementPolicyRuleFiltersToTerraform = exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = exports.StorageManagementPolicyRuleActionsOutputReference = exports.storageManagementPolicyRuleActionsToTerraform = exports.StorageManagementPolicyRuleActionsVersionOutputReference = exports.storageManagementPolicyRuleActionsVersionToTerraform = exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = exports.storageManagementPolicyRuleActionsSnapshotToTerraform = exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceLastAccessTimeGreaterThan),
        delete_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceModificationGreaterThan),
        tier_to_archive_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan),
        tier_to_archive_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceModificationGreaterThan),
        tier_to_cool_after_days_since_last_access_time_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan),
        tier_to_cool_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceModificationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = storageManagementPolicyRuleActionsBaseBlobToTerraform;
class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deleteAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceLastAccessTimeGreaterThan = this._deleteAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._deleteAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceModificationGreaterThan = this._deleteAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceModificationGreaterThan = this._tierToArchiveAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceModificationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceModificationGreaterThan = this._tierToCoolAfterDaysSinceModificationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deleteAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._deleteAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deleteAfterDaysSinceLastAccessTimeGreaterThan = value.deleteAfterDaysSinceLastAccessTimeGreaterThan;
            this._deleteAfterDaysSinceModificationGreaterThan = value.deleteAfterDaysSinceModificationGreaterThan;
            this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = value.tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = value.tierToArchiveAfterDaysSinceModificationGreaterThan;
            this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = value.tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = value.tierToCoolAfterDaysSinceModificationGreaterThan;
        }
    }
    get deleteAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_last_access_time_greater_than');
    }
    set deleteAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._deleteAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetDeleteAfterDaysSinceLastAccessTimeGreaterThan() {
        this._deleteAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._deleteAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get deleteAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_modification_greater_than');
    }
    set deleteAfterDaysSinceModificationGreaterThan(value) {
        this._deleteAfterDaysSinceModificationGreaterThan = value;
    }
    resetDeleteAfterDaysSinceModificationGreaterThan() {
        this._deleteAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceModificationGreaterThanInput() {
        return this._deleteAfterDaysSinceModificationGreaterThan;
    }
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_last_access_time_greater_than');
    }
    set tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetTierToArchiveAfterDaysSinceLastAccessTimeGreaterThan() {
        this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToArchiveAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get tierToArchiveAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_modification_greater_than');
    }
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = value;
    }
    resetTierToArchiveAfterDaysSinceModificationGreaterThan() {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceModificationGreaterThan;
    }
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_last_access_time_greater_than');
    }
    set tierToCoolAfterDaysSinceLastAccessTimeGreaterThan(value) {
        this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = value;
    }
    resetTierToCoolAfterDaysSinceLastAccessTimeGreaterThan() {
        this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToCoolAfterDaysSinceLastAccessTimeGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceLastAccessTimeGreaterThan;
    }
    get tierToCoolAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_modification_greater_than');
    }
    set tierToCoolAfterDaysSinceModificationGreaterThan(value) {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = value;
    }
    resetTierToCoolAfterDaysSinceModificationGreaterThan() {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tierToCoolAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceModificationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = StorageManagementPolicyRuleActionsBaseBlobOutputReference;
_a = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsBaseBlobOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsBaseBlobOutputReference", version: "0.6.15" };
function storageManagementPolicyRuleActionsSnapshotToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsSnapshotToTerraform = storageManagementPolicyRuleActionsSnapshotToTerraform;
class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreationGreaterThan !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreationGreaterThan = this._deleteAfterDaysSinceCreationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreationGreaterThan = value.deleteAfterDaysSinceCreationGreaterThan;
        }
    }
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    get deleteAfterDaysSinceCreationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_creation_greater_than');
    }
    set deleteAfterDaysSinceCreationGreaterThan(value) {
        this._deleteAfterDaysSinceCreationGreaterThan = value;
    }
    resetDeleteAfterDaysSinceCreationGreaterThan() {
        this._deleteAfterDaysSinceCreationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceCreationGreaterThanInput() {
        return this._deleteAfterDaysSinceCreationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = StorageManagementPolicyRuleActionsSnapshotOutputReference;
_b = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsSnapshotOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsSnapshotOutputReference", version: "0.6.15" };
function storageManagementPolicyRuleActionsVersionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreation),
    };
}
exports.storageManagementPolicyRuleActionsVersionToTerraform = storageManagementPolicyRuleActionsVersionToTerraform;
class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreation !== undefined) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreation = this._deleteAfterDaysSinceCreation;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreation = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreation = value.deleteAfterDaysSinceCreation;
        }
    }
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    get deleteAfterDaysSinceCreation() {
        return this.getNumberAttribute('delete_after_days_since_creation');
    }
    set deleteAfterDaysSinceCreation(value) {
        this._deleteAfterDaysSinceCreation = value;
    }
    resetDeleteAfterDaysSinceCreation() {
        this._deleteAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteAfterDaysSinceCreationInput() {
        return this._deleteAfterDaysSinceCreation;
    }
}
exports.StorageManagementPolicyRuleActionsVersionOutputReference = StorageManagementPolicyRuleActionsVersionOutputReference;
_c = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsVersionOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsVersionOutputReference", version: "0.6.15" };
function storageManagementPolicyRuleActionsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        base_blob: storageManagementPolicyRuleActionsBaseBlobToTerraform(struct.baseBlob),
        snapshot: storageManagementPolicyRuleActionsSnapshotToTerraform(struct.snapshot),
        version: storageManagementPolicyRuleActionsVersionToTerraform(struct.version),
    };
}
exports.storageManagementPolicyRuleActionsToTerraform = storageManagementPolicyRuleActionsToTerraform;
class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // base_blob - computed: false, optional: true, required: false
        this._baseBlob = new StorageManagementPolicyRuleActionsBaseBlobOutputReference(this, "base_blob");
        // snapshot - computed: false, optional: true, required: false
        this._snapshot = new StorageManagementPolicyRuleActionsSnapshotOutputReference(this, "snapshot");
        // version - computed: false, optional: true, required: false
        this._version = new StorageManagementPolicyRuleActionsVersionOutputReference(this, "version");
    }
    get internalValue() {
        var _h, _j, _k, _l, _m, _o;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (((_h = this._baseBlob) === null || _h === void 0 ? void 0 : _h.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.baseBlob = (_j = this._baseBlob) === null || _j === void 0 ? void 0 : _j.internalValue;
        }
        if (((_k = this._snapshot) === null || _k === void 0 ? void 0 : _k.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.snapshot = (_l = this._snapshot) === null || _l === void 0 ? void 0 : _l.internalValue;
        }
        if (((_m = this._version) === null || _m === void 0 ? void 0 : _m.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.version = (_o = this._version) === null || _o === void 0 ? void 0 : _o.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._baseBlob.internalValue = undefined;
            this._snapshot.internalValue = undefined;
            this._version.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._baseBlob.internalValue = value.baseBlob;
            this._snapshot.internalValue = value.snapshot;
            this._version.internalValue = value.version;
        }
    }
    get baseBlob() {
        return this._baseBlob;
    }
    putBaseBlob(value) {
        this._baseBlob.internalValue = value;
    }
    resetBaseBlob() {
        this._baseBlob.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baseBlobInput() {
        return this._baseBlob.internalValue;
    }
    get snapshot() {
        return this._snapshot;
    }
    putSnapshot(value) {
        this._snapshot.internalValue = value;
    }
    resetSnapshot() {
        this._snapshot.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get snapshotInput() {
        return this._snapshot.internalValue;
    }
    get version() {
        return this._version;
    }
    putVersion(value) {
        this._version.internalValue = value;
    }
    resetVersion() {
        this._version.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version.internalValue;
    }
}
exports.StorageManagementPolicyRuleActionsOutputReference = StorageManagementPolicyRuleActionsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsOutputReference", version: "0.6.15" };
function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        operation: cdktf.stringToTerraform(struct.operation),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform;
function storageManagementPolicyRuleFiltersToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        blob_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.blobTypes),
        prefix_match: cdktf.listMapper(cdktf.stringToTerraform)(struct.prefixMatch),
        match_blob_index_tag: cdktf.listMapper(storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform)(struct.matchBlobIndexTag),
    };
}
exports.storageManagementPolicyRuleFiltersToTerraform = storageManagementPolicyRuleFiltersToTerraform;
class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._blobTypes !== undefined) {
            hasAnyValues = true;
            internalValueResult.blobTypes = this._blobTypes;
        }
        if (this._prefixMatch !== undefined) {
            hasAnyValues = true;
            internalValueResult.prefixMatch = this._prefixMatch;
        }
        if (this._matchBlobIndexTag !== undefined) {
            hasAnyValues = true;
            internalValueResult.matchBlobIndexTag = this._matchBlobIndexTag;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._blobTypes = undefined;
            this._prefixMatch = undefined;
            this._matchBlobIndexTag = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._blobTypes = value.blobTypes;
            this._prefixMatch = value.prefixMatch;
            this._matchBlobIndexTag = value.matchBlobIndexTag;
        }
    }
    get blobTypes() {
        return cdktf.Fn.tolist(this.getListAttribute('blob_types'));
    }
    set blobTypes(value) {
        this._blobTypes = value;
    }
    resetBlobTypes() {
        this._blobTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get blobTypesInput() {
        return this._blobTypes;
    }
    get prefixMatch() {
        return cdktf.Fn.tolist(this.getListAttribute('prefix_match'));
    }
    set prefixMatch(value) {
        this._prefixMatch = value;
    }
    resetPrefixMatch() {
        this._prefixMatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get prefixMatchInput() {
        return this._prefixMatch;
    }
    get matchBlobIndexTag() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('match_blob_index_tag')));
    }
    set matchBlobIndexTag(value) {
        this._matchBlobIndexTag = value;
    }
    resetMatchBlobIndexTag() {
        this._matchBlobIndexTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get matchBlobIndexTagInput() {
        return this._matchBlobIndexTag;
    }
}
exports.StorageManagementPolicyRuleFiltersOutputReference = StorageManagementPolicyRuleFiltersOutputReference;
_e = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersOutputReference", version: "0.6.15" };
function storageManagementPolicyRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enabled: cdktf.booleanToTerraform(struct.enabled),
        name: cdktf.stringToTerraform(struct.name),
        actions: storageManagementPolicyRuleActionsToTerraform(struct.actions),
        filters: storageManagementPolicyRuleFiltersToTerraform(struct.filters),
    };
}
exports.storageManagementPolicyRuleToTerraform = storageManagementPolicyRuleToTerraform;
function storageManagementPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.storageManagementPolicyTimeoutsToTerraform = storageManagementPolicyTimeoutsToTerraform;
class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.StorageManagementPolicyTimeoutsOutputReference = StorageManagementPolicyTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyTimeoutsOutputReference", version: "0.6.15" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy}
*/
class StorageManagementPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy azurerm_storage_management_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageManagementPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_storage_management_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '2.99.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new StorageManagementPolicyTimeoutsOutputReference(this, "timeouts");
        this._storageAccountId = config.storageAccountId;
        this._rule = config.rule;
        this._timeouts.internalValue = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get storageAccountId() {
        return this.getStringAttribute('storage_account_id');
    }
    set storageAccountId(value) {
        this._storageAccountId = value;
    }
    // Temporarily expose input value. Use with caution.
    get storageAccountIdInput() {
        return this._storageAccountId;
    }
    get rule() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('rule');
    }
    set rule(value) {
        this._rule = value;
    }
    resetRule() {
        this._rule = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ruleInput() {
        return this._rule;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            storage_account_id: cdktf.stringToTerraform(this._storageAccountId),
            rule: cdktf.listMapper(storageManagementPolicyRuleToTerraform)(this._rule),
            timeouts: storageManagementPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.StorageManagementPolicy = StorageManagementPolicy;
_g = JSII_RTTI_SYMBOL_1;
StorageManagementPolicy[_g] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicy", version: "0.6.15" };
// =================
// STATIC PROPERTIES
// =================
StorageManagementPolicy.tfResourceType = "azurerm_storage_management_policy";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcmFnZS1tYW5hZ2VtZW50LXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zdG9yYWdlLW1hbmFnZW1lbnQtcG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBaUQvQixTQUFnQixxREFBcUQsQ0FBQyxNQUErRztJQUNuTCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLHFEQUFxRCxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsNkNBQTZDLENBQUM7UUFDckksaURBQWlELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQywyQ0FBMkMsQ0FBQztRQUMvSCw4REFBOEQsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLG9EQUFvRCxDQUFDO1FBQ3JKLDBEQUEwRCxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsa0RBQWtELENBQUM7UUFDL0ksMkRBQTJELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxpREFBaUQsQ0FBQztRQUMvSSx1REFBdUQsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLCtDQUErQyxDQUFDO0tBQzFJLENBQUE7QUFDSCxDQUFDO0FBYkQsc0hBYUM7QUFFRCxNQUFhLHlEQUEwRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR2hHOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyw4Q0FBOEMsS0FBSyxTQUFTLEVBQUU7WUFDckUsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyw2Q0FBNkMsR0FBRyxJQUFJLENBQUMsOENBQThDLENBQUM7U0FDekg7UUFDRCxJQUFJLElBQUksQ0FBQyw0Q0FBNEMsS0FBSyxTQUFTLEVBQUU7WUFDbkUsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywyQ0FBMkMsR0FBRyxJQUFJLENBQUMsNENBQTRDLENBQUM7U0FDckg7UUFDRCxJQUFJLElBQUksQ0FBQyxxREFBcUQsS0FBSyxTQUFTLEVBQUU7WUFDNUUsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxvREFBb0QsR0FBRyxJQUFJLENBQUMscURBQXFELENBQUM7U0FDdkk7UUFDRCxJQUFJLElBQUksQ0FBQyxtREFBbUQsS0FBSyxTQUFTLEVBQUU7WUFDMUUsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxrREFBa0QsR0FBRyxJQUFJLENBQUMsbURBQW1ELENBQUM7U0FDbkk7UUFDRCxJQUFJLElBQUksQ0FBQyxrREFBa0QsS0FBSyxTQUFTLEVBQUU7WUFDekUsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpREFBaUQsR0FBRyxJQUFJLENBQUMsa0RBQWtELENBQUM7U0FDakk7UUFDRCxJQUFJLElBQUksQ0FBQyxnREFBZ0QsS0FBSyxTQUFTLEVBQUU7WUFDdkUsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywrQ0FBK0MsR0FBRyxJQUFJLENBQUMsZ0RBQWdELENBQUM7U0FDN0g7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBNkQ7UUFDcEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyw4Q0FBOEMsR0FBRyxTQUFTLENBQUM7WUFDaEUsSUFBSSxDQUFDLDRDQUE0QyxHQUFHLFNBQVMsQ0FBQztZQUM5RCxJQUFJLENBQUMscURBQXFELEdBQUcsU0FBUyxDQUFDO1lBQ3ZFLElBQUksQ0FBQyxtREFBbUQsR0FBRyxTQUFTLENBQUM7WUFDckUsSUFBSSxDQUFDLGtEQUFrRCxHQUFHLFNBQVMsQ0FBQztZQUNwRSxJQUFJLENBQUMsZ0RBQWdELEdBQUcsU0FBUyxDQUFDO1NBQ25FO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsOENBQThDLEdBQUcsS0FBSyxDQUFDLDZDQUE2QyxDQUFDO1lBQzFHLElBQUksQ0FBQyw0Q0FBNEMsR0FBRyxLQUFLLENBQUMsMkNBQTJDLENBQUM7WUFDdEcsSUFBSSxDQUFDLHFEQUFxRCxHQUFHLEtBQUssQ0FBQyxvREFBb0QsQ0FBQztZQUN4SCxJQUFJLENBQUMsbURBQW1ELEdBQUcsS0FBSyxDQUFDLGtEQUFrRCxDQUFDO1lBQ3BILElBQUksQ0FBQyxrREFBa0QsR0FBRyxLQUFLLENBQUMsaURBQWlELENBQUM7WUFDbEgsSUFBSSxDQUFDLGdEQUFnRCxHQUFHLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQztTQUMvRztJQUNILENBQUM7SUFJRCxJQUFXLDZDQUE2QztRQUN0RCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx1REFBdUQsQ0FBQyxDQUFDO0lBQzFGLENBQUM7SUFDRCxJQUFXLDZDQUE2QyxDQUFDLEtBQWE7UUFDcEUsSUFBSSxDQUFDLDhDQUE4QyxHQUFHLEtBQUssQ0FBQztJQUM5RCxDQUFDO0lBQ00sa0RBQWtEO1FBQ3ZELElBQUksQ0FBQyw4Q0FBOEMsR0FBRyxTQUFTLENBQUM7SUFDbEUsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGtEQUFrRDtRQUMzRCxPQUFPLElBQUksQ0FBQyw4Q0FBOEMsQ0FBQztJQUM3RCxDQUFDO0lBSUQsSUFBVywyQ0FBMkM7UUFDcEQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbURBQW1ELENBQUMsQ0FBQztJQUN0RixDQUFDO0lBQ0QsSUFBVywyQ0FBMkMsQ0FBQyxLQUFhO1FBQ2xFLElBQUksQ0FBQyw0Q0FBNEMsR0FBRyxLQUFLLENBQUM7SUFDNUQsQ0FBQztJQUNNLGdEQUFnRDtRQUNyRCxJQUFJLENBQUMsNENBQTRDLEdBQUcsU0FBUyxDQUFDO0lBQ2hFLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnREFBZ0Q7UUFDekQsT0FBTyxJQUFJLENBQUMsNENBQTRDLENBQUM7SUFDM0QsQ0FBQztJQUlELElBQVcsb0RBQW9EO1FBQzdELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdFQUFnRSxDQUFDLENBQUM7SUFDbkcsQ0FBQztJQUNELElBQVcsb0RBQW9ELENBQUMsS0FBYTtRQUMzRSxJQUFJLENBQUMscURBQXFELEdBQUcsS0FBSyxDQUFDO0lBQ3JFLENBQUM7SUFDTSx5REFBeUQ7UUFDOUQsSUFBSSxDQUFDLHFEQUFxRCxHQUFHLFNBQVMsQ0FBQztJQUN6RSxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseURBQXlEO1FBQ2xFLE9BQU8sSUFBSSxDQUFDLHFEQUFxRCxDQUFDO0lBQ3BFLENBQUM7SUFJRCxJQUFXLGtEQUFrRDtRQUMzRCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyw0REFBNEQsQ0FBQyxDQUFDO0lBQy9GLENBQUM7SUFDRCxJQUFXLGtEQUFrRCxDQUFDLEtBQWE7UUFDekUsSUFBSSxDQUFDLG1EQUFtRCxHQUFHLEtBQUssQ0FBQztJQUNuRSxDQUFDO0lBQ00sdURBQXVEO1FBQzVELElBQUksQ0FBQyxtREFBbUQsR0FBRyxTQUFTLENBQUM7SUFDdkUsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVEQUF1RDtRQUNoRSxPQUFPLElBQUksQ0FBQyxtREFBbUQsQ0FBQztJQUNsRSxDQUFDO0lBSUQsSUFBVyxpREFBaUQ7UUFDMUQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsNkRBQTZELENBQUMsQ0FBQztJQUNoRyxDQUFDO0lBQ0QsSUFBVyxpREFBaUQsQ0FBQyxLQUFhO1FBQ3hFLElBQUksQ0FBQyxrREFBa0QsR0FBRyxLQUFLLENBQUM7SUFDbEUsQ0FBQztJQUNNLHNEQUFzRDtRQUMzRCxJQUFJLENBQUMsa0RBQWtELEdBQUcsU0FBUyxDQUFDO0lBQ3RFLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzREFBc0Q7UUFDL0QsT0FBTyxJQUFJLENBQUMsa0RBQWtELENBQUM7SUFDakUsQ0FBQztJQUlELElBQVcsK0NBQStDO1FBQ3hELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHlEQUF5RCxDQUFDLENBQUM7SUFDNUYsQ0FBQztJQUNELElBQVcsK0NBQStDLENBQUMsS0FBYTtRQUN0RSxJQUFJLENBQUMsZ0RBQWdELEdBQUcsS0FBSyxDQUFDO0lBQ2hFLENBQUM7SUFDTSxvREFBb0Q7UUFDekQsSUFBSSxDQUFDLGdEQUFnRCxHQUFHLFNBQVMsQ0FBQztJQUNwRSxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0RBQW9EO1FBQzdELE9BQU8sSUFBSSxDQUFDLGdEQUFnRCxDQUFDO0lBQy9ELENBQUM7O0FBNUpILDhIQTZKQzs7O0FBZ0JELFNBQWdCLHFEQUFxRCxDQUFDLE1BQStHO0lBQ25MLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsZ0RBQWdELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyx5Q0FBeUMsQ0FBQztRQUM1SCw2Q0FBNkMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHNDQUFzQyxDQUFDO1FBQ3RILDZDQUE2QyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsdUNBQXVDLENBQUM7S0FDeEgsQ0FBQTtBQUNILENBQUM7QUFWRCxzSEFVQztBQUVELE1BQWEseURBQTBELFNBQVEsS0FBSyxDQUFDLGFBQWE7SUFHaEc7OztNQUdFO0lBQ0YsWUFBbUIsaUJBQTZDLEVBQUUsa0JBQTBCO1FBQzFGLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFQakQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFROUIsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLDBDQUEwQyxLQUFLLFNBQVMsRUFBRTtZQUNqRSxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHlDQUF5QyxHQUFHLElBQUksQ0FBQywwQ0FBMEMsQ0FBQztTQUNqSDtRQUNELElBQUksSUFBSSxDQUFDLHVDQUF1QyxLQUFLLFNBQVMsRUFBRTtZQUM5RCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHNDQUFzQyxHQUFHLElBQUksQ0FBQyx1Q0FBdUMsQ0FBQztTQUMzRztRQUNELElBQUksSUFBSSxDQUFDLHdDQUF3QyxLQUFLLFNBQVMsRUFBRTtZQUMvRCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHVDQUF1QyxHQUFHLElBQUksQ0FBQyx3Q0FBd0MsQ0FBQztTQUM3RztRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE2RDtRQUNwRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLFNBQVMsQ0FBQztZQUM1RCxJQUFJLENBQUMsdUNBQXVDLEdBQUcsU0FBUyxDQUFDO1lBQ3pELElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxTQUFTLENBQUM7U0FDM0Q7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQywwQ0FBMEMsR0FBRyxLQUFLLENBQUMseUNBQXlDLENBQUM7WUFDbEcsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLEtBQUssQ0FBQyxzQ0FBc0MsQ0FBQztZQUM1RixJQUFJLENBQUMsd0NBQXdDLEdBQUcsS0FBSyxDQUFDLHVDQUF1QyxDQUFDO1NBQy9GO0lBQ0gsQ0FBQztJQUlELElBQVcseUNBQXlDO1FBQ2xELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtEQUFrRCxDQUFDLENBQUM7SUFDckYsQ0FBQztJQUNELElBQVcseUNBQXlDLENBQUMsS0FBYTtRQUNoRSxJQUFJLENBQUMsMENBQTBDLEdBQUcsS0FBSyxDQUFDO0lBQzFELENBQUM7SUFDTSw4Q0FBOEM7UUFDbkQsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLFNBQVMsQ0FBQztJQUM5RCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOENBQThDO1FBQ3ZELE9BQU8sSUFBSSxDQUFDLDBDQUEwQyxDQUFDO0lBQ3pELENBQUM7SUFJRCxJQUFXLHNDQUFzQztRQUMvQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO0lBQ2xGLENBQUM7SUFDRCxJQUFXLHNDQUFzQyxDQUFDLEtBQWE7UUFDN0QsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLEtBQUssQ0FBQztJQUN2RCxDQUFDO0lBQ00sMkNBQTJDO1FBQ2hELElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxTQUFTLENBQUM7SUFDM0QsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDJDQUEyQztRQUNwRCxPQUFPLElBQUksQ0FBQyx1Q0FBdUMsQ0FBQztJQUN0RCxDQUFDO0lBSUQsSUFBVyx1Q0FBdUM7UUFDaEQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsK0NBQStDLENBQUMsQ0FBQztJQUNsRixDQUFDO0lBQ0QsSUFBVyx1Q0FBdUMsQ0FBQyxLQUFhO1FBQzlELElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxLQUFLLENBQUM7SUFDeEQsQ0FBQztJQUNNLDRDQUE0QztRQUNqRCxJQUFJLENBQUMsd0NBQXdDLEdBQUcsU0FBUyxDQUFDO0lBQzVELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw0Q0FBNEM7UUFDckQsT0FBTyxJQUFJLENBQUMsd0NBQXdDLENBQUM7SUFDdkQsQ0FBQzs7QUExRkgsOEhBMkZDOzs7QUFnQkQsU0FBZ0Isb0RBQW9ELENBQUMsTUFBNkc7SUFDaEwsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQzVGLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxnREFBZ0QsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHlDQUF5QyxDQUFDO1FBQzVILDZDQUE2QyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsc0NBQXNDLENBQUM7UUFDdEgsZ0NBQWdDLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyw0QkFBNEIsQ0FBQztLQUNoRyxDQUFBO0FBQ0gsQ0FBQztBQVZELG9IQVVDO0FBRUQsTUFBYSx3REFBeUQsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUcvRjs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsMENBQTBDLEtBQUssU0FBUyxFQUFFO1lBQ2pFLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMseUNBQXlDLEdBQUcsSUFBSSxDQUFDLDBDQUEwQyxDQUFDO1NBQ2pIO1FBQ0QsSUFBSSxJQUFJLENBQUMsdUNBQXVDLEtBQUssU0FBUyxFQUFFO1lBQzlELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsc0NBQXNDLEdBQUcsSUFBSSxDQUFDLHVDQUF1QyxDQUFDO1NBQzNHO1FBQ0QsSUFBSSxJQUFJLENBQUMsNkJBQTZCLEtBQUssU0FBUyxFQUFFO1lBQ3BELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsNEJBQTRCLEdBQUcsSUFBSSxDQUFDLDZCQUE2QixDQUFDO1NBQ3ZGO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTREO1FBQ25GLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsMENBQTBDLEdBQUcsU0FBUyxDQUFDO1lBQzVELElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxTQUFTLENBQUM7WUFDekQsSUFBSSxDQUFDLDZCQUE2QixHQUFHLFNBQVMsQ0FBQztTQUNoRDthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLEtBQUssQ0FBQyx5Q0FBeUMsQ0FBQztZQUNsRyxJQUFJLENBQUMsdUNBQXVDLEdBQUcsS0FBSyxDQUFDLHNDQUFzQyxDQUFDO1lBQzVGLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUMsNEJBQTRCLENBQUM7U0FDekU7SUFDSCxDQUFDO0lBSUQsSUFBVyx5Q0FBeUM7UUFDbEQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0RBQWtELENBQUMsQ0FBQztJQUNyRixDQUFDO0lBQ0QsSUFBVyx5Q0FBeUMsQ0FBQyxLQUFhO1FBQ2hFLElBQUksQ0FBQywwQ0FBMEMsR0FBRyxLQUFLLENBQUM7SUFDMUQsQ0FBQztJQUNNLDhDQUE4QztRQUNuRCxJQUFJLENBQUMsMENBQTBDLEdBQUcsU0FBUyxDQUFDO0lBQzlELENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw4Q0FBOEM7UUFDdkQsT0FBTyxJQUFJLENBQUMsMENBQTBDLENBQUM7SUFDekQsQ0FBQztJQUlELElBQVcsc0NBQXNDO1FBQy9DLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLCtDQUErQyxDQUFDLENBQUM7SUFDbEYsQ0FBQztJQUNELElBQVcsc0NBQXNDLENBQUMsS0FBYTtRQUM3RCxJQUFJLENBQUMsdUNBQXVDLEdBQUcsS0FBSyxDQUFDO0lBQ3ZELENBQUM7SUFDTSwyQ0FBMkM7UUFDaEQsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLFNBQVMsQ0FBQztJQUMzRCxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsMkNBQTJDO1FBQ3BELE9BQU8sSUFBSSxDQUFDLHVDQUF1QyxDQUFDO0lBQ3RELENBQUM7SUFJRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrQ0FBa0MsQ0FBQyxDQUFDO0lBQ3JFLENBQUM7SUFDRCxJQUFXLDRCQUE0QixDQUFDLEtBQWE7UUFDbkQsSUFBSSxDQUFDLDZCQUE2QixHQUFHLEtBQUssQ0FBQztJQUM3QyxDQUFDO0lBQ00saUNBQWlDO1FBQ3RDLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxTQUFTLENBQUM7SUFDakQsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlDQUFpQztRQUMxQyxPQUFPLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztJQUM1QyxDQUFDOztBQTFGSCw0SEEyRkM7OztBQXNCRCxTQUFnQiw2Q0FBNkMsQ0FBQyxNQUErRjtJQUMzSixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFNBQVMsRUFBRSxxREFBcUQsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2xGLFFBQVEsRUFBRSxxREFBcUQsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2pGLE9BQU8sRUFBRSxvREFBb0QsQ0FBQyxNQUFPLENBQUMsT0FBTyxDQUFDO0tBQy9FLENBQUE7QUFDSCxDQUFDO0FBVkQsc0dBVUM7QUFFRCxNQUFhLGlEQUFrRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3hGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO1FBMkM5QiwrREFBK0Q7UUFDdkQsY0FBUyxHQUFHLElBQUkseURBQXlELENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBZXJHLDhEQUE4RDtRQUN0RCxjQUFTLEdBQUcsSUFBSSx5REFBeUQsQ0FBQyxJQUFJLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFlcEcsNkRBQTZEO1FBQ3JELGFBQVEsR0FBRyxJQUFJLHdEQUF3RCxDQUFDLElBQUksRUFBRSxTQUFTLENBQUMsQ0FBQztJQXBFakcsQ0FBQztJQUVELElBQVcsYUFBYTs7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLE9BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsYUFBYSxNQUFLLFNBQVMsRUFBRTtZQUMvQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsU0FBRyxJQUFJLENBQUMsU0FBUywwQ0FBRSxhQUFhLENBQUM7U0FDOUQ7UUFDRCxJQUFJLE9BQUEsSUFBSSxDQUFDLFNBQVMsMENBQUUsYUFBYSxNQUFLLFNBQVMsRUFBRTtZQUMvQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFFBQVEsU0FBRyxJQUFJLENBQUMsU0FBUywwQ0FBRSxhQUFhLENBQUM7U0FDOUQ7UUFDRCxJQUFJLE9BQUEsSUFBSSxDQUFDLFFBQVEsMENBQUUsYUFBYSxNQUFLLFNBQVMsRUFBRTtZQUM5QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE9BQU8sU0FBRyxJQUFJLENBQUMsUUFBUSwwQ0FBRSxhQUFhLENBQUM7U0FDNUQ7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBcUQ7UUFDNUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztZQUN6QyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7WUFDekMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO1NBQ3pDO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQzlDLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFDOUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztTQUM3QztJQUNILENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxXQUFXLENBQUMsS0FBaUQ7UUFDbEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMzQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO0lBQ3RDLENBQUM7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxXQUFXLENBQUMsS0FBaUQ7UUFDbEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMzQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO0lBQ3RDLENBQUM7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxVQUFVLENBQUMsS0FBZ0Q7UUFDaEUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDO0lBQ3JDLENBQUM7O0FBMUZILDhHQTJGQzs7O0FBZ0JELFNBQWdCLDhEQUE4RCxDQUFDLE1BQWdGO0lBQzdKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFNBQVMsQ0FBQztRQUNyRCxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxLQUFLLENBQUM7S0FDOUMsQ0FBQTtBQUNILENBQUM7QUFWRCx3SUFVQztBQW1CRCxTQUFnQiw2Q0FBNkMsQ0FBQyxNQUErRjtJQUMzSixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLE1BQU8sQ0FBQyxTQUFTLENBQUM7UUFDeEUsWUFBWSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsTUFBTyxDQUFDLFdBQVcsQ0FBQztRQUM1RSxvQkFBb0IsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLDhEQUE4RCxDQUFDLENBQUMsTUFBTyxDQUFDLGlCQUFpQixDQUFDO0tBQ2xJLENBQUE7QUFDSCxDQUFDO0FBVkQsc0dBVUM7QUFFRCxNQUFhLGlEQUFrRCxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3hGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxVQUFVLEtBQUssU0FBUyxFQUFFO1lBQ2pDLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7U0FDakQ7UUFDRCxJQUFJLElBQUksQ0FBQyxZQUFZLEtBQUssU0FBUyxFQUFFO1lBQ25DLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDckQ7UUFDRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsS0FBSyxTQUFTLEVBQUU7WUFDekMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBcUQ7UUFDNUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDO1lBQzVCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO1lBQzlCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7U0FDckM7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztZQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7WUFDdEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztTQUNuRDtJQUNILENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxLQUFLLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBZTtRQUNsQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFlO1FBQ3BDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsaUJBQWlCO1FBQzFCLG9EQUFvRDtRQUNwRCxPQUFPLEtBQUssQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNwRyxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFnRjtRQUMzRyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFDTSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztJQUN0QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7O0FBM0ZILDhHQTRGQzs7O0FBd0JELFNBQWdCLHNDQUFzQyxDQUFDLE1BQXdEO0lBQzdHLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsT0FBTyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsT0FBTyxDQUFDO1FBQ2xELElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLElBQUksQ0FBQztRQUMzQyxPQUFPLEVBQUUsNkNBQTZDLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztRQUN2RSxPQUFPLEVBQUUsNkNBQTZDLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztLQUN4RSxDQUFBO0FBQ0gsQ0FBQztBQVhELHdGQVdDO0FBcUJELFNBQWdCLDBDQUEwQyxDQUFDLE1BQTZHO0lBQ3RLLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUM1RixJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztRQUMvQyxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO0tBQ2hELENBQUE7QUFDSCxDQUFDO0FBWEQsZ0dBV0M7QUFFRCxNQUFhLDhDQUErQyxTQUFRLEtBQUssQ0FBQyxhQUFhO0lBR3JGOzs7TUFHRTtJQUNGLFlBQW1CLGlCQUE2QyxFQUFFLGtCQUEwQjtRQUMxRixLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBUGpELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBUTlCLENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxPQUFPLEtBQUssU0FBUyxFQUFFO1lBQzlCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7U0FDM0M7UUFDRCxJQUFJLElBQUksQ0FBQyxPQUFPLEtBQUssU0FBUyxFQUFFO1lBQzlCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7U0FDM0M7UUFDRCxJQUFJLElBQUksQ0FBQyxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQzVCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUM7U0FDdkM7UUFDRCxJQUFJLElBQUksQ0FBQyxPQUFPLEtBQUssU0FBUyxFQUFFO1lBQzlCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7U0FDM0M7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDO0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBa0Q7UUFDekUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO1lBQ3pCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO1lBQ3pCLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO1NBQzFCO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7WUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUN4QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7U0FDN0I7SUFDSCxDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFDTSxTQUFTO1FBQ2QsSUFBSSxDQUFDLEtBQUssR0FBRyxTQUFTLENBQUM7SUFDekIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLE1BQU07UUFDZixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQztJQUN2QixDQUFDO0lBQ00sV0FBVztRQUNoQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztJQUMzQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUM7SUFDdEIsQ0FBQzs7QUFoSEgsd0dBaUhDOzs7QUFFRDs7RUFFRTtBQUNGLE1BQWEsdUJBQXdCLFNBQVEsS0FBSyxDQUFDLGlCQUFpQjtJQU9sRSxjQUFjO0lBQ2QsY0FBYztJQUNkLGNBQWM7SUFFZDs7Ozs7O01BTUU7SUFDRixZQUFtQixLQUFnQixFQUFFLEVBQVUsRUFBRSxNQUFxQztRQUNwRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLHFCQUFxQixFQUFFLG1DQUFtQztZQUMxRCwwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLFNBQVM7Z0JBQ3ZCLGVBQWUsRUFBRSxRQUFRO2dCQUN6Qix5QkFBeUIsRUFBRSxRQUFRO2FBQ3BDO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQTZDTCw4REFBOEQ7UUFDdEQsY0FBUyxHQUFHLElBQUksOENBQThDLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBN0N2RixJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO0lBQ2pELENBQUM7SUFFRCxhQUFhO0lBQ2IsYUFBYTtJQUNiLGFBQWE7SUFFYix1REFBdUQ7SUFDdkQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLG9EQUFvRDtRQUNwRCxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBd0Q7UUFDdEUsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUNNLFdBQVcsQ0FBQyxLQUFzQztRQUN2RCxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDdkMsQ0FBQztJQUNNLGFBQWE7UUFDbEIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQzNDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7SUFDdEMsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztZQUNuRSxJQUFJLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxzQ0FBc0MsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDMUUsUUFBUSxFQUFFLDBDQUEwQyxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO1NBQ25GLENBQUM7SUFDSixDQUFDOztBQXJHSCwwREFzR0M7OztBQXBHQyxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNHLHNDQUFjLEdBQUcsbUNBQW1DLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3lcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeUNvbmZpZyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybU1ldGFBcmd1bWVudHMge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNzdG9yYWdlX2FjY291bnRfaWQgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjc3RvcmFnZV9hY2NvdW50X2lkfVxuICAqL1xuICByZWFkb25seSBzdG9yYWdlQWNjb3VudElkOiBzdHJpbmc7XG4gIC8qKlxuICAqIHJ1bGUgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNydWxlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I3J1bGV9XG4gICovXG4gIHJlYWRvbmx5IHJ1bGU/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVbXSB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiB0aW1lb3V0cyBibG9ja1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I3RpbWVvdXRzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I3RpbWVvdXRzfVxuICAqL1xuICByZWFkb25seSB0aW1lb3V0cz86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHM7XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNCYXNlQmxvYiB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFuIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFufVxuICAqL1xuICByZWFkb25seSBkZWxldGVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbn1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbj86IG51bWJlcjtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfbGFzdF9hY2Nlc3NfdGltZV9ncmVhdGVyX3RoYW4gU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfbGFzdF9hY2Nlc3NfdGltZV9ncmVhdGVyX3RoYW59XG4gICovXG4gIHJlYWRvbmx5IHRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbn1cbiAgKi9cbiAgcmVhZG9ubHkgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFuIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFufVxuICAqL1xuICByZWFkb25seSB0aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuPzogbnVtYmVyO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSN0aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW59XG4gICovXG4gIHJlYWRvbmx5IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuPzogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iT3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiksXG4gICAgZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKSxcbiAgICB0aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9sYXN0X2FjY2Vzc190aW1lX2dyZWF0ZXJfdGhhbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS50aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuKSxcbiAgICB0aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLnRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKSxcbiAgICB0aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9sYXN0X2FjY2Vzc190aW1lX2dyZWF0ZXJfdGhhbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS50aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuKSxcbiAgICB0aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLnRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2IgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kZWxldGVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4gPSB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW47XG4gICAgfVxuICAgIGlmICh0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC50aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuID0gdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gICAgfVxuICAgIGlmICh0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4gPSB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNCYXNlQmxvYiB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHZhbHVlLmRlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbjtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZS5kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHZhbHVlLnRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW47XG4gICAgICB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlLnRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgICAgdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHZhbHVlLnRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW47XG4gICAgICB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlLnRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgfVxuXG4gIC8vIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfbGFzdF9hY2Nlc3NfdGltZV9ncmVhdGVyX3RoYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVsZXRlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuKCkge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbjtcbiAgfVxuXG4gIC8vIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgfVxuXG4gIC8vIHRpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2xhc3RfYWNjZXNzX3RpbWVfZ3JlYXRlcl90aGFuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9sYXN0X2FjY2Vzc190aW1lX2dyZWF0ZXJfdGhhbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4oKSB7XG4gICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuO1xuICB9XG5cbiAgLy8gdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuJyk7XG4gIH1cbiAgcHVibGljIHNldCB0aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gIH1cblxuICAvLyB0aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9sYXN0X2FjY2Vzc190aW1lX2dyZWF0ZXJfdGhhbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCB0aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfbGFzdF9hY2Nlc3NfdGltZV9ncmVhdGVyX3RoYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3RpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VMYXN0QWNjZXNzVGltZUdyZWF0ZXJUaGFuKCkge1xuICAgIHRoaXMuX3RpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUxhc3RBY2Nlc3NUaW1lR3JlYXRlclRoYW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTGFzdEFjY2Vzc1RpbWVHcmVhdGVyVGhhbjtcbiAgfVxuXG4gIC8vIHRpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3RpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdCB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I2NoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb259XG4gICovXG4gIHJlYWRvbmx5IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24gU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjY2hhbmdlX3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9ufVxuICAqL1xuICByZWFkb25seSBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb25fZ3JlYXRlcl90aGFuIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uX2dyZWF0ZXJfdGhhbn1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuPzogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90VG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90T3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGNoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiksXG4gICAgY2hhbmdlX3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKSxcbiAgICBkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbl9ncmVhdGVyX3RoYW46IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90T3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3QgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgfVxuICAgIGlmICh0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbiA9IHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbjtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdCB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdmFsdWUuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlLmNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWUuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxuXG4gIC8vIGNoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxuXG4gIC8vIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uX2dyZWF0ZXJfdGhhbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uX2dyZWF0ZXJfdGhhbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uIHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjY2hhbmdlX3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2NoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I2NoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb259XG4gICovXG4gIHJlYWRvbmx5IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb25PdXRwdXRSZWZlcmVuY2UgfCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbik6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pLFxuICAgIGNoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiksXG4gICAgZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbiB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgfVxuICAgIGlmICh0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb24gfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdmFsdWUuY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdmFsdWUuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICB9XG4gIH1cblxuICAvLyBjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY2hhbmdlX3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbigpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gIH1cblxuICAvLyBjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY2hhbmdlX3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbigpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gIH1cblxuICAvLyBkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBkZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zIHtcbiAgLyoqXG4gICogYmFzZV9ibG9iIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjYmFzZV9ibG9iIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2Jhc2VfYmxvYn1cbiAgKi9cbiAgcmVhZG9ubHkgYmFzZUJsb2I/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2I7XG4gIC8qKlxuICAqIHNuYXBzaG90IGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjc25hcHNob3QgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjc25hcHNob3R9XG4gICovXG4gIHJlYWRvbmx5IHNuYXBzaG90PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90O1xuICAvKipcbiAgKiB2ZXJzaW9uIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjdmVyc2lvbiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSN2ZXJzaW9ufVxuICAqL1xuICByZWFkb25seSB2ZXJzaW9uPzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb247XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc091dHB1dFJlZmVyZW5jZSB8IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnMpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgYmFzZV9ibG9iOiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JUb1RlcnJhZm9ybShzdHJ1Y3QhLmJhc2VCbG9iKSxcbiAgICBzbmFwc2hvdDogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90VG9UZXJyYWZvcm0oc3RydWN0IS5zbmFwc2hvdCksXG4gICAgdmVyc2lvbjogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb25Ub1RlcnJhZm9ybShzdHJ1Y3QhLnZlcnNpb24pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9iYXNlQmxvYj8uaW50ZXJuYWxWYWx1ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5iYXNlQmxvYiA9IHRoaXMuX2Jhc2VCbG9iPy5pbnRlcm5hbFZhbHVlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fc25hcHNob3Q/LmludGVybmFsVmFsdWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuc25hcHNob3QgPSB0aGlzLl9zbmFwc2hvdD8uaW50ZXJuYWxWYWx1ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3ZlcnNpb24/LmludGVybmFsVmFsdWUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudmVyc2lvbiA9IHRoaXMuX3ZlcnNpb24/LmludGVybmFsVmFsdWU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl92ZXJzaW9uLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2Jhc2VCbG9iLmludGVybmFsVmFsdWUgPSB2YWx1ZS5iYXNlQmxvYjtcbiAgICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB2YWx1ZS5zbmFwc2hvdDtcbiAgICAgIHRoaXMuX3ZlcnNpb24uaW50ZXJuYWxWYWx1ZSA9IHZhbHVlLnZlcnNpb247XG4gICAgfVxuICB9XG5cbiAgLy8gYmFzZV9ibG9iIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Jhc2VCbG9iID0gbmV3IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNCYXNlQmxvYk91dHB1dFJlZmVyZW5jZSh0aGlzLCBcImJhc2VfYmxvYlwiKTtcbiAgcHVibGljIGdldCBiYXNlQmxvYigpIHtcbiAgICByZXR1cm4gdGhpcy5fYmFzZUJsb2I7XG4gIH1cbiAgcHVibGljIHB1dEJhc2VCbG9iKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2IpIHtcbiAgICB0aGlzLl9iYXNlQmxvYi5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QmFzZUJsb2IoKSB7XG4gICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYmFzZUJsb2JJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHNuYXBzaG90IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NuYXBzaG90ID0gbmV3IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdE91dHB1dFJlZmVyZW5jZSh0aGlzLCBcInNuYXBzaG90XCIpO1xuICBwdWJsaWMgZ2V0IHNuYXBzaG90KCkge1xuICAgIHJldHVybiB0aGlzLl9zbmFwc2hvdDtcbiAgfVxuICBwdWJsaWMgcHV0U25hcHNob3QodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdCkge1xuICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTbmFwc2hvdCgpIHtcbiAgICB0aGlzLl9zbmFwc2hvdC5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzbmFwc2hvdElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zbmFwc2hvdC5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gdmVyc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF92ZXJzaW9uID0gbmV3IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwidmVyc2lvblwiKTtcbiAgcHVibGljIGdldCB2ZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLl92ZXJzaW9uO1xuICB9XG4gIHB1YmxpYyBwdXRWZXJzaW9uKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbikge1xuICAgIHRoaXMuX3ZlcnNpb24uaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFZlcnNpb24oKSB7XG4gICAgdGhpcy5fdmVyc2lvbi5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB2ZXJzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZlcnNpb24uaW50ZXJuYWxWYWx1ZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzTWF0Y2hCbG9iSW5kZXhUYWcge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNuYW1lIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I25hbWV9XG4gICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjb3BlcmF0aW9uIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I29wZXJhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgb3BlcmF0aW9uPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSN2YWx1ZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSN2YWx1ZX1cbiAgKi9cbiAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZ1RvVGVycmFmb3JtKHN0cnVjdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZyB8IGNka3RmLklSZXNvbHZhYmxlKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkgfHwgY2RrdGYuVG9rZW5pemF0aW9uLmlzUmVzb2x2YWJsZShzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEubmFtZSksXG4gICAgb3BlcmF0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLm9wZXJhdGlvbiksXG4gICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudmFsdWUpLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVycyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I2Jsb2JfdHlwZXMgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjYmxvYl90eXBlc31cbiAgKi9cbiAgcmVhZG9ubHkgYmxvYlR5cGVzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I3ByZWZpeF9tYXRjaCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNwcmVmaXhfbWF0Y2h9XG4gICovXG4gIHJlYWRvbmx5IHByZWZpeE1hdGNoPzogc3RyaW5nW107XG4gIC8qKlxuICAqIG1hdGNoX2Jsb2JfaW5kZXhfdGFnIGJsb2NrXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjbWF0Y2hfYmxvYl9pbmRleF90YWcgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjbWF0Y2hfYmxvYl9pbmRleF90YWd9XG4gICovXG4gIHJlYWRvbmx5IG1hdGNoQmxvYkluZGV4VGFnPzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnW10gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzT3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVycyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBibG9iX3R5cGVzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKShzdHJ1Y3QhLmJsb2JUeXBlcyksXG4gICAgcHJlZml4X21hdGNoOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKShzdHJ1Y3QhLnByZWZpeE1hdGNoKSxcbiAgICBtYXRjaF9ibG9iX2luZGV4X3RhZzogY2RrdGYubGlzdE1hcHBlcihzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzTWF0Y2hCbG9iSW5kZXhUYWdUb1RlcnJhZm9ybSkoc3RydWN0IS5tYXRjaEJsb2JJbmRleFRhZyksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnMgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2Jsb2JUeXBlcyAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5ibG9iVHlwZXMgPSB0aGlzLl9ibG9iVHlwZXM7XG4gICAgfVxuICAgIGlmICh0aGlzLl9wcmVmaXhNYXRjaCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wcmVmaXhNYXRjaCA9IHRoaXMuX3ByZWZpeE1hdGNoO1xuICAgIH1cbiAgICBpZiAodGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWcgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubWF0Y2hCbG9iSW5kZXhUYWcgPSB0aGlzLl9tYXRjaEJsb2JJbmRleFRhZztcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9ibG9iVHlwZXMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9ibG9iVHlwZXMgPSB2YWx1ZS5ibG9iVHlwZXM7XG4gICAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHZhbHVlLnByZWZpeE1hdGNoO1xuICAgICAgdGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWcgPSB2YWx1ZS5tYXRjaEJsb2JJbmRleFRhZztcbiAgICB9XG4gIH1cblxuICAvLyBibG9iX3R5cGVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Jsb2JUeXBlcz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBibG9iVHlwZXMoKSB7XG4gICAgcmV0dXJuIGNka3RmLkZuLnRvbGlzdCh0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ2Jsb2JfdHlwZXMnKSk7XG4gIH1cbiAgcHVibGljIHNldCBibG9iVHlwZXModmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fYmxvYlR5cGVzID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QmxvYlR5cGVzKCkge1xuICAgIHRoaXMuX2Jsb2JUeXBlcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYmxvYlR5cGVzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jsb2JUeXBlcztcbiAgfVxuXG4gIC8vIHByZWZpeF9tYXRjaCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wcmVmaXhNYXRjaD86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBwcmVmaXhNYXRjaCgpIHtcbiAgICByZXR1cm4gY2RrdGYuRm4udG9saXN0KHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgncHJlZml4X21hdGNoJykpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJlZml4TWF0Y2godmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fcHJlZml4TWF0Y2ggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQcmVmaXhNYXRjaCgpIHtcbiAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJlZml4TWF0Y2hJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHJlZml4TWF0Y2g7XG4gIH1cblxuICAvLyBtYXRjaF9ibG9iX2luZGV4X3RhZyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tYXRjaEJsb2JJbmRleFRhZz86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZ1tdIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IG1hdGNoQmxvYkluZGV4VGFnKCkge1xuICAgIC8vIEdldHRpbmcgdGhlIGNvbXB1dGVkIHZhbHVlIGlzIG5vdCB5ZXQgaW1wbGVtZW50ZWRcbiAgICByZXR1cm4gY2RrdGYuVG9rZW4uYXNBbnkoY2RrdGYuRm4udG9saXN0KHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSgnbWF0Y2hfYmxvYl9pbmRleF90YWcnKSkpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWF0Y2hCbG9iSW5kZXhUYWcodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZ1tdIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9tYXRjaEJsb2JJbmRleFRhZyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1hdGNoQmxvYkluZGV4VGFnKCkge1xuICAgIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtYXRjaEJsb2JJbmRleFRhZ0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYXRjaEJsb2JJbmRleFRhZztcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGUge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNlbmFibGVkIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2VuYWJsZWR9XG4gICovXG4gIHJlYWRvbmx5IGVuYWJsZWQ6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjbmFtZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNuYW1lfVxuICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIGFjdGlvbnMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNhY3Rpb25zIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2FjdGlvbnN9XG4gICovXG4gIHJlYWRvbmx5IGFjdGlvbnM6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnM7XG4gIC8qKlxuICAqIGZpbHRlcnMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNmaWx0ZXJzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5I2ZpbHRlcnN9XG4gICovXG4gIHJlYWRvbmx5IGZpbHRlcnM/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlIHwgY2RrdGYuSVJlc29sdmFibGUpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSB8fCBjZGt0Zi5Ub2tlbml6YXRpb24uaXNSZXNvbHZhYmxlKHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgZW5hYmxlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHN0cnVjdCEuZW5hYmxlZCksXG4gICAgbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5uYW1lKSxcbiAgICBhY3Rpb25zOiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVG9UZXJyYWZvcm0oc3RydWN0IS5hY3Rpb25zKSxcbiAgICBmaWx0ZXJzOiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzVG9UZXJyYWZvcm0oc3RydWN0IS5maWx0ZXJzKSxcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHMge1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSNjcmVhdGUgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjY3JlYXRlfVxuICAqL1xuICByZWFkb25seSBjcmVhdGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5I2RlbGV0ZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNkZWxldGV9XG4gICovXG4gIHJlYWRvbmx5IGRlbGV0ZT86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kjcmVhZCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSNyZWFkfVxuICAqL1xuICByZWFkb25seSByZWFkPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeSN1cGRhdGUgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kjdXBkYXRlfVxuICAqL1xuICByZWFkb25seSB1cGRhdGU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0c091dHB1dFJlZmVyZW5jZSB8IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHMgfCBjZGt0Zi5JUmVzb2x2YWJsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjcmVhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuY3JlYXRlKSxcbiAgICBkZWxldGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlKSxcbiAgICByZWFkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnJlYWQpLFxuICAgIHVwZGF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS51cGRhdGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gIC8qKlxuICAqIEBwYXJhbSB0ZXJyYWZvcm1SZXNvdXJjZSBUaGUgcGFyZW50IHJlc291cmNlXG4gICogQHBhcmFtIHRlcnJhZm9ybUF0dHJpYnV0ZSBUaGUgYXR0cmlidXRlIG9uIHRoZSBwYXJlbnQgcmVzb3VyY2UgdGhpcyBjbGFzcyBpcyByZWZlcmVuY2luZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklJbnRlcnBvbGF0aW5nUGFyZW50LCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZykge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGZhbHNlLCAwKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jcmVhdGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY3JlYXRlID0gdGhpcy5fY3JlYXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZSA9IHRoaXMuX2RlbGV0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3JlYWQgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVhZCA9IHRoaXMuX3JlYWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl91cGRhdGUgIT09IHVuZGVmaW5lZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudXBkYXRlID0gdGhpcy5fdXBkYXRlO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0cyB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3JlYWQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl91cGRhdGUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHZhbHVlLmNyZWF0ZTtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlLmRlbGV0ZTtcbiAgICAgIHRoaXMuX3JlYWQgPSB2YWx1ZS5yZWFkO1xuICAgICAgdGhpcy5fdXBkYXRlID0gdmFsdWUudXBkYXRlO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNyZWF0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcmVhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNyZWF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NyZWF0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgY3JlYXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcmVhdGUoKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcmVhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3JlYXRlO1xuICB9XG5cbiAgLy8gZGVsZXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVsZXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWxldGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZSgpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGU7XG4gIH1cblxuICAvLyByZWFkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlYWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlYWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdyZWFkJyk7XG4gIH1cbiAgcHVibGljIHNldCByZWFkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZWFkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVhZCgpIHtcbiAgICB0aGlzLl9yZWFkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZWFkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlYWQ7XG4gIH1cblxuICAvLyB1cGRhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXBkYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1cGRhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1cGRhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHVwZGF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXBkYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXBkYXRlKCkge1xuICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXBkYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VwZGF0ZTtcbiAgfVxufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVybS9yL3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3kgYXp1cmVybV9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5fVxuKi9cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeSBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJhenVyZXJtX3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3lcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIC8qKlxuICAqIENyZWF0ZSBhIG5ldyB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlcm0vci9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5IGF6dXJlcm1fc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeX0gUmVzb3VyY2VcbiAgKlxuICAqIEBwYXJhbSBzY29wZSBUaGUgc2NvcGUgaW4gd2hpY2ggdG8gZGVmaW5lIHRoaXMgY29uc3RydWN0XG4gICogQHBhcmFtIGlkIFRoZSBzY29wZWQgY29uc3RydWN0IElELiBNdXN0IGJlIHVuaXF1ZSBhbW9uZ3N0IHNpYmxpbmdzIGluIHRoZSBzYW1lIHNjb3BlXG4gICogQHBhcmFtIG9wdGlvbnMgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lDb25maWdcbiAgKi9cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2F6dXJlcm1fc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeScsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdhenVyZXJtJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uOiAnMi45OS4wJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDIuMCdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX3N0b3JhZ2VBY2NvdW50SWQgPSBjb25maWcuc3RvcmFnZUFjY291bnRJZDtcbiAgICB0aGlzLl9ydWxlID0gY29uZmlnLnJ1bGU7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IGNvbmZpZy50aW1lb3V0cztcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGlkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnaWQnKTtcbiAgfVxuXG4gIC8vIHN0b3JhZ2VfYWNjb3VudF9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9zdG9yYWdlQWNjb3VudElkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzdG9yYWdlQWNjb3VudElkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc3RvcmFnZV9hY2NvdW50X2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBzdG9yYWdlQWNjb3VudElkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zdG9yYWdlQWNjb3VudElkID0gdmFsdWU7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHN0b3JhZ2VBY2NvdW50SWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc3RvcmFnZUFjY291bnRJZDtcbiAgfVxuXG4gIC8vIHJ1bGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcnVsZT86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVtdIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHJ1bGUoKSB7XG4gICAgLy8gR2V0dGluZyB0aGUgY29tcHV0ZWQgdmFsdWUgaXMgbm90IHlldCBpbXBsZW1lbnRlZFxuICAgIHJldHVybiB0aGlzLmludGVycG9sYXRpb25Gb3JBdHRyaWJ1dGUoJ3J1bGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHJ1bGUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVtdIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9ydWxlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UnVsZSgpIHtcbiAgICB0aGlzLl9ydWxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBydWxlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3J1bGU7XG4gIH1cblxuICAvLyB0aW1lb3V0cyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aW1lb3V0cyA9IG5ldyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzT3V0cHV0UmVmZXJlbmNlKHRoaXMsIFwidGltZW91dHNcIik7XG4gIHB1YmxpYyBnZXQgdGltZW91dHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpbWVvdXRzO1xuICB9XG4gIHB1YmxpYyBwdXRUaW1lb3V0cyh2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0cykge1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaW1lb3V0cygpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0aW1lb3V0c0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBzdG9yYWdlX2FjY291bnRfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3N0b3JhZ2VBY2NvdW50SWQpLFxuICAgICAgcnVsZTogY2RrdGYubGlzdE1hcHBlcihzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVUb1RlcnJhZm9ybSkodGhpcy5fcnVsZSksXG4gICAgICB0aW1lb3V0czogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0c1RvVGVycmFmb3JtKHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUpLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==