# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AdaptivePolicyGroupsArgs', 'AdaptivePolicyGroups']

@pulumi.input_type
class AdaptivePolicyGroupsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_objects: Optional[pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]]] = None,
                 sgt: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AdaptivePolicyGroups resource.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[str] description: Description of the group (default: "")
        :param pulumi.Input[str] name: Name of the group
        :param pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]] policy_objects: The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        :param pulumi.Input[int] sgt: SGT value of the group
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_objects is not None:
            pulumi.set(__self__, "policy_objects", policy_objects)
        if sgt is not None:
            pulumi.set(__self__, "sgt", sgt)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the group (default: "")
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyObjects")
    def policy_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]]]:
        """
        The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        """
        return pulumi.get(self, "policy_objects")

    @policy_objects.setter
    def policy_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]]]):
        pulumi.set(self, "policy_objects", value)

    @property
    @pulumi.getter
    def sgt(self) -> Optional[pulumi.Input[int]]:
        """
        SGT value of the group
        """
        return pulumi.get(self, "sgt")

    @sgt.setter
    def sgt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sgt", value)


@pulumi.input_type
class _AdaptivePolicyGroupsState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 is_default_group: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policy_objects: Optional[pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]]] = None,
                 required_ip_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sgt: Optional[pulumi.Input[int]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AdaptivePolicyGroups resources.
        :param pulumi.Input[str] description: Description of the group (default: "")
        :param pulumi.Input[str] name: Name of the group
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]] policy_objects: The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        :param pulumi.Input[int] sgt: SGT value of the group
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if is_default_group is not None:
            pulumi.set(__self__, "is_default_group", is_default_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if policy_objects is not None:
            pulumi.set(__self__, "policy_objects", policy_objects)
        if required_ip_mappings is not None:
            pulumi.set(__self__, "required_ip_mappings", required_ip_mappings)
        if sgt is not None:
            pulumi.set(__self__, "sgt", sgt)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the group (default: "")
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="isDefaultGroup")
    def is_default_group(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_default_group")

    @is_default_group.setter
    def is_default_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="policyObjects")
    def policy_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]]]:
        """
        The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        """
        return pulumi.get(self, "policy_objects")

    @policy_objects.setter
    def policy_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AdaptivePolicyGroupsPolicyObjectArgs']]]]):
        pulumi.set(self, "policy_objects", value)

    @property
    @pulumi.getter(name="requiredIpMappings")
    def required_ip_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "required_ip_mappings")

    @required_ip_mappings.setter
    def required_ip_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "required_ip_mappings", value)

    @property
    @pulumi.getter
    def sgt(self) -> Optional[pulumi.Input[int]]:
        """
        SGT value of the group
        """
        return pulumi.get(self, "sgt")

    @sgt.setter
    def sgt(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sgt", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class AdaptivePolicyGroups(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policy_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AdaptivePolicyGroupsPolicyObjectArgs']]]]] = None,
                 sgt: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.AdaptivePolicyGroups("example",
            description="Group of XYZ Corp Employees",
            name="Employee Group",
            organization_id="string",
            policy_objects=[meraki.organizations.AdaptivePolicyGroupsPolicyObjectArgs(
                id="2345",
                name="Example Policy Object",
            )],
            sgt=1000)
        pulumi.export("merakiOrganizationsAdaptivePolicyGroupsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/adaptivePolicyGroups:AdaptivePolicyGroups example "id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the group (default: "")
        :param pulumi.Input[str] name: Name of the group
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AdaptivePolicyGroupsPolicyObjectArgs']]]] policy_objects: The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        :param pulumi.Input[int] sgt: SGT value of the group
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdaptivePolicyGroupsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.AdaptivePolicyGroups("example",
            description="Group of XYZ Corp Employees",
            name="Employee Group",
            organization_id="string",
            policy_objects=[meraki.organizations.AdaptivePolicyGroupsPolicyObjectArgs(
                id="2345",
                name="Example Policy Object",
            )],
            sgt=1000)
        pulumi.export("merakiOrganizationsAdaptivePolicyGroupsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/adaptivePolicyGroups:AdaptivePolicyGroups example "id,organization_id"
        ```

        :param str resource_name: The name of the resource.
        :param AdaptivePolicyGroupsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdaptivePolicyGroupsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policy_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AdaptivePolicyGroupsPolicyObjectArgs']]]]] = None,
                 sgt: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdaptivePolicyGroupsArgs.__new__(AdaptivePolicyGroupsArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["policy_objects"] = policy_objects
            __props__.__dict__["sgt"] = sgt
            __props__.__dict__["created_at"] = None
            __props__.__dict__["group_id"] = None
            __props__.__dict__["is_default_group"] = None
            __props__.__dict__["required_ip_mappings"] = None
            __props__.__dict__["updated_at"] = None
        super(AdaptivePolicyGroups, __self__).__init__(
            'meraki:organizations/adaptivePolicyGroups:AdaptivePolicyGroups',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            is_default_group: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            policy_objects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AdaptivePolicyGroupsPolicyObjectArgs']]]]] = None,
            required_ip_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sgt: Optional[pulumi.Input[int]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'AdaptivePolicyGroups':
        """
        Get an existing AdaptivePolicyGroups resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the group (default: "")
        :param pulumi.Input[str] name: Name of the group
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AdaptivePolicyGroupsPolicyObjectArgs']]]] policy_objects: The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        :param pulumi.Input[int] sgt: SGT value of the group
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdaptivePolicyGroupsState.__new__(_AdaptivePolicyGroupsState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["is_default_group"] = is_default_group
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["policy_objects"] = policy_objects
        __props__.__dict__["required_ip_mappings"] = required_ip_mappings
        __props__.__dict__["sgt"] = sgt
        __props__.__dict__["updated_at"] = updated_at
        return AdaptivePolicyGroups(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the group (default: "")
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="isDefaultGroup")
    def is_default_group(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_default_group")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the group
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="policyObjects")
    def policy_objects(self) -> pulumi.Output[Sequence['outputs.AdaptivePolicyGroupsPolicyObject']]:
        """
        The policy objects that belong to this group; traffic from addresses specified by these policy objects will be tagged with this group's SGT value if no other tagging scheme is being used (each requires one unique attribute) ()
        """
        return pulumi.get(self, "policy_objects")

    @property
    @pulumi.getter(name="requiredIpMappings")
    def required_ip_mappings(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "required_ip_mappings")

    @property
    @pulumi.getter
    def sgt(self) -> pulumi.Output[int]:
        """
        SGT value of the group
        """
        return pulumi.get(self, "sgt")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

