# coding: utf-8

"""
    Songtradr API

    This is the Songtradr API. Use it to retrieve deep music metadata and trigger processes like auto-tagging.  You can also use the API to manage your account and musicube cloud data.  **Authentication**  1. Reach out to support@songtradr.com to receive a free account or use your login data if you are already signed up.  2. To authenticate, you need to login via the POST /api/v1/user/login endpoint.  3. The endpoint responds with a jwtToken which you can use in all following API requests as a bearer token.  **Rate Limiting**  The current limit is 120 Requests per minute. Reach out to us via support@songtradr.com if you need to request more.  **Getting Started with auto-tagging**  1. If you want to get your own files auto-tagged, use the POST /api/v1/user/file/{name}/initUpload endpoint. It responds with a presigned S3 link where you can upload your file. 2. You can check the processing status of your file via the GET /api/v1/user/file/{name}/filesStatus endpoint. 3. As soon as processing is done, you can request the generated data via the GET /api/v1/user/files endpoint.  **Getting Started with search**  You can either search the released music via the /public/recording endpoints or your own private uploaded music via the /user/file/ endpoints.  1. If you want to search the world's released music, a good starting point is the GET /api/v1/public/recording/search endpoint. Please find the extensive list of parameters that serve as semantic search filters. 2. If you want to search your own previously uploaded music, a good starting point is the GET GET /api/v1/user/files endpoint. It has the same extensive list of parameters that serve as semantic search filters.

    The version of the OpenAPI document: 3.0.0
    Contact: info@songtradr.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from songtradr_api_client_python.models.recording_medium_dto import RecordingMediumDTO
from songtradr_api_client_python.models.recording_minimal_with_taggrams_dto import RecordingMinimalWithTaggramsDTO
from songtradr_api_client_python.models.recording_minimal_with_tagstrengths_dto import RecordingMinimalWithTagstrengthsDTO

from songtradr_api_client_python.api_client import ApiClient, RequestSerialized
from songtradr_api_client_python.api_response import ApiResponse
from songtradr_api_client_python.rest import RESTResponseType


class RecordingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def recordings_by_ids_with_taggrams1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithTaggramsDTO]:
        """(Deprecated) Timeseries of AI generated moods, musical features and more for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/taggrams is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_taggrams1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_ids_with_taggrams1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithTaggramsDTO]]:
        """(Deprecated) Timeseries of AI generated moods, musical features and more for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/taggrams is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_taggrams1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_ids_with_taggrams1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        from_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data starting from from this timestamp in seconds.")] = None,
        to_timestamp: Annotated[Optional[Union[StrictFloat, StrictInt]], Field(description="Show only taggrams data before this timestamp in seconds.")] = None,
        fill_with_zero: Annotated[Optional[StrictBool], Field(description="If set to true, empty timeseries are filled with timeseries of 0.0 values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Timeseries of AI generated moods, musical features and more for a list of recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param from_timestamp: Show only taggrams data starting from from this timestamp in seconds.
        :type from_timestamp: float
        :param to_timestamp: Show only taggrams data before this timestamp in seconds.
        :type to_timestamp: float
        :param fill_with_zero: If set to true, empty timeseries are filled with timeseries of 0.0 values.
        :type fill_with_zero: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/taggrams is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_taggrams1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            from_timestamp=from_timestamp,
            to_timestamp=to_timestamp,
            fill_with_zero=fill_with_zero,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTaggramsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_ids_with_taggrams1_serialize(
        self,
        ids,
        category_name,
        tag_name,
        genre_name,
        from_timestamp,
        to_timestamp,
        fill_with_zero,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if category_name is not None:
            
            _query_params.append(('categoryName', category_name))
            
        if tag_name is not None:
            
            _query_params.append(('tagName', tag_name))
            
        if genre_name is not None:
            
            _query_params.append(('genreName', genre_name))
            
        if from_timestamp is not None:
            
            _query_params.append(('fromTimestamp', from_timestamp))
            
        if to_timestamp is not None:
            
            _query_params.append(('toTimestamp', to_timestamp))
            
        if fill_with_zero is not None:
            
            _query_params.append(('fillWithZero', fill_with_zero))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/{ids}/taggrams',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_by_ids_with_tagstrengths1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMinimalWithTagstrengthsDTO]:
        """(Deprecated) Strengths as numerical representations for AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/tagstrengths is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_tagstrengths1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_by_ids_with_tagstrengths1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMinimalWithTagstrengthsDTO]]:
        """(Deprecated) Strengths as numerical representations for AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/tagstrengths is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_tagstrengths1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_by_ids_with_tagstrengths1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        category_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one category.")] = None,
        tag_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one tag.")] = None,
        genre_name: Annotated[Optional[StrictStr], Field(description="Show only taggrams for one genre.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Strengths as numerical representations for AI generated moods, musical features and more for recordings.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param category_name: Show only taggrams for one category.
        :type category_name: str
        :param tag_name: Show only taggrams for one tag.
        :type tag_name: str
        :param genre_name: Show only taggrams for one genre.
        :type genre_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/{ids}/tagstrengths is deprecated.", DeprecationWarning)

        _param = self._recordings_by_ids_with_tagstrengths1_serialize(
            ids=ids,
            category_name=category_name,
            tag_name=tag_name,
            genre_name=genre_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMinimalWithTagstrengthsDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_by_ids_with_tagstrengths1_serialize(
        self,
        ids,
        category_name,
        tag_name,
        genre_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if category_name is not None:
            
            _query_params.append(('categoryName', category_name))
            
        if tag_name is not None:
            
            _query_params.append(('tagName', tag_name))
            
        if genre_name is not None:
            
            _query_params.append(('genreName', genre_name))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/{ids}/tagstrengths',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def recordings_medium_by_ids1(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[RecordingMediumDTO]:
        """(Deprecated) Recordings by IDs with a medium sized response.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/m/{ids} is deprecated.", DeprecationWarning)

        _param = self._recordings_medium_by_ids1_serialize(
            ids=ids,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def recordings_medium_by_ids1_with_http_info(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[RecordingMediumDTO]]:
        """(Deprecated) Recordings by IDs with a medium sized response.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/m/{ids} is deprecated.", DeprecationWarning)

        _param = self._recordings_medium_by_ids1_serialize(
            ids=ids,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def recordings_medium_by_ids1_without_preload_content(
        self,
        ids: Annotated[StrictStr, Field(description="Comma seperated list of IDs. Can be ISRCs or proprietary IDs")],
        page: Annotated[Optional[StrictInt], Field(description="Zero-based page index (0..N)")] = None,
        size: Annotated[Optional[StrictInt], Field(description="The size of the page to be returned")] = None,
        sort: Annotated[Optional[List[StrictStr]], Field(description="Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """(Deprecated) Recordings by IDs with a medium sized response.


        :param ids: Comma seperated list of IDs. Can be ISRCs or proprietary IDs (required)
        :type ids: str
        :param page: Zero-based page index (0..N)
        :type page: int
        :param size: The size of the page to be returned
        :type size: int
        :param sort: Sorting criteria in the format: property,(asc|desc). Default sort order is ascending. Multiple sort criteria are supported.
        :type sort: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501
        warnings.warn("GET /api/v1/public/recording/m/{ids} is deprecated.", DeprecationWarning)

        _param = self._recordings_medium_by_ids1_serialize(
            ids=ids,
            page=page,
            size=size,
            sort=sort,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[RecordingMediumDTO]",
            '401': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _recordings_medium_by_ids1_serialize(
        self,
        ids,
        page,
        size,
        sort,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'sort': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ids is not None:
            _path_params['ids'] = ids
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
            'bearer-jwt'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/public/recording/m/{ids}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


