# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRemediationRunStageResult',
    'AwaitableGetRemediationRunStageResult',
    'get_remediation_run_stage',
    'get_remediation_run_stage_output',
]

@pulumi.output_type
class GetRemediationRunStageResult:
    """
    A collection of values returned by getRemediationRunStage.
    """
    def __init__(__self__, audit_id=None, id=None, next_stage_type=None, pipeline_properties=None, previous_stage_type=None, pull_request_properties=None, recommended_updates_count=None, remediation_run_id=None, stage_type=None, status=None, summary=None, time_created=None, time_finished=None, time_started=None, type=None):
        if audit_id and not isinstance(audit_id, str):
            raise TypeError("Expected argument 'audit_id' to be a str")
        pulumi.set(__self__, "audit_id", audit_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if next_stage_type and not isinstance(next_stage_type, str):
            raise TypeError("Expected argument 'next_stage_type' to be a str")
        pulumi.set(__self__, "next_stage_type", next_stage_type)
        if pipeline_properties and not isinstance(pipeline_properties, list):
            raise TypeError("Expected argument 'pipeline_properties' to be a list")
        pulumi.set(__self__, "pipeline_properties", pipeline_properties)
        if previous_stage_type and not isinstance(previous_stage_type, str):
            raise TypeError("Expected argument 'previous_stage_type' to be a str")
        pulumi.set(__self__, "previous_stage_type", previous_stage_type)
        if pull_request_properties and not isinstance(pull_request_properties, list):
            raise TypeError("Expected argument 'pull_request_properties' to be a list")
        pulumi.set(__self__, "pull_request_properties", pull_request_properties)
        if recommended_updates_count and not isinstance(recommended_updates_count, int):
            raise TypeError("Expected argument 'recommended_updates_count' to be a int")
        pulumi.set(__self__, "recommended_updates_count", recommended_updates_count)
        if remediation_run_id and not isinstance(remediation_run_id, str):
            raise TypeError("Expected argument 'remediation_run_id' to be a str")
        pulumi.set(__self__, "remediation_run_id", remediation_run_id)
        if stage_type and not isinstance(stage_type, str):
            raise TypeError("Expected argument 'stage_type' to be a str")
        pulumi.set(__self__, "stage_type", stage_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if summary and not isinstance(summary, str):
            raise TypeError("Expected argument 'summary' to be a str")
        pulumi.set(__self__, "summary", summary)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_finished and not isinstance(time_finished, str):
            raise TypeError("Expected argument 'time_finished' to be a str")
        pulumi.set(__self__, "time_finished", time_finished)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="auditId")
    def audit_id(self) -> _builtins.str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the vulnerability audit.
        """
        return pulumi.get(self, "audit_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nextStageType")
    def next_stage_type(self) -> _builtins.str:
        """
        The next type of stage in the remediation run.
        """
        return pulumi.get(self, "next_stage_type")

    @_builtins.property
    @pulumi.getter(name="pipelineProperties")
    def pipeline_properties(self) -> Sequence['outputs.GetRemediationRunStagePipelinePropertyResult']:
        """
        Pipeline properties which result from the run of the verify stage.
        """
        return pulumi.get(self, "pipeline_properties")

    @_builtins.property
    @pulumi.getter(name="previousStageType")
    def previous_stage_type(self) -> _builtins.str:
        """
        The previous type of stage in the remediation run.
        """
        return pulumi.get(self, "previous_stage_type")

    @_builtins.property
    @pulumi.getter(name="pullRequestProperties")
    def pull_request_properties(self) -> Sequence['outputs.GetRemediationRunStagePullRequestPropertyResult']:
        """
        Pull request properties from recommend stage of the remediation run.
        """
        return pulumi.get(self, "pull_request_properties")

    @_builtins.property
    @pulumi.getter(name="recommendedUpdatesCount")
    def recommended_updates_count(self) -> _builtins.int:
        """
        Count of recommended application dependencies to update.
        """
        return pulumi.get(self, "recommended_updates_count")

    @_builtins.property
    @pulumi.getter(name="remediationRunId")
    def remediation_run_id(self) -> _builtins.str:
        """
        The Oracle Cloud identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the remediation run.
        """
        return pulumi.get(self, "remediation_run_id")

    @_builtins.property
    @pulumi.getter(name="stageType")
    def stage_type(self) -> _builtins.str:
        return pulumi.get(self, "stage_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of a remediation run stage.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def summary(self) -> _builtins.str:
        """
        Information about the current step within the stage.
        """
        return pulumi.get(self, "summary")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The creation date and time of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> _builtins.str:
        """
        The date and time of the finish of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_finished")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> _builtins.str:
        """
        The date and time of the start of the remediation run stage (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the remediation run stage.
        """
        return pulumi.get(self, "type")


class AwaitableGetRemediationRunStageResult(GetRemediationRunStageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRemediationRunStageResult(
            audit_id=self.audit_id,
            id=self.id,
            next_stage_type=self.next_stage_type,
            pipeline_properties=self.pipeline_properties,
            previous_stage_type=self.previous_stage_type,
            pull_request_properties=self.pull_request_properties,
            recommended_updates_count=self.recommended_updates_count,
            remediation_run_id=self.remediation_run_id,
            stage_type=self.stage_type,
            status=self.status,
            summary=self.summary,
            time_created=self.time_created,
            time_finished=self.time_finished,
            time_started=self.time_started,
            type=self.type)


def get_remediation_run_stage(remediation_run_id: Optional[_builtins.str] = None,
                              stage_type: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRemediationRunStageResult:
    """
    This data source provides details about a specific Remediation Run Stage resource in Oracle Cloud Infrastructure Adm service.

    Returns the details of the specified Remediation Run Stage.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_run_stage = oci.Adm.get_remediation_run_stage(remediation_run_id=test_remediation_run["id"],
        stage_type=remediation_run_stage_stage_type)
    ```


    :param _builtins.str remediation_run_id: Unique Remediation Run identifier path parameter.
    :param _builtins.str stage_type: The type of Remediation Run Stage, as a URL path parameter.
    """
    __args__ = dict()
    __args__['remediationRunId'] = remediation_run_id
    __args__['stageType'] = stage_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Adm/getRemediationRunStage:getRemediationRunStage', __args__, opts=opts, typ=GetRemediationRunStageResult).value

    return AwaitableGetRemediationRunStageResult(
        audit_id=pulumi.get(__ret__, 'audit_id'),
        id=pulumi.get(__ret__, 'id'),
        next_stage_type=pulumi.get(__ret__, 'next_stage_type'),
        pipeline_properties=pulumi.get(__ret__, 'pipeline_properties'),
        previous_stage_type=pulumi.get(__ret__, 'previous_stage_type'),
        pull_request_properties=pulumi.get(__ret__, 'pull_request_properties'),
        recommended_updates_count=pulumi.get(__ret__, 'recommended_updates_count'),
        remediation_run_id=pulumi.get(__ret__, 'remediation_run_id'),
        stage_type=pulumi.get(__ret__, 'stage_type'),
        status=pulumi.get(__ret__, 'status'),
        summary=pulumi.get(__ret__, 'summary'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_finished=pulumi.get(__ret__, 'time_finished'),
        time_started=pulumi.get(__ret__, 'time_started'),
        type=pulumi.get(__ret__, 'type'))
def get_remediation_run_stage_output(remediation_run_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     stage_type: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRemediationRunStageResult]:
    """
    This data source provides details about a specific Remediation Run Stage resource in Oracle Cloud Infrastructure Adm service.

    Returns the details of the specified Remediation Run Stage.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_remediation_run_stage = oci.Adm.get_remediation_run_stage(remediation_run_id=test_remediation_run["id"],
        stage_type=remediation_run_stage_stage_type)
    ```


    :param _builtins.str remediation_run_id: Unique Remediation Run identifier path parameter.
    :param _builtins.str stage_type: The type of Remediation Run Stage, as a URL path parameter.
    """
    __args__ = dict()
    __args__['remediationRunId'] = remediation_run_id
    __args__['stageType'] = stage_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Adm/getRemediationRunStage:getRemediationRunStage', __args__, opts=opts, typ=GetRemediationRunStageResult)
    return __ret__.apply(lambda __response__: GetRemediationRunStageResult(
        audit_id=pulumi.get(__response__, 'audit_id'),
        id=pulumi.get(__response__, 'id'),
        next_stage_type=pulumi.get(__response__, 'next_stage_type'),
        pipeline_properties=pulumi.get(__response__, 'pipeline_properties'),
        previous_stage_type=pulumi.get(__response__, 'previous_stage_type'),
        pull_request_properties=pulumi.get(__response__, 'pull_request_properties'),
        recommended_updates_count=pulumi.get(__response__, 'recommended_updates_count'),
        remediation_run_id=pulumi.get(__response__, 'remediation_run_id'),
        stage_type=pulumi.get(__response__, 'stage_type'),
        status=pulumi.get(__response__, 'status'),
        summary=pulumi.get(__response__, 'summary'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_finished=pulumi.get(__response__, 'time_finished'),
        time_started=pulumi.get(__response__, 'time_started'),
        type=pulumi.get(__response__, 'type')))
