# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResultResult',
    'AwaitableGetResultResult',
    'get_result',
    'get_result_output',
]

@pulumi.output_type
class GetResultResult:
    """
    A collection of values returned by getResult.
    """
    def __init__(__self__, apm_domain_id=None, execution_time=None, id=None, monitor_id=None, result_content_type=None, result_data_sets=None, result_type=None, vantage_point=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if execution_time and not isinstance(execution_time, str):
            raise TypeError("Expected argument 'execution_time' to be a str")
        pulumi.set(__self__, "execution_time", execution_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitor_id and not isinstance(monitor_id, str):
            raise TypeError("Expected argument 'monitor_id' to be a str")
        pulumi.set(__self__, "monitor_id", monitor_id)
        if result_content_type and not isinstance(result_content_type, str):
            raise TypeError("Expected argument 'result_content_type' to be a str")
        pulumi.set(__self__, "result_content_type", result_content_type)
        if result_data_sets and not isinstance(result_data_sets, list):
            raise TypeError("Expected argument 'result_data_sets' to be a list")
        pulumi.set(__self__, "result_data_sets", result_data_sets)
        if result_type and not isinstance(result_type, str):
            raise TypeError("Expected argument 'result_type' to be a str")
        pulumi.set(__self__, "result_type", result_type)
        if vantage_point and not isinstance(vantage_point, str):
            raise TypeError("Expected argument 'vantage_point' to be a str")
        pulumi.set(__self__, "vantage_point", vantage_point)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="executionTime")
    def execution_time(self) -> _builtins.str:
        """
        The specific point of time when the result of an execution is collected.
        """
        return pulumi.get(self, "execution_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitor.
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter(name="resultContentType")
    def result_content_type(self) -> _builtins.str:
        """
        Type of result content. Example: Zip or Raw file.
        """
        return pulumi.get(self, "result_content_type")

    @_builtins.property
    @pulumi.getter(name="resultDataSets")
    def result_data_sets(self) -> Sequence['outputs.GetResultResultDataSetResult']:
        """
        Monitor result data set.
        """
        return pulumi.get(self, "result_data_sets")

    @_builtins.property
    @pulumi.getter(name="resultType")
    def result_type(self) -> _builtins.str:
        """
        Type of result. Example: har, screenshot, log, network, diagnostics or script.
        """
        return pulumi.get(self, "result_type")

    @_builtins.property
    @pulumi.getter(name="vantagePoint")
    def vantage_point(self) -> _builtins.str:
        """
        The name of the public or dedicated vantage point.
        """
        return pulumi.get(self, "vantage_point")


class AwaitableGetResultResult(GetResultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResultResult(
            apm_domain_id=self.apm_domain_id,
            execution_time=self.execution_time,
            id=self.id,
            monitor_id=self.monitor_id,
            result_content_type=self.result_content_type,
            result_data_sets=self.result_data_sets,
            result_type=self.result_type,
            vantage_point=self.vantage_point)


def get_result(apm_domain_id: Optional[_builtins.str] = None,
               execution_time: Optional[_builtins.str] = None,
               monitor_id: Optional[_builtins.str] = None,
               result_content_type: Optional[_builtins.str] = None,
               result_type: Optional[_builtins.str] = None,
               vantage_point: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResultResult:
    """
    This data source provides details about a specific Result resource in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Gets the results for a specific execution of a monitor identified by OCID. The results are in a HAR file, Screenshot, Console Log, Network details, Diagnostics or Script Content.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_result = oci.ApmSynthetics.get_result(apm_domain_id=test_apm_domain["id"],
        execution_time=result_execution_time,
        monitor_id=test_monitor["id"],
        result_content_type=result_result_content_type,
        result_type=result_result_type,
        vantage_point=result_vantage_point)
    ```


    :param _builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param _builtins.str execution_time: The time the object was posted.
    :param _builtins.str monitor_id: The OCID of the monitor.
    :param _builtins.str result_content_type: The result content type: zip or raw.
    :param _builtins.str result_type: The result type: har, screenshot, log, network, diagnostics or script.
    :param _builtins.str vantage_point: The vantagePoint name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['executionTime'] = execution_time
    __args__['monitorId'] = monitor_id
    __args__['resultContentType'] = result_content_type
    __args__['resultType'] = result_type
    __args__['vantagePoint'] = vantage_point
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getResult:getResult', __args__, opts=opts, typ=GetResultResult).value

    return AwaitableGetResultResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        execution_time=pulumi.get(__ret__, 'execution_time'),
        id=pulumi.get(__ret__, 'id'),
        monitor_id=pulumi.get(__ret__, 'monitor_id'),
        result_content_type=pulumi.get(__ret__, 'result_content_type'),
        result_data_sets=pulumi.get(__ret__, 'result_data_sets'),
        result_type=pulumi.get(__ret__, 'result_type'),
        vantage_point=pulumi.get(__ret__, 'vantage_point'))
def get_result_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                      execution_time: Optional[pulumi.Input[_builtins.str]] = None,
                      monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                      result_content_type: Optional[pulumi.Input[_builtins.str]] = None,
                      result_type: Optional[pulumi.Input[_builtins.str]] = None,
                      vantage_point: Optional[pulumi.Input[_builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResultResult]:
    """
    This data source provides details about a specific Result resource in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

    Gets the results for a specific execution of a monitor identified by OCID. The results are in a HAR file, Screenshot, Console Log, Network details, Diagnostics or Script Content.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_result = oci.ApmSynthetics.get_result(apm_domain_id=test_apm_domain["id"],
        execution_time=result_execution_time,
        monitor_id=test_monitor["id"],
        result_content_type=result_result_content_type,
        result_type=result_result_type,
        vantage_point=result_vantage_point)
    ```


    :param _builtins.str apm_domain_id: The APM domain ID the request is intended for.
    :param _builtins.str execution_time: The time the object was posted.
    :param _builtins.str monitor_id: The OCID of the monitor.
    :param _builtins.str result_content_type: The result content type: zip or raw.
    :param _builtins.str result_type: The result type: har, screenshot, log, network, diagnostics or script.
    :param _builtins.str vantage_point: The vantagePoint name.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['executionTime'] = execution_time
    __args__['monitorId'] = monitor_id
    __args__['resultContentType'] = result_content_type
    __args__['resultType'] = result_type
    __args__['vantagePoint'] = vantage_point
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getResult:getResult', __args__, opts=opts, typ=GetResultResult)
    return __ret__.apply(lambda __response__: GetResultResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        execution_time=pulumi.get(__response__, 'execution_time'),
        id=pulumi.get(__response__, 'id'),
        monitor_id=pulumi.get(__response__, 'monitor_id'),
        result_content_type=pulumi.get(__response__, 'result_content_type'),
        result_data_sets=pulumi.get(__response__, 'result_data_sets'),
        result_type=pulumi.get(__response__, 'result_type'),
        vantage_point=pulumi.get(__response__, 'vantage_point')))
