# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAttributeAutoActivateStatusResult',
    'AwaitableGetAttributeAutoActivateStatusResult',
    'get_attribute_auto_activate_status',
    'get_attribute_auto_activate_status_output',
]

@pulumi.output_type
class GetAttributeAutoActivateStatusResult:
    """
    A collection of values returned by getAttributeAutoActivateStatus.
    """
    def __init__(__self__, apm_domain_id=None, data_key=None, data_key_type=None, id=None, state=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if data_key and not isinstance(data_key, str):
            raise TypeError("Expected argument 'data_key' to be a str")
        pulumi.set(__self__, "data_key", data_key)
        if data_key_type and not isinstance(data_key_type, str):
            raise TypeError("Expected argument 'data_key_type' to be a str")
        pulumi.set(__self__, "data_key_type", data_key_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="dataKey")
    def data_key(self) -> _builtins.str:
        """
        Data key type for which auto-activate needs needs to be turned on or off.
        """
        return pulumi.get(self, "data_key")

    @_builtins.property
    @pulumi.getter(name="dataKeyType")
    def data_key_type(self) -> _builtins.str:
        return pulumi.get(self, "data_key_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of autoactivation in this APM Domain.  If "ON" auto-activate is set to true, if "OFF" auto-activate is set to false.
        """
        return pulumi.get(self, "state")


class AwaitableGetAttributeAutoActivateStatusResult(GetAttributeAutoActivateStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttributeAutoActivateStatusResult(
            apm_domain_id=self.apm_domain_id,
            data_key=self.data_key,
            data_key_type=self.data_key_type,
            id=self.id,
            state=self.state)


def get_attribute_auto_activate_status(apm_domain_id: Optional[_builtins.str] = None,
                                       data_key_type: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttributeAutoActivateStatusResult:
    """
    This data source provides details about a specific Attribute Auto Activate Status resource in Oracle Cloud Infrastructure Apm Traces service.

    Get autoactivation status for a private data key or public data key in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_auto_activate_status = oci.ApmTraces.get_attribute_auto_activate_status(apm_domain_id=test_apm_domain["id"],
        data_key_type=attribute_auto_activate_status_data_key_type)
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str data_key_type: Data key type for which auto-activate needs to be turned on or off.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['dataKeyType'] = data_key_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmTraces/getAttributeAutoActivateStatus:getAttributeAutoActivateStatus', __args__, opts=opts, typ=GetAttributeAutoActivateStatusResult).value

    return AwaitableGetAttributeAutoActivateStatusResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        data_key=pulumi.get(__ret__, 'data_key'),
        data_key_type=pulumi.get(__ret__, 'data_key_type'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_attribute_auto_activate_status_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              data_key_type: Optional[pulumi.Input[_builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAttributeAutoActivateStatusResult]:
    """
    This data source provides details about a specific Attribute Auto Activate Status resource in Oracle Cloud Infrastructure Apm Traces service.

    Get autoactivation status for a private data key or public data key in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_attribute_auto_activate_status = oci.ApmTraces.get_attribute_auto_activate_status(apm_domain_id=test_apm_domain["id"],
        data_key_type=attribute_auto_activate_status_data_key_type)
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str data_key_type: Data key type for which auto-activate needs to be turned on or off.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['dataKeyType'] = data_key_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmTraces/getAttributeAutoActivateStatus:getAttributeAutoActivateStatus', __args__, opts=opts, typ=GetAttributeAutoActivateStatusResult)
    return __ret__.apply(lambda __response__: GetAttributeAutoActivateStatusResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        data_key=pulumi.get(__response__, 'data_key'),
        data_key_type=pulumi.get(__response__, 'data_key_type'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
