# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLogResult',
    'AwaitableGetLogResult',
    'get_log',
    'get_log_output',
]

@pulumi.output_type
class GetLogResult:
    """
    A collection of values returned by getLog.
    """
    def __init__(__self__, apm_domain_id=None, attribute_metadata=None, attributes=None, body=None, event_name=None, id=None, log_key=None, overflow_attributes=None, severity_number=None, severity_text=None, span_key=None, time_created=None, time_log_ended_less_than=None, time_log_started_greater_than_or_equal_to=None, time_observed=None, timestamp=None, trace_flags=None, trace_key=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if attribute_metadata and not isinstance(attribute_metadata, dict):
            raise TypeError("Expected argument 'attribute_metadata' to be a dict")
        pulumi.set(__self__, "attribute_metadata", attribute_metadata)
        if attributes and not isinstance(attributes, list):
            raise TypeError("Expected argument 'attributes' to be a list")
        pulumi.set(__self__, "attributes", attributes)
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if event_name and not isinstance(event_name, str):
            raise TypeError("Expected argument 'event_name' to be a str")
        pulumi.set(__self__, "event_name", event_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_key and not isinstance(log_key, str):
            raise TypeError("Expected argument 'log_key' to be a str")
        pulumi.set(__self__, "log_key", log_key)
        if overflow_attributes and not isinstance(overflow_attributes, str):
            raise TypeError("Expected argument 'overflow_attributes' to be a str")
        pulumi.set(__self__, "overflow_attributes", overflow_attributes)
        if severity_number and not isinstance(severity_number, int):
            raise TypeError("Expected argument 'severity_number' to be a int")
        pulumi.set(__self__, "severity_number", severity_number)
        if severity_text and not isinstance(severity_text, str):
            raise TypeError("Expected argument 'severity_text' to be a str")
        pulumi.set(__self__, "severity_text", severity_text)
        if span_key and not isinstance(span_key, str):
            raise TypeError("Expected argument 'span_key' to be a str")
        pulumi.set(__self__, "span_key", span_key)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_log_ended_less_than and not isinstance(time_log_ended_less_than, str):
            raise TypeError("Expected argument 'time_log_ended_less_than' to be a str")
        pulumi.set(__self__, "time_log_ended_less_than", time_log_ended_less_than)
        if time_log_started_greater_than_or_equal_to and not isinstance(time_log_started_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_log_started_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_log_started_greater_than_or_equal_to", time_log_started_greater_than_or_equal_to)
        if time_observed and not isinstance(time_observed, str):
            raise TypeError("Expected argument 'time_observed' to be a str")
        pulumi.set(__self__, "time_observed", time_observed)
        if timestamp and not isinstance(timestamp, str):
            raise TypeError("Expected argument 'timestamp' to be a str")
        pulumi.set(__self__, "timestamp", timestamp)
        if trace_flags and not isinstance(trace_flags, int):
            raise TypeError("Expected argument 'trace_flags' to be a int")
        pulumi.set(__self__, "trace_flags", trace_flags)
        if trace_key and not isinstance(trace_key, str):
            raise TypeError("Expected argument 'trace_key' to be a str")
        pulumi.set(__self__, "trace_key", trace_key)

    @_builtins.property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> _builtins.str:
        return pulumi.get(self, "apm_domain_id")

    @_builtins.property
    @pulumi.getter(name="attributeMetadata")
    def attribute_metadata(self) -> Mapping[str, _builtins.str]:
        """
        Metadata about the attributes in the logs.
        """
        return pulumi.get(self, "attribute_metadata")

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GetLogAttributeResult']:
        """
        List of attributes associated with the logs.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter
    def body(self) -> _builtins.str:
        """
        Log body (Body).
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="eventName")
    def event_name(self) -> _builtins.str:
        """
        Name of the event.
        """
        return pulumi.get(self, "event_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logKey")
    def log_key(self) -> _builtins.str:
        """
        Unique identifier (logId) for the logKey.  Note that this field is defined as logKey in the API and it maps to the logId in Application Performance Monitoring.
        """
        return pulumi.get(self, "log_key")

    @_builtins.property
    @pulumi.getter(name="overflowAttributes")
    def overflow_attributes(self) -> _builtins.str:
        """
        Full values for attributes that are too long to be stored as a log attribute (Overflow).
        """
        return pulumi.get(self, "overflow_attributes")

    @_builtins.property
    @pulumi.getter(name="severityNumber")
    def severity_number(self) -> _builtins.int:
        """
        Log Severity number (SeverityNumber).
        """
        return pulumi.get(self, "severity_number")

    @_builtins.property
    @pulumi.getter(name="severityText")
    def severity_text(self) -> _builtins.str:
        """
        Log Severity text (SeverityText).  Also known as Log level.
        """
        return pulumi.get(self, "severity_text")

    @_builtins.property
    @pulumi.getter(name="spanKey")
    def span_key(self) -> _builtins.str:
        """
        Unique identifier for the span (spanId) associated with this log.
        """
        return pulumi.get(self, "span_key")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time that the log event occurred (CreatedTime).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeLogEndedLessThan")
    def time_log_ended_less_than(self) -> _builtins.str:
        return pulumi.get(self, "time_log_ended_less_than")

    @_builtins.property
    @pulumi.getter(name="timeLogStartedGreaterThanOrEqualTo")
    def time_log_started_greater_than_or_equal_to(self) -> _builtins.str:
        return pulumi.get(self, "time_log_started_greater_than_or_equal_to")

    @_builtins.property
    @pulumi.getter(name="timeObserved")
    def time_observed(self) -> _builtins.str:
        """
        Time that the log was received by apm (ObservedTime).
        """
        return pulumi.get(self, "time_observed")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> _builtins.str:
        """
        Time used by the time picker (RecordedTime).  Either the timeCreated if present or the timeObserved.
        """
        return pulumi.get(self, "timestamp")

    @_builtins.property
    @pulumi.getter(name="traceFlags")
    def trace_flags(self) -> _builtins.int:
        """
        Trace flags.
        """
        return pulumi.get(self, "trace_flags")

    @_builtins.property
    @pulumi.getter(name="traceKey")
    def trace_key(self) -> _builtins.str:
        """
        Unique identifier for the trace (traceId) associated with this log.
        """
        return pulumi.get(self, "trace_key")


class AwaitableGetLogResult(GetLogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogResult(
            apm_domain_id=self.apm_domain_id,
            attribute_metadata=self.attribute_metadata,
            attributes=self.attributes,
            body=self.body,
            event_name=self.event_name,
            id=self.id,
            log_key=self.log_key,
            overflow_attributes=self.overflow_attributes,
            severity_number=self.severity_number,
            severity_text=self.severity_text,
            span_key=self.span_key,
            time_created=self.time_created,
            time_log_ended_less_than=self.time_log_ended_less_than,
            time_log_started_greater_than_or_equal_to=self.time_log_started_greater_than_or_equal_to,
            time_observed=self.time_observed,
            timestamp=self.timestamp,
            trace_flags=self.trace_flags,
            trace_key=self.trace_key)


def get_log(apm_domain_id: Optional[_builtins.str] = None,
            log_key: Optional[_builtins.str] = None,
            time_log_ended_less_than: Optional[_builtins.str] = None,
            time_log_started_greater_than_or_equal_to: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogResult:
    """
    This data source provides details about a specific Log resource in Oracle Cloud Infrastructure Apm Traces service.

    Retrieve a log in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log = oci.ApmTraces.get_log(apm_domain_id=test_apm_domain["id"],
        log_key=log_log_key,
        time_log_ended_less_than=log_time_log_ended_less_than,
        time_log_started_greater_than_or_equal_to=log_time_log_started_greater_than_or_equal_to)
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str log_key: Log key.
    :param _builtins.str time_log_ended_less_than: Include logs with log time less than this value.
    :param _builtins.str time_log_started_greater_than_or_equal_to: Include logs with log time equal to or greater than this value.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['logKey'] = log_key
    __args__['timeLogEndedLessThan'] = time_log_ended_less_than
    __args__['timeLogStartedGreaterThanOrEqualTo'] = time_log_started_greater_than_or_equal_to
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmTraces/getLog:getLog', __args__, opts=opts, typ=GetLogResult).value

    return AwaitableGetLogResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        attribute_metadata=pulumi.get(__ret__, 'attribute_metadata'),
        attributes=pulumi.get(__ret__, 'attributes'),
        body=pulumi.get(__ret__, 'body'),
        event_name=pulumi.get(__ret__, 'event_name'),
        id=pulumi.get(__ret__, 'id'),
        log_key=pulumi.get(__ret__, 'log_key'),
        overflow_attributes=pulumi.get(__ret__, 'overflow_attributes'),
        severity_number=pulumi.get(__ret__, 'severity_number'),
        severity_text=pulumi.get(__ret__, 'severity_text'),
        span_key=pulumi.get(__ret__, 'span_key'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_log_ended_less_than=pulumi.get(__ret__, 'time_log_ended_less_than'),
        time_log_started_greater_than_or_equal_to=pulumi.get(__ret__, 'time_log_started_greater_than_or_equal_to'),
        time_observed=pulumi.get(__ret__, 'time_observed'),
        timestamp=pulumi.get(__ret__, 'timestamp'),
        trace_flags=pulumi.get(__ret__, 'trace_flags'),
        trace_key=pulumi.get(__ret__, 'trace_key'))
def get_log_output(apm_domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                   log_key: Optional[pulumi.Input[_builtins.str]] = None,
                   time_log_ended_less_than: Optional[pulumi.Input[_builtins.str]] = None,
                   time_log_started_greater_than_or_equal_to: Optional[pulumi.Input[_builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogResult]:
    """
    This data source provides details about a specific Log resource in Oracle Cloud Infrastructure Apm Traces service.

    Retrieve a log in the APM Domain.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log = oci.ApmTraces.get_log(apm_domain_id=test_apm_domain["id"],
        log_key=log_log_key,
        time_log_ended_less_than=log_time_log_ended_less_than,
        time_log_started_greater_than_or_equal_to=log_time_log_started_greater_than_or_equal_to)
    ```


    :param _builtins.str apm_domain_id: The APM Domain ID for the intended request.
    :param _builtins.str log_key: Log key.
    :param _builtins.str time_log_ended_less_than: Include logs with log time less than this value.
    :param _builtins.str time_log_started_greater_than_or_equal_to: Include logs with log time equal to or greater than this value.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['logKey'] = log_key
    __args__['timeLogEndedLessThan'] = time_log_ended_less_than
    __args__['timeLogStartedGreaterThanOrEqualTo'] = time_log_started_greater_than_or_equal_to
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmTraces/getLog:getLog', __args__, opts=opts, typ=GetLogResult)
    return __ret__.apply(lambda __response__: GetLogResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        attribute_metadata=pulumi.get(__response__, 'attribute_metadata'),
        attributes=pulumi.get(__response__, 'attributes'),
        body=pulumi.get(__response__, 'body'),
        event_name=pulumi.get(__response__, 'event_name'),
        id=pulumi.get(__response__, 'id'),
        log_key=pulumi.get(__response__, 'log_key'),
        overflow_attributes=pulumi.get(__response__, 'overflow_attributes'),
        severity_number=pulumi.get(__response__, 'severity_number'),
        severity_text=pulumi.get(__response__, 'severity_text'),
        span_key=pulumi.get(__response__, 'span_key'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_log_ended_less_than=pulumi.get(__response__, 'time_log_ended_less_than'),
        time_log_started_greater_than_or_equal_to=pulumi.get(__response__, 'time_log_started_greater_than_or_equal_to'),
        time_observed=pulumi.get(__response__, 'time_observed'),
        timestamp=pulumi.get(__response__, 'timestamp'),
        trace_flags=pulumi.get(__response__, 'trace_flags'),
        trace_key=pulumi.get(__response__, 'trace_key')))
