# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOccmDemandSignalCatalogResourcesResult',
    'AwaitableGetOccmDemandSignalCatalogResourcesResult',
    'get_occm_demand_signal_catalog_resources',
    'get_occm_demand_signal_catalog_resources_output',
]

@pulumi.output_type
class GetOccmDemandSignalCatalogResourcesResult:
    """
    A collection of values returned by getOccmDemandSignalCatalogResources.
    """
    def __init__(__self__, compartment_id=None, demand_signal_namespace=None, filters=None, id=None, name=None, occm_demand_signal_catalog_resource_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if demand_signal_namespace and not isinstance(demand_signal_namespace, str):
            raise TypeError("Expected argument 'demand_signal_namespace' to be a str")
        pulumi.set(__self__, "demand_signal_namespace", demand_signal_namespace)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if occm_demand_signal_catalog_resource_collections and not isinstance(occm_demand_signal_catalog_resource_collections, list):
            raise TypeError("Expected argument 'occm_demand_signal_catalog_resource_collections' to be a list")
        pulumi.set(__self__, "occm_demand_signal_catalog_resource_collections", occm_demand_signal_catalog_resource_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the tenancy from which the request to create the demand signal was made.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="demandSignalNamespace")
    def demand_signal_namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "demand_signal_namespace")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOccmDemandSignalCatalogResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure resource that you want to request.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="occmDemandSignalCatalogResourceCollections")
    def occm_demand_signal_catalog_resource_collections(self) -> Sequence['outputs.GetOccmDemandSignalCatalogResourcesOccmDemandSignalCatalogResourceCollectionResult']:
        """
        The list of occm_demand_signal_catalog_resource_collection.
        """
        return pulumi.get(self, "occm_demand_signal_catalog_resource_collections")


class AwaitableGetOccmDemandSignalCatalogResourcesResult(GetOccmDemandSignalCatalogResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccmDemandSignalCatalogResourcesResult(
            compartment_id=self.compartment_id,
            demand_signal_namespace=self.demand_signal_namespace,
            filters=self.filters,
            id=self.id,
            name=self.name,
            occm_demand_signal_catalog_resource_collections=self.occm_demand_signal_catalog_resource_collections)


def get_occm_demand_signal_catalog_resources(compartment_id: Optional[_builtins.str] = None,
                                             demand_signal_namespace: Optional[_builtins.str] = None,
                                             filters: Optional[Sequence[Union['GetOccmDemandSignalCatalogResourcesFilterArgs', 'GetOccmDemandSignalCatalogResourcesFilterArgsDict']]] = None,
                                             name: Optional[_builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccmDemandSignalCatalogResourcesResult:
    """
    This data source provides the list of Occm Demand Signal Catalog Resources in Oracle Cloud Infrastructure Capacity Management service.

    This API will list all the  resources across all demand signal catalogs for a given namespace and customer group containing the caller compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occm_demand_signal_catalog_resources = oci.CapacityManagement.get_occm_demand_signal_catalog_resources(compartment_id=compartment_id,
        demand_signal_namespace=occm_demand_signal_catalog_resource_demand_signal_namespace,
        name=occm_demand_signal_catalog_resource_name)
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str demand_signal_namespace: A query parameter to filter the list of demand signal catalog resources based on the namespace.
    :param _builtins.str name: A query parameter to filter the list of demand signal catalog resource based on the resource name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['demandSignalNamespace'] = demand_signal_namespace
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccmDemandSignalCatalogResources:getOccmDemandSignalCatalogResources', __args__, opts=opts, typ=GetOccmDemandSignalCatalogResourcesResult).value

    return AwaitableGetOccmDemandSignalCatalogResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        demand_signal_namespace=pulumi.get(__ret__, 'demand_signal_namespace'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        occm_demand_signal_catalog_resource_collections=pulumi.get(__ret__, 'occm_demand_signal_catalog_resource_collections'))
def get_occm_demand_signal_catalog_resources_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                    demand_signal_namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetOccmDemandSignalCatalogResourcesFilterArgs', 'GetOccmDemandSignalCatalogResourcesFilterArgsDict']]]]] = None,
                                                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccmDemandSignalCatalogResourcesResult]:
    """
    This data source provides the list of Occm Demand Signal Catalog Resources in Oracle Cloud Infrastructure Capacity Management service.

    This API will list all the  resources across all demand signal catalogs for a given namespace and customer group containing the caller compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occm_demand_signal_catalog_resources = oci.CapacityManagement.get_occm_demand_signal_catalog_resources(compartment_id=compartment_id,
        demand_signal_namespace=occm_demand_signal_catalog_resource_demand_signal_namespace,
        name=occm_demand_signal_catalog_resource_name)
    ```


    :param _builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param _builtins.str demand_signal_namespace: A query parameter to filter the list of demand signal catalog resources based on the namespace.
    :param _builtins.str name: A query parameter to filter the list of demand signal catalog resource based on the resource name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['demandSignalNamespace'] = demand_signal_namespace
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccmDemandSignalCatalogResources:getOccmDemandSignalCatalogResources', __args__, opts=opts, typ=GetOccmDemandSignalCatalogResourcesResult)
    return __ret__.apply(lambda __response__: GetOccmDemandSignalCatalogResourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        demand_signal_namespace=pulumi.get(__response__, 'demand_signal_namespace'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        occm_demand_signal_catalog_resource_collections=pulumi.get(__response__, 'occm_demand_signal_catalog_resource_collections')))
