# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificate_configs=None, certificate_id=None, certificate_profile_type=None, certificate_revocation_list_details=None, certificate_rules=None, compartment_id=None, config_type=None, current_versions=None, defined_tags=None, description=None, freeform_tags=None, id=None, issuer_certificate_authority_id=None, key_algorithm=None, lifecycle_details=None, name=None, signature_algorithm=None, state=None, subjects=None, time_created=None, time_of_deletion=None):
        if certificate_configs and not isinstance(certificate_configs, list):
            raise TypeError("Expected argument 'certificate_configs' to be a list")
        pulumi.set(__self__, "certificate_configs", certificate_configs)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_profile_type and not isinstance(certificate_profile_type, str):
            raise TypeError("Expected argument 'certificate_profile_type' to be a str")
        pulumi.set(__self__, "certificate_profile_type", certificate_profile_type)
        if certificate_revocation_list_details and not isinstance(certificate_revocation_list_details, list):
            raise TypeError("Expected argument 'certificate_revocation_list_details' to be a list")
        pulumi.set(__self__, "certificate_revocation_list_details", certificate_revocation_list_details)
        if certificate_rules and not isinstance(certificate_rules, list):
            raise TypeError("Expected argument 'certificate_rules' to be a list")
        pulumi.set(__self__, "certificate_rules", certificate_rules)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_type and not isinstance(config_type, str):
            raise TypeError("Expected argument 'config_type' to be a str")
        pulumi.set(__self__, "config_type", config_type)
        if current_versions and not isinstance(current_versions, list):
            raise TypeError("Expected argument 'current_versions' to be a list")
        pulumi.set(__self__, "current_versions", current_versions)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer_certificate_authority_id and not isinstance(issuer_certificate_authority_id, str):
            raise TypeError("Expected argument 'issuer_certificate_authority_id' to be a str")
        pulumi.set(__self__, "issuer_certificate_authority_id", issuer_certificate_authority_id)
        if key_algorithm and not isinstance(key_algorithm, str):
            raise TypeError("Expected argument 'key_algorithm' to be a str")
        pulumi.set(__self__, "key_algorithm", key_algorithm)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if signature_algorithm and not isinstance(signature_algorithm, str):
            raise TypeError("Expected argument 'signature_algorithm' to be a str")
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subjects and not isinstance(subjects, list):
            raise TypeError("Expected argument 'subjects' to be a list")
        pulumi.set(__self__, "subjects", subjects)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_of_deletion and not isinstance(time_of_deletion, str):
            raise TypeError("Expected argument 'time_of_deletion' to be a str")
        pulumi.set(__self__, "time_of_deletion", time_of_deletion)

    @_builtins.property
    @pulumi.getter(name="certificateConfigs")
    def certificate_configs(self) -> Sequence['outputs.GetCertificateCertificateConfigResult']:
        return pulumi.get(self, "certificate_configs")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        """
        The OCID of the certificate.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="certificateProfileType")
    def certificate_profile_type(self) -> _builtins.str:
        """
        The name of the profile used to create the certificate, which depends on the type of certificate you need.
        """
        return pulumi.get(self, "certificate_profile_type")

    @_builtins.property
    @pulumi.getter(name="certificateRevocationListDetails")
    def certificate_revocation_list_details(self) -> Sequence['outputs.GetCertificateCertificateRevocationListDetailResult']:
        """
        The details of the certificate revocation list (CRL).
        """
        return pulumi.get(self, "certificate_revocation_list_details")

    @_builtins.property
    @pulumi.getter(name="certificateRules")
    def certificate_rules(self) -> Sequence['outputs.GetCertificateCertificateRuleResult']:
        """
        A list of rules that control how the certificate is used and managed.
        """
        return pulumi.get(self, "certificate_rules")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment where you want to create the certificate.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configType")
    def config_type(self) -> _builtins.str:
        """
        The origin of the certificate.
        """
        return pulumi.get(self, "config_type")

    @_builtins.property
    @pulumi.getter(name="currentVersions")
    def current_versions(self) -> Sequence['outputs.GetCertificateCurrentVersionResult']:
        """
        The details of the certificate version. This object does not contain the certificate contents.
        """
        return pulumi.get(self, "current_versions")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        A brief description of the certificate. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the certificate.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issuerCertificateAuthorityId")
    def issuer_certificate_authority_id(self) -> _builtins.str:
        """
        The OCID of the certificate authority (CA) that issued the certificate.
        """
        return pulumi.get(self, "issuer_certificate_authority_id")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> _builtins.str:
        """
        The algorithm used to create key pairs.
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state of the certificate.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A user-friendly name for the certificate. Names are unique within a compartment. Avoid entering confidential information. Valid characters are uppercase or lowercase letters, numbers, hyphens, underscores, and periods.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> _builtins.str:
        """
        The algorithm used to sign the public key certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the certificate.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def subjects(self) -> Sequence['outputs.GetCertificateSubjectResult']:
        """
        The subject of the certificate, which is a distinguished name that identifies the entity that owns the public key in the certificate.
        """
        return pulumi.get(self, "subjects")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        A property indicating when the certificate was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> _builtins.str:
        """
        An optional property indicating when to delete the certificate version, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2019-04-03T21:10:29.600Z`
        """
        return pulumi.get(self, "time_of_deletion")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate_configs=self.certificate_configs,
            certificate_id=self.certificate_id,
            certificate_profile_type=self.certificate_profile_type,
            certificate_revocation_list_details=self.certificate_revocation_list_details,
            certificate_rules=self.certificate_rules,
            compartment_id=self.compartment_id,
            config_type=self.config_type,
            current_versions=self.current_versions,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            issuer_certificate_authority_id=self.issuer_certificate_authority_id,
            key_algorithm=self.key_algorithm,
            lifecycle_details=self.lifecycle_details,
            name=self.name,
            signature_algorithm=self.signature_algorithm,
            state=self.state,
            subjects=self.subjects,
            time_created=self.time_created,
            time_of_deletion=self.time_of_deletion)


def get_certificate(certificate_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    This data source provides details about a specific Certificate resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate = oci.CertificatesManagement.get_certificate(certificate_id=test_certificate_oci_certificates_management_certificate["id"])
    ```


    :param _builtins.str certificate_id: The OCID of the certificate.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CertificatesManagement/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate_configs=pulumi.get(__ret__, 'certificate_configs'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        certificate_profile_type=pulumi.get(__ret__, 'certificate_profile_type'),
        certificate_revocation_list_details=pulumi.get(__ret__, 'certificate_revocation_list_details'),
        certificate_rules=pulumi.get(__ret__, 'certificate_rules'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_type=pulumi.get(__ret__, 'config_type'),
        current_versions=pulumi.get(__ret__, 'current_versions'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        issuer_certificate_authority_id=pulumi.get(__ret__, 'issuer_certificate_authority_id'),
        key_algorithm=pulumi.get(__ret__, 'key_algorithm'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        name=pulumi.get(__ret__, 'name'),
        signature_algorithm=pulumi.get(__ret__, 'signature_algorithm'),
        state=pulumi.get(__ret__, 'state'),
        subjects=pulumi.get(__ret__, 'subjects'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_of_deletion=pulumi.get(__ret__, 'time_of_deletion'))
def get_certificate_output(certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    This data source provides details about a specific Certificate resource in Oracle Cloud Infrastructure Certificates Management service.

    Gets details about the specified certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_certificate = oci.CertificatesManagement.get_certificate(certificate_id=test_certificate_oci_certificates_management_certificate["id"])
    ```


    :param _builtins.str certificate_id: The OCID of the certificate.
    """
    __args__ = dict()
    __args__['certificateId'] = certificate_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CertificatesManagement/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        certificate_configs=pulumi.get(__response__, 'certificate_configs'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        certificate_profile_type=pulumi.get(__response__, 'certificate_profile_type'),
        certificate_revocation_list_details=pulumi.get(__response__, 'certificate_revocation_list_details'),
        certificate_rules=pulumi.get(__response__, 'certificate_rules'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        config_type=pulumi.get(__response__, 'config_type'),
        current_versions=pulumi.get(__response__, 'current_versions'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        issuer_certificate_authority_id=pulumi.get(__response__, 'issuer_certificate_authority_id'),
        key_algorithm=pulumi.get(__response__, 'key_algorithm'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        name=pulumi.get(__response__, 'name'),
        signature_algorithm=pulumi.get(__response__, 'signature_algorithm'),
        state=pulumi.get(__response__, 'state'),
        subjects=pulumi.get(__response__, 'subjects'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_of_deletion=pulumi.get(__response__, 'time_of_deletion')))
