# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAssetResult',
    'AwaitableGetAssetResult',
    'get_asset',
    'get_asset_output',
]

@pulumi.output_type
class GetAssetResult:
    """
    A collection of values returned by getAsset.
    """
    def __init__(__self__, asset_id=None, asset_source_ids=None, asset_type=None, compartment_id=None, computes=None, defined_tags=None, display_name=None, external_asset_key=None, freeform_tags=None, id=None, inventory_id=None, source_key=None, state=None, system_tags=None, time_created=None, time_updated=None, vms=None, vmware_vcenters=None, vmware_vms=None):
        if asset_id and not isinstance(asset_id, str):
            raise TypeError("Expected argument 'asset_id' to be a str")
        pulumi.set(__self__, "asset_id", asset_id)
        if asset_source_ids and not isinstance(asset_source_ids, list):
            raise TypeError("Expected argument 'asset_source_ids' to be a list")
        pulumi.set(__self__, "asset_source_ids", asset_source_ids)
        if asset_type and not isinstance(asset_type, str):
            raise TypeError("Expected argument 'asset_type' to be a str")
        pulumi.set(__self__, "asset_type", asset_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if computes and not isinstance(computes, list):
            raise TypeError("Expected argument 'computes' to be a list")
        pulumi.set(__self__, "computes", computes)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_asset_key and not isinstance(external_asset_key, str):
            raise TypeError("Expected argument 'external_asset_key' to be a str")
        pulumi.set(__self__, "external_asset_key", external_asset_key)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inventory_id and not isinstance(inventory_id, str):
            raise TypeError("Expected argument 'inventory_id' to be a str")
        pulumi.set(__self__, "inventory_id", inventory_id)
        if source_key and not isinstance(source_key, str):
            raise TypeError("Expected argument 'source_key' to be a str")
        pulumi.set(__self__, "source_key", source_key)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if vms and not isinstance(vms, list):
            raise TypeError("Expected argument 'vms' to be a list")
        pulumi.set(__self__, "vms", vms)
        if vmware_vcenters and not isinstance(vmware_vcenters, list):
            raise TypeError("Expected argument 'vmware_vcenters' to be a list")
        pulumi.set(__self__, "vmware_vcenters", vmware_vcenters)
        if vmware_vms and not isinstance(vmware_vms, list):
            raise TypeError("Expected argument 'vmware_vms' to be a list")
        pulumi.set(__self__, "vmware_vms", vmware_vms)

    @_builtins.property
    @pulumi.getter(name="assetId")
    def asset_id(self) -> _builtins.str:
        return pulumi.get(self, "asset_id")

    @_builtins.property
    @pulumi.getter(name="assetSourceIds")
    def asset_source_ids(self) -> Sequence[_builtins.str]:
        """
        List of asset source OCID.
        """
        return pulumi.get(self, "asset_source_ids")

    @_builtins.property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> _builtins.str:
        """
        The type of asset.
        """
        return pulumi.get(self, "asset_type")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment to which an asset belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def computes(self) -> Sequence['outputs.GetAssetComputeResult']:
        """
        Compute related properties.
        """
        return pulumi.get(self, "computes")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Asset display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalAssetKey")
    def external_asset_key(self) -> _builtins.str:
        """
        The key of the asset from the external environment.
        """
        return pulumi.get(self, "external_asset_key")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Asset OCID that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inventoryId")
    def inventory_id(self) -> _builtins.str:
        """
        Inventory ID to which an asset belongs to.
        """
        return pulumi.get(self, "inventory_id")

    @_builtins.property
    @pulumi.getter(name="sourceKey")
    def source_key(self) -> _builtins.str:
        """
        The source key that the asset belongs to.
        """
        return pulumi.get(self, "source_key")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the asset.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle cloud infrastructure services. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def vms(self) -> Sequence['outputs.GetAssetVmResult']:
        """
        Virtual machine related properties.
        """
        return pulumi.get(self, "vms")

    @_builtins.property
    @pulumi.getter(name="vmwareVcenters")
    def vmware_vcenters(self) -> Sequence['outputs.GetAssetVmwareVcenterResult']:
        """
        VMware vCenter related properties.
        """
        return pulumi.get(self, "vmware_vcenters")

    @_builtins.property
    @pulumi.getter(name="vmwareVms")
    def vmware_vms(self) -> Sequence['outputs.GetAssetVmwareVmResult']:
        """
        VMware virtual machine related properties.
        """
        return pulumi.get(self, "vmware_vms")


class AwaitableGetAssetResult(GetAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssetResult(
            asset_id=self.asset_id,
            asset_source_ids=self.asset_source_ids,
            asset_type=self.asset_type,
            compartment_id=self.compartment_id,
            computes=self.computes,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            external_asset_key=self.external_asset_key,
            freeform_tags=self.freeform_tags,
            id=self.id,
            inventory_id=self.inventory_id,
            source_key=self.source_key,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            vms=self.vms,
            vmware_vcenters=self.vmware_vcenters,
            vmware_vms=self.vmware_vms)


def get_asset(asset_id: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssetResult:
    """
    This data source provides details about a specific Asset resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets an asset by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_asset = oci.CloudBridge.get_asset(asset_id=test_asset_oci_cloud_bridge_asset["id"])
    ```


    :param _builtins.str asset_id: Unique asset identifier.
    """
    __args__ = dict()
    __args__['assetId'] = asset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudBridge/getAsset:getAsset', __args__, opts=opts, typ=GetAssetResult).value

    return AwaitableGetAssetResult(
        asset_id=pulumi.get(__ret__, 'asset_id'),
        asset_source_ids=pulumi.get(__ret__, 'asset_source_ids'),
        asset_type=pulumi.get(__ret__, 'asset_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        computes=pulumi.get(__ret__, 'computes'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_asset_key=pulumi.get(__ret__, 'external_asset_key'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        inventory_id=pulumi.get(__ret__, 'inventory_id'),
        source_key=pulumi.get(__ret__, 'source_key'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        vms=pulumi.get(__ret__, 'vms'),
        vmware_vcenters=pulumi.get(__ret__, 'vmware_vcenters'),
        vmware_vms=pulumi.get(__ret__, 'vmware_vms'))
def get_asset_output(asset_id: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAssetResult]:
    """
    This data source provides details about a specific Asset resource in Oracle Cloud Infrastructure Cloud Bridge service.

    Gets an asset by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_asset = oci.CloudBridge.get_asset(asset_id=test_asset_oci_cloud_bridge_asset["id"])
    ```


    :param _builtins.str asset_id: Unique asset identifier.
    """
    __args__ = dict()
    __args__['assetId'] = asset_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudBridge/getAsset:getAsset', __args__, opts=opts, typ=GetAssetResult)
    return __ret__.apply(lambda __response__: GetAssetResult(
        asset_id=pulumi.get(__response__, 'asset_id'),
        asset_source_ids=pulumi.get(__response__, 'asset_source_ids'),
        asset_type=pulumi.get(__response__, 'asset_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        computes=pulumi.get(__response__, 'computes'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_asset_key=pulumi.get(__response__, 'external_asset_key'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        inventory_id=pulumi.get(__response__, 'inventory_id'),
        source_key=pulumi.get(__response__, 'source_key'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        vms=pulumi.get(__response__, 'vms'),
        vmware_vcenters=pulumi.get(__response__, 'vmware_vcenters'),
        vmware_vms=pulumi.get(__response__, 'vmware_vms')))
