# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataSourceEventResult',
    'AwaitableGetDataSourceEventResult',
    'get_data_source_event',
    'get_data_source_event_output',
]

@pulumi.output_type
class GetDataSourceEventResult:
    """
    A collection of values returned by getDataSourceEvent.
    """
    def __init__(__self__, data_source_id=None, id=None, items=None, region=None):
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> _builtins.str:
        """
        Attached data Source
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDataSourceEventItemResult']:
        """
        List of event related to a DataSource
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Data source event region
        """
        return pulumi.get(self, "region")


class AwaitableGetDataSourceEventResult(GetDataSourceEventResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceEventResult(
            data_source_id=self.data_source_id,
            id=self.id,
            items=self.items,
            region=self.region)


def get_data_source_event(data_source_id: Optional[_builtins.str] = None,
                          region: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceEventResult:
    """
    This data source provides details about a specific Data Source Event resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of events from CloudGuard DataSource

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_source_event = oci.CloudGuard.get_data_source_event(data_source_id=test_data_source["id"],
        region=data_source_event_region)
    ```


    :param _builtins.str data_source_id: DataSource OCID
    :param _builtins.str region: A filter to return only resource their region matches the given region.
    """
    __args__ = dict()
    __args__['dataSourceId'] = data_source_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDataSourceEvent:getDataSourceEvent', __args__, opts=opts, typ=GetDataSourceEventResult).value

    return AwaitableGetDataSourceEventResult(
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        region=pulumi.get(__ret__, 'region'))
def get_data_source_event_output(data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                                 region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSourceEventResult]:
    """
    This data source provides details about a specific Data Source Event resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of events from CloudGuard DataSource

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_source_event = oci.CloudGuard.get_data_source_event(data_source_id=test_data_source["id"],
        region=data_source_event_region)
    ```


    :param _builtins.str data_source_id: DataSource OCID
    :param _builtins.str region: A filter to return only resource their region matches the given region.
    """
    __args__ = dict()
    __args__['dataSourceId'] = data_source_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getDataSourceEvent:getDataSourceEvent', __args__, opts=opts, typ=GetDataSourceEventResult)
    return __ret__.apply(lambda __response__: GetDataSourceEventResult(
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        region=pulumi.get(__response__, 'region')))
