# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterStartCredentialRotationManagementArgs', 'ClusterStartCredentialRotationManagement']

@pulumi.input_type
class ClusterStartCredentialRotationManagementArgs:
    def __init__(__self__, *,
                 auto_completion_delay_duration: pulumi.Input[_builtins.str],
                 cluster_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ClusterStartCredentialRotationManagement resource.
        :param pulumi.Input[_builtins.str] auto_completion_delay_duration: The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "auto_completion_delay_duration", auto_completion_delay_duration)
        pulumi.set(__self__, "cluster_id", cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoCompletionDelayDuration")
    def auto_completion_delay_duration(self) -> pulumi.Input[_builtins.str]:
        """
        The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        """
        return pulumi.get(self, "auto_completion_delay_duration")

    @auto_completion_delay_duration.setter
    def auto_completion_delay_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "auto_completion_delay_duration", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_id", value)


@pulumi.input_type
class _ClusterStartCredentialRotationManagementState:
    def __init__(__self__, *,
                 auto_completion_delay_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterStartCredentialRotationManagement resources.
        :param pulumi.Input[_builtins.str] auto_completion_delay_duration: The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if auto_completion_delay_duration is not None:
            pulumi.set(__self__, "auto_completion_delay_duration", auto_completion_delay_duration)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)

    @_builtins.property
    @pulumi.getter(name="autoCompletionDelayDuration")
    def auto_completion_delay_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        """
        return pulumi.get(self, "auto_completion_delay_duration")

    @auto_completion_delay_duration.setter
    def auto_completion_delay_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_completion_delay_duration", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)


@pulumi.type_token("oci:ContainerEngine/clusterStartCredentialRotationManagement:ClusterStartCredentialRotationManagement")
class ClusterStartCredentialRotationManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_completion_delay_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Cluster Start Credential Rotation Management resource in Oracle Cloud Infrastructure Container Engine service.

        Start cluster credential rotation by adding new credentials, old credentials will still work after this operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster_start_credential_rotation_management = oci.containerengine.ClusterStartCredentialRotationManagement("test_cluster_start_credential_rotation_management",
            auto_completion_delay_duration=cluster_start_credential_rotation_management_auto_completion_delay_duration,
            cluster_id=test_cluster["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_completion_delay_duration: The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterStartCredentialRotationManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cluster Start Credential Rotation Management resource in Oracle Cloud Infrastructure Container Engine service.

        Start cluster credential rotation by adding new credentials, old credentials will still work after this operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster_start_credential_rotation_management = oci.containerengine.ClusterStartCredentialRotationManagement("test_cluster_start_credential_rotation_management",
            auto_completion_delay_duration=cluster_start_credential_rotation_management_auto_completion_delay_duration,
            cluster_id=test_cluster["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ClusterStartCredentialRotationManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterStartCredentialRotationManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_completion_delay_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterStartCredentialRotationManagementArgs.__new__(ClusterStartCredentialRotationManagementArgs)

            if auto_completion_delay_duration is None and not opts.urn:
                raise TypeError("Missing required property 'auto_completion_delay_duration'")
            __props__.__dict__["auto_completion_delay_duration"] = auto_completion_delay_duration
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
        super(ClusterStartCredentialRotationManagement, __self__).__init__(
            'oci:ContainerEngine/clusterStartCredentialRotationManagement:ClusterStartCredentialRotationManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_completion_delay_duration: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClusterStartCredentialRotationManagement':
        """
        Get an existing ClusterStartCredentialRotationManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_completion_delay_duration: The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        :param pulumi.Input[_builtins.str] cluster_id: The OCID of the cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterStartCredentialRotationManagementState.__new__(_ClusterStartCredentialRotationManagementState)

        __props__.__dict__["auto_completion_delay_duration"] = auto_completion_delay_duration
        __props__.__dict__["cluster_id"] = cluster_id
        return ClusterStartCredentialRotationManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCompletionDelayDuration")
    def auto_completion_delay_duration(self) -> pulumi.Output[_builtins.str]:
        """
        The duration in days(in ISO 8601 notation eg. P5D) after which the old credentials should be retired. Maximum delay duration is 14 days.
        """
        return pulumi.get(self, "auto_completion_delay_duration")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "cluster_id")

