# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerInstanceShapesResult',
    'AwaitableGetContainerInstanceShapesResult',
    'get_container_instance_shapes',
    'get_container_instance_shapes_output',
]

@pulumi.output_type
class GetContainerInstanceShapesResult:
    """
    A collection of values returned by getContainerInstanceShapes.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, container_instance_shape_collections=None, filters=None, id=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if container_instance_shape_collections and not isinstance(container_instance_shape_collections, list):
            raise TypeError("Expected argument 'container_instance_shape_collections' to be a list")
        pulumi.set(__self__, "container_instance_shape_collections", container_instance_shape_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="containerInstanceShapeCollections")
    def container_instance_shape_collections(self) -> Sequence['outputs.GetContainerInstanceShapesContainerInstanceShapeCollectionResult']:
        """
        The list of container_instance_shape_collection.
        """
        return pulumi.get(self, "container_instance_shape_collections")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetContainerInstanceShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetContainerInstanceShapesResult(GetContainerInstanceShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerInstanceShapesResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            container_instance_shape_collections=self.container_instance_shape_collections,
            filters=self.filters,
            id=self.id)


def get_container_instance_shapes(availability_domain: Optional[_builtins.str] = None,
                                  compartment_id: Optional[_builtins.str] = None,
                                  filters: Optional[Sequence[Union['GetContainerInstanceShapesFilterArgs', 'GetContainerInstanceShapesFilterArgsDict']]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerInstanceShapesResult:
    """
    This data source provides the list of Container Instance Shapes in Oracle Cloud Infrastructure Container Instances service.

    Lists the shapes that can be used to create container instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_instance_shapes = oci.ContainerInstances.get_container_instance_shapes(compartment_id=compartment_id,
        availability_domain=container_instance_shape_availability_domain)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerInstances/getContainerInstanceShapes:getContainerInstanceShapes', __args__, opts=opts, typ=GetContainerInstanceShapesResult).value

    return AwaitableGetContainerInstanceShapesResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        container_instance_shape_collections=pulumi.get(__ret__, 'container_instance_shape_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_container_instance_shapes_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                         compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetContainerInstanceShapesFilterArgs', 'GetContainerInstanceShapesFilterArgsDict']]]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerInstanceShapesResult]:
    """
    This data source provides the list of Container Instance Shapes in Oracle Cloud Infrastructure Container Instances service.

    Lists the shapes that can be used to create container instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_instance_shapes = oci.ContainerInstances.get_container_instance_shapes(compartment_id=compartment_id,
        availability_domain=container_instance_shape_availability_domain)
    ```


    :param _builtins.str availability_domain: The name of the availability domain.  Example: `Uocm:PHX-AD-1`
    :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerInstances/getContainerInstanceShapes:getContainerInstanceShapes', __args__, opts=opts, typ=GetContainerInstanceShapesResult)
    return __ret__.apply(lambda __response__: GetContainerInstanceShapesResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        container_instance_shape_collections=pulumi.get(__response__, 'container_instance_shape_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
