# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ComputeGpuMemoryClusterArgs', 'ComputeGpuMemoryCluster']

@pulumi.input_type
class ComputeGpuMemoryClusterArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 compute_cluster_id: pulumi.Input[_builtins.str],
                 instance_configuration_id: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeGpuMemoryCluster resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the GPU memory cluster.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        :param pulumi.Input[_builtins.str] instance_configuration_id: (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gpu_memory_fabric_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        :param pulumi.Input[_builtins.str] size: (Updatable) The number of instances currently running in the GpuMemoryCluster 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpu_memory_fabric_id is not None:
            pulumi.set(__self__, "gpu_memory_fabric_id", gpu_memory_fabric_id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The availability domain of the GPU memory cluster.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="gpuMemoryFabricId")
    def gpu_memory_fabric_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        """
        return pulumi.get(self, "gpu_memory_fabric_id")

    @gpu_memory_fabric_id.setter
    def gpu_memory_fabric_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_memory_fabric_id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The number of instances currently running in the GpuMemoryCluster 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class _ComputeGpuMemoryClusterState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeGpuMemoryCluster resources.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the GPU memory cluster.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gpu_memory_fabric_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        :param pulumi.Input[_builtins.str] instance_configuration_id: (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        :param pulumi.Input[_builtins.str] size: (Updatable) The number of instances currently running in the GpuMemoryCluster 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The lifecycle state of the GPU memory cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the GPU memory cluster was created.  Example: `2016-09-15T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpu_memory_fabric_id is not None:
            pulumi.set(__self__, "gpu_memory_fabric_id", gpu_memory_fabric_id)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain of the GPU memory cluster.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="gpuMemoryFabricId")
    def gpu_memory_fabric_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        """
        return pulumi.get(self, "gpu_memory_fabric_id")

    @gpu_memory_fabric_id.setter
    def gpu_memory_fabric_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gpu_memory_fabric_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The number of instances currently running in the GpuMemoryCluster 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lifecycle state of the GPU memory cluster
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the GPU memory cluster was created.  Example: `2016-09-15T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)


@pulumi.type_token("oci:Core/computeGpuMemoryCluster:ComputeGpuMemoryCluster")
class ComputeGpuMemoryCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Compute Gpu Memory Cluster resource in Oracle Cloud Infrastructure Core service.

        Create a compute GPU memory cluster instance on a specific compute GPU memory fabric

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_compute_gpu_memory_cluster = oci.core.ComputeGpuMemoryCluster("test_compute_gpu_memory_cluster",
            availability_domain=compute_gpu_memory_cluster_availability_domain,
            compartment_id=compartment_id,
            compute_cluster_id=test_compute_cluster["id"],
            instance_configuration_id=test_instance_configuration["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=compute_gpu_memory_cluster_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            gpu_memory_fabric_id=test_gpu_memory_fabric["id"],
            size=compute_gpu_memory_cluster_size)
        ```

        ## Import

        ComputeGpuMemoryClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeGpuMemoryCluster:ComputeGpuMemoryCluster test_compute_gpu_memory_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the GPU memory cluster.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gpu_memory_fabric_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        :param pulumi.Input[_builtins.str] instance_configuration_id: (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        :param pulumi.Input[_builtins.str] size: (Updatable) The number of instances currently running in the GpuMemoryCluster 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeGpuMemoryClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Compute Gpu Memory Cluster resource in Oracle Cloud Infrastructure Core service.

        Create a compute GPU memory cluster instance on a specific compute GPU memory fabric

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_compute_gpu_memory_cluster = oci.core.ComputeGpuMemoryCluster("test_compute_gpu_memory_cluster",
            availability_domain=compute_gpu_memory_cluster_availability_domain,
            compartment_id=compartment_id,
            compute_cluster_id=test_compute_cluster["id"],
            instance_configuration_id=test_instance_configuration["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=compute_gpu_memory_cluster_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            gpu_memory_fabric_id=test_gpu_memory_fabric["id"],
            size=compute_gpu_memory_cluster_size)
        ```

        ## Import

        ComputeGpuMemoryClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/computeGpuMemoryCluster:ComputeGpuMemoryCluster test_compute_gpu_memory_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ComputeGpuMemoryClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeGpuMemoryClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeGpuMemoryClusterArgs.__new__(ComputeGpuMemoryClusterArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if compute_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_cluster_id'")
            __props__.__dict__["compute_cluster_id"] = compute_cluster_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["gpu_memory_fabric_id"] = gpu_memory_fabric_id
            if instance_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_configuration_id'")
            __props__.__dict__["instance_configuration_id"] = instance_configuration_id
            __props__.__dict__["size"] = size
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(ComputeGpuMemoryCluster, __self__).__init__(
            'oci:Core/computeGpuMemoryCluster:ComputeGpuMemoryCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            gpu_memory_fabric_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeGpuMemoryCluster':
        """
        Get an existing ComputeGpuMemoryCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the GPU memory cluster.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] gpu_memory_fabric_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        :param pulumi.Input[_builtins.str] instance_configuration_id: (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        :param pulumi.Input[_builtins.str] size: (Updatable) The number of instances currently running in the GpuMemoryCluster 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The lifecycle state of the GPU memory cluster
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the GPU memory cluster was created.  Example: `2016-09-15T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeGpuMemoryClusterState.__new__(_ComputeGpuMemoryClusterState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_cluster_id"] = compute_cluster_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gpu_memory_fabric_id"] = gpu_memory_fabric_id
        __props__.__dict__["instance_configuration_id"] = instance_configuration_id
        __props__.__dict__["size"] = size
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        return ComputeGpuMemoryCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain of the GPU memory cluster.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster. compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gpuMemoryFabricId")
    def gpu_memory_fabric_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        """
        return pulumi.get(self, "gpu_memory_fabric_id")

    @_builtins.property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Instance Configuration to be used for this GPU Memory Cluster
        """
        return pulumi.get(self, "instance_configuration_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The number of instances currently running in the GpuMemoryCluster 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The lifecycle state of the GPU memory cluster
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the GPU memory cluster was created.  Example: `2016-09-15T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

