# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DedicatedVmHostArgs', 'DedicatedVmHost']

@pulumi.input_type
class DedicatedVmHostArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 dedicated_vm_host_shape: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 placement_constraint_details: Optional[pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs']] = None):
        """
        The set of arguments for constructing a DedicatedVmHost resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[_builtins.str] dedicated_vm_host_shape: The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fault_domain: The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.
               
               To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs'] placement_constraint_details: Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "dedicated_vm_host_shape", dedicated_vm_host_shape)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if placement_constraint_details is not None:
            pulumi.set(__self__, "placement_constraint_details", placement_constraint_details)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[_builtins.str]:
        """
        The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedVmHostShape")
    def dedicated_vm_host_shape(self) -> pulumi.Input[_builtins.str]:
        """
        The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        """
        return pulumi.get(self, "dedicated_vm_host_shape")

    @dedicated_vm_host_shape.setter
    def dedicated_vm_host_shape(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dedicated_vm_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.

        To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="placementConstraintDetails")
    def placement_constraint_details(self) -> Optional[pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs']]:
        """
        Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        """
        return pulumi.get(self, "placement_constraint_details")

    @placement_constraint_details.setter
    def placement_constraint_details(self, value: Optional[pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs']]):
        pulumi.set(self, "placement_constraint_details", value)


@pulumi.input_type
class _DedicatedVmHostState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 capacity_bins: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVmHostCapacityBinArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_bare_metal_host_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_vm_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 placement_constraint_details: Optional[pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs']] = None,
                 remaining_memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 remaining_ocpus: Optional[pulumi.Input[_builtins.float]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 total_memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
                 total_ocpus: Optional[pulumi.Input[_builtins.float]] = None):
        """
        Input properties used for looking up and filtering DedicatedVmHost resources.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedVmHostCapacityBinArgs']]] capacity_bins: A list of total and remaining CPU & memory per capacity bucket.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[_builtins.str] compute_bare_metal_host_id: The OCID of the compute bare metal host.
        :param pulumi.Input[_builtins.str] dedicated_vm_host_shape: The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fault_domain: The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.
               
               To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs'] placement_constraint_details: Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        :param pulumi.Input[_builtins.float] remaining_memory_in_gbs: The current available memory of the dedicated VM host, in GBs.
        :param pulumi.Input[_builtins.float] remaining_ocpus: The current available OCPUs of the dedicated VM host.
        :param pulumi.Input[_builtins.str] state: The current state of the dedicated VM host.
        :param pulumi.Input[_builtins.str] time_created: The date and time the dedicated VM host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.float] total_memory_in_gbs: The current total memory of the dedicated VM host, in GBs.
        :param pulumi.Input[_builtins.float] total_ocpus: The current total OCPUs of the dedicated VM host.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_bins is not None:
            pulumi.set(__self__, "capacity_bins", capacity_bins)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_bare_metal_host_id is not None:
            pulumi.set(__self__, "compute_bare_metal_host_id", compute_bare_metal_host_id)
        if dedicated_vm_host_shape is not None:
            pulumi.set(__self__, "dedicated_vm_host_shape", dedicated_vm_host_shape)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if placement_constraint_details is not None:
            pulumi.set(__self__, "placement_constraint_details", placement_constraint_details)
        if remaining_memory_in_gbs is not None:
            pulumi.set(__self__, "remaining_memory_in_gbs", remaining_memory_in_gbs)
        if remaining_ocpus is not None:
            pulumi.set(__self__, "remaining_ocpus", remaining_ocpus)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if total_memory_in_gbs is not None:
            pulumi.set(__self__, "total_memory_in_gbs", total_memory_in_gbs)
        if total_ocpus is not None:
            pulumi.set(__self__, "total_ocpus", total_ocpus)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @_builtins.property
    @pulumi.getter(name="capacityBins")
    def capacity_bins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVmHostCapacityBinArgs']]]]:
        """
        A list of total and remaining CPU & memory per capacity bucket.
        """
        return pulumi.get(self, "capacity_bins")

    @capacity_bins.setter
    def capacity_bins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVmHostCapacityBinArgs']]]]):
        pulumi.set(self, "capacity_bins", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="computeBareMetalHostId")
    def compute_bare_metal_host_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the compute bare metal host.
        """
        return pulumi.get(self, "compute_bare_metal_host_id")

    @compute_bare_metal_host_id.setter
    def compute_bare_metal_host_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_bare_metal_host_id", value)

    @_builtins.property
    @pulumi.getter(name="dedicatedVmHostShape")
    def dedicated_vm_host_shape(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        """
        return pulumi.get(self, "dedicated_vm_host_shape")

    @dedicated_vm_host_shape.setter
    def dedicated_vm_host_shape(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dedicated_vm_host_shape", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.

        To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="placementConstraintDetails")
    def placement_constraint_details(self) -> Optional[pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs']]:
        """
        Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        """
        return pulumi.get(self, "placement_constraint_details")

    @placement_constraint_details.setter
    def placement_constraint_details(self, value: Optional[pulumi.Input['DedicatedVmHostPlacementConstraintDetailsArgs']]):
        pulumi.set(self, "placement_constraint_details", value)

    @_builtins.property
    @pulumi.getter(name="remainingMemoryInGbs")
    def remaining_memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The current available memory of the dedicated VM host, in GBs.
        """
        return pulumi.get(self, "remaining_memory_in_gbs")

    @remaining_memory_in_gbs.setter
    def remaining_memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "remaining_memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="remainingOcpus")
    def remaining_ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The current available OCPUs of the dedicated VM host.
        """
        return pulumi.get(self, "remaining_ocpus")

    @remaining_ocpus.setter
    def remaining_ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "remaining_ocpus", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the dedicated VM host.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the dedicated VM host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="totalMemoryInGbs")
    def total_memory_in_gbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The current total memory of the dedicated VM host, in GBs.
        """
        return pulumi.get(self, "total_memory_in_gbs")

    @total_memory_in_gbs.setter
    def total_memory_in_gbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "total_memory_in_gbs", value)

    @_builtins.property
    @pulumi.getter(name="totalOcpus")
    def total_ocpus(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The current total OCPUs of the dedicated VM host.
        """
        return pulumi.get(self, "total_ocpus")

    @total_ocpus.setter
    def total_ocpus(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "total_ocpus", value)


@pulumi.type_token("oci:Core/dedicatedVmHost:DedicatedVmHost")
class DedicatedVmHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_vm_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 placement_constraint_details: Optional[pulumi.Input[Union['DedicatedVmHostPlacementConstraintDetailsArgs', 'DedicatedVmHostPlacementConstraintDetailsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Dedicated Vm Host resource in Oracle Cloud Infrastructure Core service.

        Creates a new dedicated virtual machine host in the specified compartment and the specified availability domain.
        Dedicated virtual machine hosts enable you to run your Compute virtual machine (VM) instances on dedicated servers
        that are a single tenant and not shared with other customers.
        For more information, see [Dedicated Virtual Machine Hosts](https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/dedicatedvmhosts.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dedicated_vm_host = oci.core.DedicatedVmHost("test_dedicated_vm_host",
            availability_domain=dedicated_vm_host_availability_domain,
            compartment_id=compartment_id,
            dedicated_vm_host_shape=dedicated_vm_host_dedicated_vm_host_shape,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=dedicated_vm_host_display_name,
            fault_domain=dedicated_vm_host_fault_domain,
            freeform_tags={
                "Department": "Finance",
            },
            placement_constraint_details={
                "type": dedicated_vm_host_placement_constraint_details_type,
                "compute_bare_metal_host_id": test_compute_bare_metal_host["id"],
            })
        ```

        ## Import

        DedicatedVmHosts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/dedicatedVmHost:DedicatedVmHost test_dedicated_vm_host "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[_builtins.str] dedicated_vm_host_shape: The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fault_domain: The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.
               
               To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['DedicatedVmHostPlacementConstraintDetailsArgs', 'DedicatedVmHostPlacementConstraintDetailsArgsDict']] placement_constraint_details: Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedVmHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dedicated Vm Host resource in Oracle Cloud Infrastructure Core service.

        Creates a new dedicated virtual machine host in the specified compartment and the specified availability domain.
        Dedicated virtual machine hosts enable you to run your Compute virtual machine (VM) instances on dedicated servers
        that are a single tenant and not shared with other customers.
        For more information, see [Dedicated Virtual Machine Hosts](https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/dedicatedvmhosts.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dedicated_vm_host = oci.core.DedicatedVmHost("test_dedicated_vm_host",
            availability_domain=dedicated_vm_host_availability_domain,
            compartment_id=compartment_id,
            dedicated_vm_host_shape=dedicated_vm_host_dedicated_vm_host_shape,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=dedicated_vm_host_display_name,
            fault_domain=dedicated_vm_host_fault_domain,
            freeform_tags={
                "Department": "Finance",
            },
            placement_constraint_details={
                "type": dedicated_vm_host_placement_constraint_details_type,
                "compute_bare_metal_host_id": test_compute_bare_metal_host["id"],
            })
        ```

        ## Import

        DedicatedVmHosts can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/dedicatedVmHost:DedicatedVmHost test_dedicated_vm_host "id"
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedVmHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedVmHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dedicated_vm_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 placement_constraint_details: Optional[pulumi.Input[Union['DedicatedVmHostPlacementConstraintDetailsArgs', 'DedicatedVmHostPlacementConstraintDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedVmHostArgs.__new__(DedicatedVmHostArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if dedicated_vm_host_shape is None and not opts.urn:
                raise TypeError("Missing required property 'dedicated_vm_host_shape'")
            __props__.__dict__["dedicated_vm_host_shape"] = dedicated_vm_host_shape
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["placement_constraint_details"] = placement_constraint_details
            __props__.__dict__["capacity_bins"] = None
            __props__.__dict__["compute_bare_metal_host_id"] = None
            __props__.__dict__["remaining_memory_in_gbs"] = None
            __props__.__dict__["remaining_ocpus"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["total_memory_in_gbs"] = None
            __props__.__dict__["total_ocpus"] = None
        super(DedicatedVmHost, __self__).__init__(
            'oci:Core/dedicatedVmHost:DedicatedVmHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[_builtins.str]] = None,
            capacity_bins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DedicatedVmHostCapacityBinArgs', 'DedicatedVmHostCapacityBinArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            compute_bare_metal_host_id: Optional[pulumi.Input[_builtins.str]] = None,
            dedicated_vm_host_shape: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            placement_constraint_details: Optional[pulumi.Input[Union['DedicatedVmHostPlacementConstraintDetailsArgs', 'DedicatedVmHostPlacementConstraintDetailsArgsDict']]] = None,
            remaining_memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
            remaining_ocpus: Optional[pulumi.Input[_builtins.float]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            total_memory_in_gbs: Optional[pulumi.Input[_builtins.float]] = None,
            total_ocpus: Optional[pulumi.Input[_builtins.float]] = None) -> 'DedicatedVmHost':
        """
        Get an existing DedicatedVmHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_domain: The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DedicatedVmHostCapacityBinArgs', 'DedicatedVmHostCapacityBinArgsDict']]]] capacity_bins: A list of total and remaining CPU & memory per capacity bucket.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[_builtins.str] compute_bare_metal_host_id: The OCID of the compute bare metal host.
        :param pulumi.Input[_builtins.str] dedicated_vm_host_shape: The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[_builtins.str] fault_domain: The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.
               
               To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['DedicatedVmHostPlacementConstraintDetailsArgs', 'DedicatedVmHostPlacementConstraintDetailsArgsDict']] placement_constraint_details: Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        :param pulumi.Input[_builtins.float] remaining_memory_in_gbs: The current available memory of the dedicated VM host, in GBs.
        :param pulumi.Input[_builtins.float] remaining_ocpus: The current available OCPUs of the dedicated VM host.
        :param pulumi.Input[_builtins.str] state: The current state of the dedicated VM host.
        :param pulumi.Input[_builtins.str] time_created: The date and time the dedicated VM host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.float] total_memory_in_gbs: The current total memory of the dedicated VM host, in GBs.
        :param pulumi.Input[_builtins.float] total_ocpus: The current total OCPUs of the dedicated VM host.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedVmHostState.__new__(_DedicatedVmHostState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["capacity_bins"] = capacity_bins
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_bare_metal_host_id"] = compute_bare_metal_host_id
        __props__.__dict__["dedicated_vm_host_shape"] = dedicated_vm_host_shape
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["placement_constraint_details"] = placement_constraint_details
        __props__.__dict__["remaining_memory_in_gbs"] = remaining_memory_in_gbs
        __props__.__dict__["remaining_ocpus"] = remaining_ocpus
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["total_memory_in_gbs"] = total_memory_in_gbs
        __props__.__dict__["total_ocpus"] = total_ocpus
        return DedicatedVmHost(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The availability domain of the dedicated virtual machine host.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="capacityBins")
    def capacity_bins(self) -> pulumi.Output[Sequence['outputs.DedicatedVmHostCapacityBin']]:
        """
        A list of total and remaining CPU & memory per capacity bucket.
        """
        return pulumi.get(self, "capacity_bins")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeBareMetalHostId")
    def compute_bare_metal_host_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the compute bare metal host.
        """
        return pulumi.get(self, "compute_bare_metal_host_id")

    @_builtins.property
    @pulumi.getter(name="dedicatedVmHostShape")
    def dedicated_vm_host_shape(self) -> pulumi.Output[_builtins.str]:
        """
        The dedicated virtual machine host shape. The shape determines the number of CPUs and other resources available for VM instances launched on the dedicated virtual machine host.
        """
        return pulumi.get(self, "dedicated_vm_host_shape")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[_builtins.str]:
        """
        The fault domain for the dedicated virtual machine host's assigned instances. For more information, see [Fault Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm#fault). If you do not specify the fault domain, the system selects one for you. To change the fault domain for a dedicated virtual machine host, delete it and create a new dedicated virtual machine host in the preferred fault domain.

        To get a list of fault domains, use the `ListFaultDomains` operation in the [Identity and Access Management Service API](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/).

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="placementConstraintDetails")
    def placement_constraint_details(self) -> pulumi.Output['outputs.DedicatedVmHostPlacementConstraintDetails']:
        """
        Generic placement details field which is overloaded with bare metal host id or host group id based on the resource we are targeting to launch.
        """
        return pulumi.get(self, "placement_constraint_details")

    @_builtins.property
    @pulumi.getter(name="remainingMemoryInGbs")
    def remaining_memory_in_gbs(self) -> pulumi.Output[_builtins.float]:
        """
        The current available memory of the dedicated VM host, in GBs.
        """
        return pulumi.get(self, "remaining_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="remainingOcpus")
    def remaining_ocpus(self) -> pulumi.Output[_builtins.float]:
        """
        The current available OCPUs of the dedicated VM host.
        """
        return pulumi.get(self, "remaining_ocpus")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the dedicated VM host.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the dedicated VM host was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="totalMemoryInGbs")
    def total_memory_in_gbs(self) -> pulumi.Output[_builtins.float]:
        """
        The current total memory of the dedicated VM host, in GBs.
        """
        return pulumi.get(self, "total_memory_in_gbs")

    @_builtins.property
    @pulumi.getter(name="totalOcpus")
    def total_ocpus(self) -> pulumi.Output[_builtins.float]:
        """
        The current total OCPUs of the dedicated VM host.
        """
        return pulumi.get(self, "total_ocpus")

