# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetComputeGpuMemoryClusterResult',
    'AwaitableGetComputeGpuMemoryClusterResult',
    'get_compute_gpu_memory_cluster',
    'get_compute_gpu_memory_cluster_output',
]

@pulumi.output_type
class GetComputeGpuMemoryClusterResult:
    """
    A collection of values returned by getComputeGpuMemoryCluster.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, compute_cluster_id=None, compute_gpu_memory_cluster_id=None, defined_tags=None, display_name=None, freeform_tags=None, gpu_memory_fabric_id=None, id=None, instance_configuration_id=None, size=None, state=None, system_tags=None, time_created=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_cluster_id and not isinstance(compute_cluster_id, str):
            raise TypeError("Expected argument 'compute_cluster_id' to be a str")
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if compute_gpu_memory_cluster_id and not isinstance(compute_gpu_memory_cluster_id, str):
            raise TypeError("Expected argument 'compute_gpu_memory_cluster_id' to be a str")
        pulumi.set(__self__, "compute_gpu_memory_cluster_id", compute_gpu_memory_cluster_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpu_memory_fabric_id and not isinstance(gpu_memory_fabric_id, str):
            raise TypeError("Expected argument 'gpu_memory_fabric_id' to be a str")
        pulumi.set(__self__, "gpu_memory_fabric_id", gpu_memory_fabric_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_configuration_id and not isinstance(instance_configuration_id, str):
            raise TypeError("Expected argument 'instance_configuration_id' to be a str")
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if size and not isinstance(size, str):
            raise TypeError("Expected argument 'size' to be a str")
        pulumi.set(__self__, "size", size)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain of the GPU memory cluster.
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute GPU memory cluster.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @_builtins.property
    @pulumi.getter(name="computeGpuMemoryClusterId")
    def compute_gpu_memory_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "compute_gpu_memory_cluster_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="gpuMemoryFabricId")
    def gpu_memory_fabric_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the GPU memory fabric.
        """
        return pulumi.get(self, "gpu_memory_fabric_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Customer-unique GPU memory cluster
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> _builtins.str:
        """
        The OCID of the Instance Configuration used to source launch details for this instance.
        """
        return pulumi.get(self, "instance_configuration_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.str:
        """
        The number of instances currently running in the GpuMemoryCluster
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The lifecycle state of the GPU memory cluster
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the GPU memory cluster was created.  Example: `2016-09-15T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetComputeGpuMemoryClusterResult(GetComputeGpuMemoryClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeGpuMemoryClusterResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            compute_cluster_id=self.compute_cluster_id,
            compute_gpu_memory_cluster_id=self.compute_gpu_memory_cluster_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            gpu_memory_fabric_id=self.gpu_memory_fabric_id,
            id=self.id,
            instance_configuration_id=self.instance_configuration_id,
            size=self.size,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_compute_gpu_memory_cluster(compute_gpu_memory_cluster_id: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeGpuMemoryClusterResult:
    """
    This data source provides details about a specific Compute Gpu Memory Cluster resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute GPU memory cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_gpu_memory_cluster = oci.Core.get_compute_gpu_memory_cluster(compute_gpu_memory_cluster_id=test_compute_gpu_memory_cluster_oci_core_compute_gpu_memory_cluster["id"])
    ```


    :param _builtins.str compute_gpu_memory_cluster_id: The OCID of the compute GPU memory cluster.
    """
    __args__ = dict()
    __args__['computeGpuMemoryClusterId'] = compute_gpu_memory_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeGpuMemoryCluster:getComputeGpuMemoryCluster', __args__, opts=opts, typ=GetComputeGpuMemoryClusterResult).value

    return AwaitableGetComputeGpuMemoryClusterResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_cluster_id=pulumi.get(__ret__, 'compute_cluster_id'),
        compute_gpu_memory_cluster_id=pulumi.get(__ret__, 'compute_gpu_memory_cluster_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gpu_memory_fabric_id=pulumi.get(__ret__, 'gpu_memory_fabric_id'),
        id=pulumi.get(__ret__, 'id'),
        instance_configuration_id=pulumi.get(__ret__, 'instance_configuration_id'),
        size=pulumi.get(__ret__, 'size'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_compute_gpu_memory_cluster_output(compute_gpu_memory_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeGpuMemoryClusterResult]:
    """
    This data source provides details about a specific Compute Gpu Memory Cluster resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute GPU memory cluster

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_gpu_memory_cluster = oci.Core.get_compute_gpu_memory_cluster(compute_gpu_memory_cluster_id=test_compute_gpu_memory_cluster_oci_core_compute_gpu_memory_cluster["id"])
    ```


    :param _builtins.str compute_gpu_memory_cluster_id: The OCID of the compute GPU memory cluster.
    """
    __args__ = dict()
    __args__['computeGpuMemoryClusterId'] = compute_gpu_memory_cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeGpuMemoryCluster:getComputeGpuMemoryCluster', __args__, opts=opts, typ=GetComputeGpuMemoryClusterResult)
    return __ret__.apply(lambda __response__: GetComputeGpuMemoryClusterResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_cluster_id=pulumi.get(__response__, 'compute_cluster_id'),
        compute_gpu_memory_cluster_id=pulumi.get(__response__, 'compute_gpu_memory_cluster_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gpu_memory_fabric_id=pulumi.get(__response__, 'gpu_memory_fabric_id'),
        id=pulumi.get(__response__, 'id'),
        instance_configuration_id=pulumi.get(__response__, 'instance_configuration_id'),
        size=pulumi.get(__response__, 'size'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created')))
