# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetComputeHostGroupResult',
    'AwaitableGetComputeHostGroupResult',
    'get_compute_host_group',
    'get_compute_host_group_output',
]

@pulumi.output_type
class GetComputeHostGroupResult:
    """
    A collection of values returned by getComputeHostGroup.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, compute_host_group_id=None, configurations=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_targeted_placement_required=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_host_group_id and not isinstance(compute_host_group_id, str):
            raise TypeError("Expected argument 'compute_host_group_id' to be a str")
        pulumi.set(__self__, "compute_host_group_id", compute_host_group_id)
        if configurations and not isinstance(configurations, list):
            raise TypeError("Expected argument 'configurations' to be a list")
        pulumi.set(__self__, "configurations", configurations)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_targeted_placement_required and not isinstance(is_targeted_placement_required, bool):
            raise TypeError("Expected argument 'is_targeted_placement_required' to be a bool")
        pulumi.set(__self__, "is_targeted_placement_required", is_targeted_placement_required)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> _builtins.str:
        """
        The availability domain of a host group.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the compartment that contains host group.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="computeHostGroupId")
    def compute_host_group_id(self) -> _builtins.str:
        return pulumi.get(self, "compute_host_group_id")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetComputeHostGroupConfigurationResult']:
        """
        A list of HostGroupConfiguration objects
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Customer-unique host group
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isTargetedPlacementRequired")
    def is_targeted_placement_required(self) -> _builtins.bool:
        """
        A flag that allows customers to restrict placement for hosts attached to the group. If true, the only way to place on hosts is to target the specific host group.
        """
        return pulumi.get(self, "is_targeted_placement_required")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The lifecycle state of the host group
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the host group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the host group was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetComputeHostGroupResult(GetComputeHostGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeHostGroupResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            compute_host_group_id=self.compute_host_group_id,
            configurations=self.configurations,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_targeted_placement_required=self.is_targeted_placement_required,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_compute_host_group(compute_host_group_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeHostGroupResult:
    """
    This data source provides details about a specific Compute Host Group resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute host group

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_host_group = oci.Core.get_compute_host_group(compute_host_group_id=test_compute_host_group_oci_core_compute_host_group["id"])
    ```


    :param _builtins.str compute_host_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group.
    """
    __args__ = dict()
    __args__['computeHostGroupId'] = compute_host_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeHostGroup:getComputeHostGroup', __args__, opts=opts, typ=GetComputeHostGroupResult).value

    return AwaitableGetComputeHostGroupResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_host_group_id=pulumi.get(__ret__, 'compute_host_group_id'),
        configurations=pulumi.get(__ret__, 'configurations'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_targeted_placement_required=pulumi.get(__ret__, 'is_targeted_placement_required'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_compute_host_group_output(compute_host_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeHostGroupResult]:
    """
    This data source provides details about a specific Compute Host Group resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute host group

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_host_group = oci.Core.get_compute_host_group(compute_host_group_id=test_compute_host_group_oci_core_compute_host_group["id"])
    ```


    :param _builtins.str compute_host_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute host group.
    """
    __args__ = dict()
    __args__['computeHostGroupId'] = compute_host_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeHostGroup:getComputeHostGroup', __args__, opts=opts, typ=GetComputeHostGroupResult)
    return __ret__.apply(lambda __response__: GetComputeHostGroupResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_host_group_id=pulumi.get(__response__, 'compute_host_group_id'),
        configurations=pulumi.get(__response__, 'configurations'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_targeted_placement_required=pulumi.get(__response__, 'is_targeted_placement_required'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
