# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetImageShapesResult',
    'AwaitableGetImageShapesResult',
    'get_image_shapes',
    'get_image_shapes_output',
]

@pulumi.output_type
class GetImageShapesResult:
    """
    A collection of values returned by getImageShapes.
    """
    def __init__(__self__, filters=None, id=None, image_id=None, image_shape_compatibilities=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if image_shape_compatibilities and not isinstance(image_shape_compatibilities, list):
            raise TypeError("Expected argument 'image_shape_compatibilities' to be a list")
        pulumi.set(__self__, "image_shape_compatibilities", image_shape_compatibilities)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetImageShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        The image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageShapeCompatibilities")
    def image_shape_compatibilities(self) -> Sequence['outputs.GetImageShapesImageShapeCompatibilityResult']:
        """
        The list of image_shape_compatibilities.
        """
        return pulumi.get(self, "image_shape_compatibilities")


class AwaitableGetImageShapesResult(GetImageShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImageShapesResult(
            filters=self.filters,
            id=self.id,
            image_id=self.image_id,
            image_shape_compatibilities=self.image_shape_compatibilities)


def get_image_shapes(filters: Optional[Sequence[Union['GetImageShapesFilterArgs', 'GetImageShapesFilterArgsDict']]] = None,
                     image_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImageShapesResult:
    """
    This data source provides the list of Image Shapes in Oracle Cloud Infrastructure Core service.

    Lists the compatible shapes for the specified image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_image_shapes = oci.Core.get_image_shapes(image_id=test_image["id"])
    ```


    :param _builtins.str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the image.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getImageShapes:getImageShapes', __args__, opts=opts, typ=GetImageShapesResult).value

    return AwaitableGetImageShapesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        image_shape_compatibilities=pulumi.get(__ret__, 'image_shape_compatibilities'))
def get_image_shapes_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetImageShapesFilterArgs', 'GetImageShapesFilterArgsDict']]]]] = None,
                            image_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImageShapesResult]:
    """
    This data source provides the list of Image Shapes in Oracle Cloud Infrastructure Core service.

    Lists the compatible shapes for the specified image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_image_shapes = oci.Core.get_image_shapes(image_id=test_image["id"])
    ```


    :param _builtins.str image_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the image.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['imageId'] = image_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getImageShapes:getImageShapes', __args__, opts=opts, typ=GetImageShapesResult)
    return __ret__.apply(lambda __response__: GetImageShapesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        image_shape_compatibilities=pulumi.get(__response__, 'image_shape_compatibilities')))
