# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApplicationVipArgs', 'ApplicationVip']

@pulumi.input_type
class ApplicationVipArgs:
    def __init__(__self__, *,
                 cloud_vm_cluster_id: pulumi.Input[_builtins.str],
                 hostname_label: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 db_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApplicationVip resource.
        :param pulumi.Input[_builtins.str] cloud_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] hostname_label: The hostname of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] db_node_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] ip_address: The application virtual IP (VIP) IPv4 address.
        :param pulumi.Input[_builtins.str] ipv6address: The application virtual IP (VIP) IPv6 address.
        """
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        pulumi.set(__self__, "hostname_label", hostname_label)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if db_node_id is not None:
            pulumi.set(__self__, "db_node_id", db_node_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipv6address is not None:
            pulumi.set(__self__, "ipv6address", ipv6address)

    @_builtins.property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @cloud_vm_cluster_id.setter
    def cloud_vm_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_vm_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> pulumi.Input[_builtins.str]:
        """
        The hostname of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hostname_label", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "db_node_id")

    @db_node_id.setter
    def db_node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_node_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application virtual IP (VIP) IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def ipv6address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application virtual IP (VIP) IPv6 address.
        """
        return pulumi.get(self, "ipv6address")

    @ipv6address.setter
    def ipv6address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6address", value)


@pulumi.input_type
class _ApplicationVipState:
    def __init__(__self__, *,
                 cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 hostname_label: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6address: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_assigned: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApplicationVip resources.
        :param pulumi.Input[_builtins.str] cloud_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] db_node_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] hostname_label: The hostname of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] ip_address: The application virtual IP (VIP) IPv4 address.
        :param pulumi.Input[_builtins.str] ipv6address: The application virtual IP (VIP) IPv6 address.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_assigned: The date and time when the create operation for the application virtual IP (VIP) address completed.
        """
        if cloud_vm_cluster_id is not None:
            pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_node_id is not None:
            pulumi.set(__self__, "db_node_id", db_node_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ipv6address is not None:
            pulumi.set(__self__, "ipv6address", ipv6address)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_assigned is not None:
            pulumi.set(__self__, "time_assigned", time_assigned)

    @_builtins.property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @cloud_vm_cluster_id.setter
    def cloud_vm_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_vm_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "db_node_id")

    @db_node_id.setter
    def db_node_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_node_id", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname_label", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application virtual IP (VIP) IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def ipv6address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application virtual IP (VIP) IPv6 address.
        """
        return pulumi.get(self, "ipv6address")

    @ipv6address.setter
    def ipv6address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6address", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="timeAssigned")
    def time_assigned(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the create operation for the application virtual IP (VIP) address completed.
        """
        return pulumi.get(self, "time_assigned")

    @time_assigned.setter
    def time_assigned(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_assigned", value)


@pulumi.type_token("oci:Database/applicationVip:ApplicationVip")
class ApplicationVip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_label: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6address: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Application Vip resource in Oracle Cloud Infrastructure Database service.

        Creates a new application virtual IP (VIP) address in the specified cloud VM cluster based on the request parameters you provide.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_application_vip = oci.database.ApplicationVip("test_application_vip",
            cloud_vm_cluster_id=test_cloud_vm_cluster["id"],
            hostname_label=application_vip_hostname_label,
            subnet_id=test_subnet["id"],
            db_node_id=test_db_node["id"],
            ip_address=application_vip_ip_address,
            ipv6address=application_vip_ipv6address)
        ```

        ## Import

        ApplicationVips can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/applicationVip:ApplicationVip test_application_vip "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] db_node_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] hostname_label: The hostname of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] ip_address: The application virtual IP (VIP) IPv4 address.
        :param pulumi.Input[_builtins.str] ipv6address: The application virtual IP (VIP) IPv6 address.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationVipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Application Vip resource in Oracle Cloud Infrastructure Database service.

        Creates a new application virtual IP (VIP) address in the specified cloud VM cluster based on the request parameters you provide.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_application_vip = oci.database.ApplicationVip("test_application_vip",
            cloud_vm_cluster_id=test_cloud_vm_cluster["id"],
            hostname_label=application_vip_hostname_label,
            subnet_id=test_subnet["id"],
            db_node_id=test_db_node["id"],
            ip_address=application_vip_ip_address,
            ipv6address=application_vip_ipv6address)
        ```

        ## Import

        ApplicationVips can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/applicationVip:ApplicationVip test_application_vip "id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationVipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationVipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 db_node_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_label: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6address: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationVipArgs.__new__(ApplicationVipArgs)

            if cloud_vm_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_vm_cluster_id'")
            __props__.__dict__["cloud_vm_cluster_id"] = cloud_vm_cluster_id
            __props__.__dict__["db_node_id"] = db_node_id
            if hostname_label is None and not opts.urn:
                raise TypeError("Missing required property 'hostname_label'")
            __props__.__dict__["hostname_label"] = hostname_label
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["ipv6address"] = ipv6address
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_assigned"] = None
        super(ApplicationVip, __self__).__init__(
            'oci:Database/applicationVip:ApplicationVip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            db_node_id: Optional[pulumi.Input[_builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            hostname_label: Optional[pulumi.Input[_builtins.str]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6address: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_assigned: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApplicationVip':
        """
        Get an existing ApplicationVip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.str] db_node_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[_builtins.str] hostname_label: The hostname of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] ip_address: The application virtual IP (VIP) IPv4 address.
        :param pulumi.Input[_builtins.str] ipv6address: The application virtual IP (VIP) IPv6 address.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] state: The current lifecycle state of the application virtual IP (VIP) address.
        :param pulumi.Input[_builtins.str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] time_assigned: The date and time when the create operation for the application virtual IP (VIP) address completed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationVipState.__new__(_ApplicationVipState)

        __props__.__dict__["cloud_vm_cluster_id"] = cloud_vm_cluster_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["db_node_id"] = db_node_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname_label"] = hostname_label
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ipv6address"] = ipv6address
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_assigned"] = time_assigned
        return ApplicationVip(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud VM cluster associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "cloud_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB node associated with the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "db_node_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "hostname_label")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[_builtins.str]:
        """
        The application virtual IP (VIP) IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def ipv6address(self) -> pulumi.Output[_builtins.str]:
        """
        The application virtual IP (VIP) IPv6 address.
        """
        return pulumi.get(self, "ipv6address")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current lifecycle state of the application virtual IP (VIP) address.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet associated with the application virtual IP (VIP) address.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="timeAssigned")
    def time_assigned(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the create operation for the application virtual IP (VIP) address completed.
        """
        return pulumi.get(self, "time_assigned")

