# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutonomousDatabaseBackupArgs', 'AutonomousDatabaseBackup']

@pulumi.input_type
class AutonomousDatabaseBackupArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[_builtins.str],
                 backup_destination_details: Optional[pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_long_term_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseBackup resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        :param pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs'] backup_destination_details: Backup destination details
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
        :param pulumi.Input[_builtins.bool] is_long_term_backup: Indicates whether the backup is long-term
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) Retention period, in days, for long-term backups
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if backup_destination_details is not None:
            pulumi.set(__self__, "backup_destination_details", backup_destination_details)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_long_term_backup is not None:
            pulumi.set(__self__, "is_long_term_backup", is_long_term_backup)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="backupDestinationDetails")
    def backup_destination_details(self) -> Optional[pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs']]:
        """
        Backup destination details
        """
        return pulumi.get(self, "backup_destination_details")

    @backup_destination_details.setter
    def backup_destination_details(self, value: Optional[pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs']]):
        pulumi.set(self, "backup_destination_details", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the backup. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="isLongTermBackup")
    def is_long_term_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the backup is long-term
        """
        return pulumi.get(self, "is_long_term_backup")

    @is_long_term_backup.setter
    def is_long_term_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_long_term_backup", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Retention period, in days, for long-term backups


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)


@pulumi.input_type
class _AutonomousDatabaseBackupState:
    def __init__(__self__, *,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_destination_details: Optional[pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 db_version: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_automatic: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_long_term_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_restorable: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_store_wallet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 time_available_till: Optional[pulumi.Input[_builtins.str]] = None,
                 time_ended: Optional[pulumi.Input[_builtins.str]] = None,
                 time_started: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseBackup resources.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        :param pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs'] backup_destination_details: Backup destination details
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.float] database_size_in_tbs: The size of the database in terabytes at the time the backup was taken.
        :param pulumi.Input[_builtins.str] db_version: A valid Oracle Database version for Autonomous Database.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
        :param pulumi.Input[_builtins.bool] is_automatic: Indicates whether the backup is user-initiated or automatic.
        :param pulumi.Input[_builtins.bool] is_long_term_backup: Indicates whether the backup is long-term
        :param pulumi.Input[_builtins.bool] is_restorable: Indicates whether the backup can be used to restore the associated Autonomous Database.
        :param pulumi.Input[_builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[_builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[_builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[_builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) Retention period, in days, for long-term backups
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.float] size_in_tbs: The backup size in terrabytes (TB).
        :param pulumi.Input[_builtins.str] state: The current state of the backup.
        :param pulumi.Input[_builtins.str] time_available_till: Timestamp until when the backup will be available
        :param pulumi.Input[_builtins.str] time_ended: The date and time the backup completed.
        :param pulumi.Input[_builtins.str] time_started: The date and time the backup started.
        :param pulumi.Input[_builtins.str] type: The type of backup.
        :param pulumi.Input[_builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if backup_destination_details is not None:
            pulumi.set(__self__, "backup_destination_details", backup_destination_details)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database_size_in_tbs is not None:
            pulumi.set(__self__, "database_size_in_tbs", database_size_in_tbs)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_automatic is not None:
            pulumi.set(__self__, "is_automatic", is_automatic)
        if is_long_term_backup is not None:
            pulumi.set(__self__, "is_long_term_backup", is_long_term_backup)
        if is_restorable is not None:
            pulumi.set(__self__, "is_restorable", is_restorable)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name is not None:
            pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if size_in_tbs is not None:
            pulumi.set(__self__, "size_in_tbs", size_in_tbs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_available_till is not None:
            pulumi.set(__self__, "time_available_till", time_available_till)
        if time_ended is not None:
            pulumi.set(__self__, "time_ended", time_ended)
        if time_started is not None:
            pulumi.set(__self__, "time_started", time_started)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="backupDestinationDetails")
    def backup_destination_details(self) -> Optional[pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs']]:
        """
        Backup destination details
        """
        return pulumi.get(self, "backup_destination_details")

    @backup_destination_details.setter
    def backup_destination_details(self, value: Optional[pulumi.Input['AutonomousDatabaseBackupBackupDestinationDetailsArgs']]):
        pulumi.set(self, "backup_destination_details", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseSizeInTbs")
    def database_size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The size of the database in terabytes at the time the backup was taken.
        """
        return pulumi.get(self, "database_size_in_tbs")

    @database_size_in_tbs.setter
    def database_size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "database_size_in_tbs", value)

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid Oracle Database version for Autonomous Database.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_version", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user-friendly name for the backup. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="isAutomatic")
    def is_automatic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the backup is user-initiated or automatic.
        """
        return pulumi.get(self, "is_automatic")

    @is_automatic.setter
    def is_automatic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_automatic", value)

    @_builtins.property
    @pulumi.getter(name="isLongTermBackup")
    def is_long_term_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the backup is long-term
        """
        return pulumi.get(self, "is_long_term_backup")

    @is_long_term_backup.setter
    def is_long_term_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_long_term_backup", value)

    @_builtins.property
    @pulumi.getter(name="isRestorable")
    def is_restorable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the backup can be used to restore the associated Autonomous Database.
        """
        return pulumi.get(self, "is_restorable")

    @is_restorable.setter
    def is_restorable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_restorable", value)

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_id", value)

    @_builtins.property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @key_store_wallet_name.setter
    def key_store_wallet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_store_wallet_name", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) Retention period, in days, for long-term backups


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter(name="sizeInTbs")
    def size_in_tbs(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The backup size in terrabytes (TB).
        """
        return pulumi.get(self, "size_in_tbs")

    @size_in_tbs.setter
    def size_in_tbs(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "size_in_tbs", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="timeAvailableTill")
    def time_available_till(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp until when the backup will be available
        """
        return pulumi.get(self, "time_available_till")

    @time_available_till.setter
    def time_available_till(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_available_till", value)

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the backup completed.
        """
        return pulumi.get(self, "time_ended")

    @time_ended.setter
    def time_ended(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_ended", value)

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the backup started.
        """
        return pulumi.get(self, "time_started")

    @time_started.setter
    def time_started(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_started", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_id", value)


@pulumi.type_token("oci:Database/autonomousDatabaseBackup:AutonomousDatabaseBackup")
class AutonomousDatabaseBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_destination_details: Optional[pulumi.Input[Union['AutonomousDatabaseBackupBackupDestinationDetailsArgs', 'AutonomousDatabaseBackupBackupDestinationDetailsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_long_term_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Database Backup resource in Oracle Cloud Infrastructure Database service.

        Creates a new Autonomous Database backup for the specified database based on the provided request parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_backup = oci.database.AutonomousDatabaseBackup("test_autonomous_database_backup",
            autonomous_database_id=test_autonomous_database["id"],
            display_name=autonomous_database_backup_display_name,
            is_long_term_backup=autonomous_database_backup_is_long_term_backup,
            retention_period_in_days=autonomous_database_backup_retention_period_in_days)
        ```

        ## Import

        AutonomousDatabaseBackups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousDatabaseBackup:AutonomousDatabaseBackup test_autonomous_database_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        :param pulumi.Input[Union['AutonomousDatabaseBackupBackupDestinationDetailsArgs', 'AutonomousDatabaseBackupBackupDestinationDetailsArgsDict']] backup_destination_details: Backup destination details
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
        :param pulumi.Input[_builtins.bool] is_long_term_backup: Indicates whether the backup is long-term
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) Retention period, in days, for long-term backups
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Database Backup resource in Oracle Cloud Infrastructure Database service.

        Creates a new Autonomous Database backup for the specified database based on the provided request parameters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_backup = oci.database.AutonomousDatabaseBackup("test_autonomous_database_backup",
            autonomous_database_id=test_autonomous_database["id"],
            display_name=autonomous_database_backup_display_name,
            is_long_term_backup=autonomous_database_backup_is_long_term_backup,
            retention_period_in_days=autonomous_database_backup_retention_period_in_days)
        ```

        ## Import

        AutonomousDatabaseBackups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/autonomousDatabaseBackup:AutonomousDatabaseBackup test_autonomous_database_backup "id"
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_destination_details: Optional[pulumi.Input[Union['AutonomousDatabaseBackupBackupDestinationDetailsArgs', 'AutonomousDatabaseBackupBackupDestinationDetailsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_long_term_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseBackupArgs.__new__(AutonomousDatabaseBackupArgs)

            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["backup_destination_details"] = backup_destination_details
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["is_long_term_backup"] = is_long_term_backup
            __props__.__dict__["retention_period_in_days"] = retention_period_in_days
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["database_size_in_tbs"] = None
            __props__.__dict__["db_version"] = None
            __props__.__dict__["is_automatic"] = None
            __props__.__dict__["is_restorable"] = None
            __props__.__dict__["key_store_id"] = None
            __props__.__dict__["key_store_wallet_name"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["kms_key_version_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["size_in_tbs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_available_till"] = None
            __props__.__dict__["time_ended"] = None
            __props__.__dict__["time_started"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vault_id"] = None
        super(AutonomousDatabaseBackup, __self__).__init__(
            'oci:Database/autonomousDatabaseBackup:AutonomousDatabaseBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            backup_destination_details: Optional[pulumi.Input[Union['AutonomousDatabaseBackupBackupDestinationDetailsArgs', 'AutonomousDatabaseBackupBackupDestinationDetailsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            db_version: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_automatic: Optional[pulumi.Input[_builtins.bool]] = None,
            is_long_term_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            is_restorable: Optional[pulumi.Input[_builtins.bool]] = None,
            key_store_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_store_wallet_name: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_version_id: Optional[pulumi.Input[_builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            size_in_tbs: Optional[pulumi.Input[_builtins.float]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            time_available_till: Optional[pulumi.Input[_builtins.str]] = None,
            time_ended: Optional[pulumi.Input[_builtins.str]] = None,
            time_started: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vault_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutonomousDatabaseBackup':
        """
        Get an existing AutonomousDatabaseBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        :param pulumi.Input[Union['AutonomousDatabaseBackupBackupDestinationDetailsArgs', 'AutonomousDatabaseBackupBackupDestinationDetailsArgsDict']] backup_destination_details: Backup destination details
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[_builtins.float] database_size_in_tbs: The size of the database in terabytes at the time the backup was taken.
        :param pulumi.Input[_builtins.str] db_version: A valid Oracle Database version for Autonomous Database.
        :param pulumi.Input[_builtins.str] display_name: The user-friendly name for the backup. The name does not have to be unique.
        :param pulumi.Input[_builtins.bool] is_automatic: Indicates whether the backup is user-initiated or automatic.
        :param pulumi.Input[_builtins.bool] is_long_term_backup: Indicates whether the backup is long-term
        :param pulumi.Input[_builtins.bool] is_restorable: Indicates whether the backup can be used to restore the associated Autonomous Database.
        :param pulumi.Input[_builtins.str] key_store_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        :param pulumi.Input[_builtins.str] key_store_wallet_name: The wallet name for Oracle Key Vault.
        :param pulumi.Input[_builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[_builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        :param pulumi.Input[_builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) Retention period, in days, for long-term backups
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.float] size_in_tbs: The backup size in terrabytes (TB).
        :param pulumi.Input[_builtins.str] state: The current state of the backup.
        :param pulumi.Input[_builtins.str] time_available_till: Timestamp until when the backup will be available
        :param pulumi.Input[_builtins.str] time_ended: The date and time the backup completed.
        :param pulumi.Input[_builtins.str] time_started: The date and time the backup started.
        :param pulumi.Input[_builtins.str] type: The type of backup.
        :param pulumi.Input[_builtins.str] vault_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseBackupState.__new__(_AutonomousDatabaseBackupState)

        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["backup_destination_details"] = backup_destination_details
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database_size_in_tbs"] = database_size_in_tbs
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["is_automatic"] = is_automatic
        __props__.__dict__["is_long_term_backup"] = is_long_term_backup
        __props__.__dict__["is_restorable"] = is_restorable
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_wallet_name"] = key_store_wallet_name
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["retention_period_in_days"] = retention_period_in_days
        __props__.__dict__["size_in_tbs"] = size_in_tbs
        __props__.__dict__["state"] = state
        __props__.__dict__["time_available_till"] = time_available_till
        __props__.__dict__["time_ended"] = time_ended
        __props__.__dict__["time_started"] = time_started
        __props__.__dict__["type"] = type
        __props__.__dict__["vault_id"] = vault_id
        return AutonomousDatabaseBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous Database backup.
        """
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter(name="backupDestinationDetails")
    def backup_destination_details(self) -> pulumi.Output['outputs.AutonomousDatabaseBackupBackupDestinationDetails']:
        """
        Backup destination details
        """
        return pulumi.get(self, "backup_destination_details")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="databaseSizeInTbs")
    def database_size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The size of the database in terabytes at the time the backup was taken.
        """
        return pulumi.get(self, "database_size_in_tbs")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[_builtins.str]:
        """
        A valid Oracle Database version for Autonomous Database.
        """
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The user-friendly name for the backup. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="isAutomatic")
    def is_automatic(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the backup is user-initiated or automatic.
        """
        return pulumi.get(self, "is_automatic")

    @_builtins.property
    @pulumi.getter(name="isLongTermBackup")
    def is_long_term_backup(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the backup is long-term
        """
        return pulumi.get(self, "is_long_term_backup")

    @_builtins.property
    @pulumi.getter(name="isRestorable")
    def is_restorable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the backup can be used to restore the associated Autonomous Database.
        """
        return pulumi.get(self, "is_restorable")

    @_builtins.property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store of Oracle Vault.
        """
        return pulumi.get(self, "key_store_id")

    @_builtins.property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.
        """
        return pulumi.get(self, "kms_key_version_id")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) Retention period, in days, for long-term backups


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "retention_period_in_days")

    @_builtins.property
    @pulumi.getter(name="sizeInTbs")
    def size_in_tbs(self) -> pulumi.Output[_builtins.float]:
        """
        The backup size in terrabytes (TB).
        """
        return pulumi.get(self, "size_in_tbs")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeAvailableTill")
    def time_available_till(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp until when the backup will be available
        """
        return pulumi.get(self, "time_available_till")

    @_builtins.property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the backup completed.
        """
        return pulumi.get(self, "time_ended")

    @_builtins.property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the backup started.
        """
        return pulumi.get(self, "time_started")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of backup.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts). This parameter and `secretId` are required for Customer Managed Keys.
        """
        return pulumi.get(self, "vault_id")

