# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabaseSoftwareImagesResult',
    'AwaitableGetAutonomousDatabaseSoftwareImagesResult',
    'get_autonomous_database_software_images',
    'get_autonomous_database_software_images_output',
]

@pulumi.output_type
class GetAutonomousDatabaseSoftwareImagesResult:
    """
    A collection of values returned by getAutonomousDatabaseSoftwareImages.
    """
    def __init__(__self__, autonomous_database_software_image_collections=None, compartment_id=None, display_name=None, filters=None, id=None, image_shape_family=None, state=None):
        if autonomous_database_software_image_collections and not isinstance(autonomous_database_software_image_collections, list):
            raise TypeError("Expected argument 'autonomous_database_software_image_collections' to be a list")
        pulumi.set(__self__, "autonomous_database_software_image_collections", autonomous_database_software_image_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_shape_family and not isinstance(image_shape_family, str):
            raise TypeError("Expected argument 'image_shape_family' to be a str")
        pulumi.set(__self__, "image_shape_family", image_shape_family)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseSoftwareImageCollections")
    def autonomous_database_software_image_collections(self) -> Sequence['outputs.GetAutonomousDatabaseSoftwareImagesAutonomousDatabaseSoftwareImageCollectionResult']:
        """
        The list of autonomous_database_software_image_collection.
        """
        return pulumi.get(self, "autonomous_database_software_image_collections")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        The user-friendly name for the Autonomous Database Software Image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabaseSoftwareImagesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> _builtins.str:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the Autonomous Database Software Image.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousDatabaseSoftwareImagesResult(GetAutonomousDatabaseSoftwareImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabaseSoftwareImagesResult(
            autonomous_database_software_image_collections=self.autonomous_database_software_image_collections,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            image_shape_family=self.image_shape_family,
            state=self.state)


def get_autonomous_database_software_images(compartment_id: Optional[_builtins.str] = None,
                                            display_name: Optional[_builtins.str] = None,
                                            filters: Optional[Sequence[Union['GetAutonomousDatabaseSoftwareImagesFilterArgs', 'GetAutonomousDatabaseSoftwareImagesFilterArgsDict']]] = None,
                                            image_shape_family: Optional[_builtins.str] = None,
                                            state: Optional[_builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabaseSoftwareImagesResult:
    """
    This data source provides the list of Autonomous Database Software Images in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Database Software Images in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_software_images = oci.Database.get_autonomous_database_software_images(compartment_id=compartment_id,
        image_shape_family=autonomous_database_software_image_image_shape_family,
        display_name=autonomous_database_software_image_display_name,
        state=autonomous_database_software_image_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str image_shape_family: A filter to return only resources that match the given image shape family exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageShapeFamily'] = image_shape_family
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabaseSoftwareImages:getAutonomousDatabaseSoftwareImages', __args__, opts=opts, typ=GetAutonomousDatabaseSoftwareImagesResult).value

    return AwaitableGetAutonomousDatabaseSoftwareImagesResult(
        autonomous_database_software_image_collections=pulumi.get(__ret__, 'autonomous_database_software_image_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_shape_family=pulumi.get(__ret__, 'image_shape_family'),
        state=pulumi.get(__ret__, 'state'))
def get_autonomous_database_software_images_output(compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                   display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabaseSoftwareImagesFilterArgs', 'GetAutonomousDatabaseSoftwareImagesFilterArgsDict']]]]] = None,
                                                   image_shape_family: Optional[pulumi.Input[_builtins.str]] = None,
                                                   state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousDatabaseSoftwareImagesResult]:
    """
    This data source provides the list of Autonomous Database Software Images in Oracle Cloud Infrastructure Database service.

    Gets a list of the Autonomous Database Software Images in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_database_software_images = oci.Database.get_autonomous_database_software_images(compartment_id=compartment_id,
        image_shape_family=autonomous_database_software_image_image_shape_family,
        display_name=autonomous_database_software_image_display_name,
        state=autonomous_database_software_image_state)
    ```


    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param _builtins.str image_shape_family: A filter to return only resources that match the given image shape family exactly.
    :param _builtins.str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageShapeFamily'] = image_shape_family
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousDatabaseSoftwareImages:getAutonomousDatabaseSoftwareImages', __args__, opts=opts, typ=GetAutonomousDatabaseSoftwareImagesResult)
    return __ret__.apply(lambda __response__: GetAutonomousDatabaseSoftwareImagesResult(
        autonomous_database_software_image_collections=pulumi.get(__response__, 'autonomous_database_software_image_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        image_shape_family=pulumi.get(__response__, 'image_shape_family'),
        state=pulumi.get(__response__, 'state')))
