# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudExadataInfrastructureUnAllocatedResourceResult',
    'AwaitableGetCloudExadataInfrastructureUnAllocatedResourceResult',
    'get_cloud_exadata_infrastructure_un_allocated_resource',
    'get_cloud_exadata_infrastructure_un_allocated_resource_output',
]

@pulumi.output_type
class GetCloudExadataInfrastructureUnAllocatedResourceResult:
    """
    A collection of values returned by getCloudExadataInfrastructureUnAllocatedResource.
    """
    def __init__(__self__, cloud_autonomous_vm_clusters=None, cloud_exadata_infrastructure_display_name=None, cloud_exadata_infrastructure_id=None, db_servers=None, exadata_storage_in_tbs=None, id=None, local_storage_in_gbs=None, memory_in_gbs=None, ocpus=None):
        if cloud_autonomous_vm_clusters and not isinstance(cloud_autonomous_vm_clusters, list):
            raise TypeError("Expected argument 'cloud_autonomous_vm_clusters' to be a list")
        pulumi.set(__self__, "cloud_autonomous_vm_clusters", cloud_autonomous_vm_clusters)
        if cloud_exadata_infrastructure_display_name and not isinstance(cloud_exadata_infrastructure_display_name, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_display_name' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_display_name", cloud_exadata_infrastructure_display_name)
        if cloud_exadata_infrastructure_id and not isinstance(cloud_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if exadata_storage_in_tbs and not isinstance(exadata_storage_in_tbs, float):
            raise TypeError("Expected argument 'exadata_storage_in_tbs' to be a float")
        pulumi.set(__self__, "exadata_storage_in_tbs", exadata_storage_in_tbs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_storage_in_gbs and not isinstance(local_storage_in_gbs, int):
            raise TypeError("Expected argument 'local_storage_in_gbs' to be a int")
        pulumi.set(__self__, "local_storage_in_gbs", local_storage_in_gbs)
        if memory_in_gbs and not isinstance(memory_in_gbs, int):
            raise TypeError("Expected argument 'memory_in_gbs' to be a int")
        pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus and not isinstance(ocpus, int):
            raise TypeError("Expected argument 'ocpus' to be a int")
        pulumi.set(__self__, "ocpus", ocpus)

    @_builtins.property
    @pulumi.getter(name="cloudAutonomousVmClusters")
    def cloud_autonomous_vm_clusters(self) -> Sequence['outputs.GetCloudExadataInfrastructureUnAllocatedResourceCloudAutonomousVmClusterResult']:
        """
        The list of Cloud Autonomous VM Clusters on the Infrastructure and their associated unallocated resources details.
        """
        return pulumi.get(self, "cloud_autonomous_vm_clusters")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureDisplayName")
    def cloud_exadata_infrastructure_display_name(self) -> _builtins.str:
        """
        The user-friendly name for the Cloud Exadata infrastructure. The name does not need to be unique.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_display_name")

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter(name="exadataStorageInTbs")
    def exadata_storage_in_tbs(self) -> _builtins.float:
        """
        Total unallocated exadata storage in the infrastructure in TBs.
        """
        return pulumi.get(self, "exadata_storage_in_tbs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localStorageInGbs")
    def local_storage_in_gbs(self) -> _builtins.int:
        """
        The minimum amount of unallocated storage available across all nodes in the infrastructure.
        """
        return pulumi.get(self, "local_storage_in_gbs")

    @_builtins.property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> _builtins.int:
        """
        The minimum amount of unallocated memory available across all nodes in the infrastructure.
        """
        return pulumi.get(self, "memory_in_gbs")

    @_builtins.property
    @pulumi.getter
    def ocpus(self) -> _builtins.int:
        """
        The minimum amount of unallocated ocpus available across all nodes in the infrastructure.
        """
        return pulumi.get(self, "ocpus")


class AwaitableGetCloudExadataInfrastructureUnAllocatedResourceResult(GetCloudExadataInfrastructureUnAllocatedResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudExadataInfrastructureUnAllocatedResourceResult(
            cloud_autonomous_vm_clusters=self.cloud_autonomous_vm_clusters,
            cloud_exadata_infrastructure_display_name=self.cloud_exadata_infrastructure_display_name,
            cloud_exadata_infrastructure_id=self.cloud_exadata_infrastructure_id,
            db_servers=self.db_servers,
            exadata_storage_in_tbs=self.exadata_storage_in_tbs,
            id=self.id,
            local_storage_in_gbs=self.local_storage_in_gbs,
            memory_in_gbs=self.memory_in_gbs,
            ocpus=self.ocpus)


def get_cloud_exadata_infrastructure_un_allocated_resource(cloud_exadata_infrastructure_id: Optional[_builtins.str] = None,
                                                           db_servers: Optional[Sequence[_builtins.str]] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudExadataInfrastructureUnAllocatedResourceResult:
    """
    This data source provides details about a specific Cloud Exadata Infrastructure Un Allocated Resource resource in Oracle Cloud Infrastructure Database service.

    Gets unallocated resources information for the specified Cloud Exadata infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_exadata_infrastructure_un_allocated_resource = oci.Database.get_cloud_exadata_infrastructure_un_allocated_resource(cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
        db_servers=cloud_exadata_infrastructure_un_allocated_resource_db_servers)
    ```


    :param _builtins.str cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['dbServers'] = db_servers
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getCloudExadataInfrastructureUnAllocatedResource:getCloudExadataInfrastructureUnAllocatedResource', __args__, opts=opts, typ=GetCloudExadataInfrastructureUnAllocatedResourceResult).value

    return AwaitableGetCloudExadataInfrastructureUnAllocatedResourceResult(
        cloud_autonomous_vm_clusters=pulumi.get(__ret__, 'cloud_autonomous_vm_clusters'),
        cloud_exadata_infrastructure_display_name=pulumi.get(__ret__, 'cloud_exadata_infrastructure_display_name'),
        cloud_exadata_infrastructure_id=pulumi.get(__ret__, 'cloud_exadata_infrastructure_id'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        exadata_storage_in_tbs=pulumi.get(__ret__, 'exadata_storage_in_tbs'),
        id=pulumi.get(__ret__, 'id'),
        local_storage_in_gbs=pulumi.get(__ret__, 'local_storage_in_gbs'),
        memory_in_gbs=pulumi.get(__ret__, 'memory_in_gbs'),
        ocpus=pulumi.get(__ret__, 'ocpus'))
def get_cloud_exadata_infrastructure_un_allocated_resource_output(cloud_exadata_infrastructure_id: Optional[pulumi.Input[_builtins.str]] = None,
                                                                  db_servers: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                                                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudExadataInfrastructureUnAllocatedResourceResult]:
    """
    This data source provides details about a specific Cloud Exadata Infrastructure Un Allocated Resource resource in Oracle Cloud Infrastructure Database service.

    Gets unallocated resources information for the specified Cloud Exadata infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cloud_exadata_infrastructure_un_allocated_resource = oci.Database.get_cloud_exadata_infrastructure_un_allocated_resource(cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
        db_servers=cloud_exadata_infrastructure_un_allocated_resource_db_servers)
    ```


    :param _builtins.str cloud_exadata_infrastructure_id: The cloud Exadata infrastructure [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param Sequence[_builtins.str] db_servers: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Db servers.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureId'] = cloud_exadata_infrastructure_id
    __args__['dbServers'] = db_servers
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getCloudExadataInfrastructureUnAllocatedResource:getCloudExadataInfrastructureUnAllocatedResource', __args__, opts=opts, typ=GetCloudExadataInfrastructureUnAllocatedResourceResult)
    return __ret__.apply(lambda __response__: GetCloudExadataInfrastructureUnAllocatedResourceResult(
        cloud_autonomous_vm_clusters=pulumi.get(__response__, 'cloud_autonomous_vm_clusters'),
        cloud_exadata_infrastructure_display_name=pulumi.get(__response__, 'cloud_exadata_infrastructure_display_name'),
        cloud_exadata_infrastructure_id=pulumi.get(__response__, 'cloud_exadata_infrastructure_id'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        exadata_storage_in_tbs=pulumi.get(__response__, 'exadata_storage_in_tbs'),
        id=pulumi.get(__response__, 'id'),
        local_storage_in_gbs=pulumi.get(__response__, 'local_storage_in_gbs'),
        memory_in_gbs=pulumi.get(__response__, 'memory_in_gbs'),
        ocpus=pulumi.get(__response__, 'ocpus')))
