# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGiVersionsResult',
    'AwaitableGetGiVersionsResult',
    'get_gi_versions',
    'get_gi_versions_output',
]

@pulumi.output_type
class GetGiVersionsResult:
    """
    A collection of values returned by getGiVersions.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, filters=None, gi_versions=None, id=None, resource_id=None, shape=None, shape_attribute=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gi_versions and not isinstance(gi_versions, list):
            raise TypeError("Expected argument 'gi_versions' to be a list")
        pulumi.set(__self__, "gi_versions", gi_versions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if shape_attribute and not isinstance(shape_attribute, str):
            raise TypeError("Expected argument 'shape_attribute' to be a str")
        pulumi.set(__self__, "shape_attribute", shape_attribute)

    @_builtins.property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_domain")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetGiVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="giVersions")
    def gi_versions(self) -> Sequence['outputs.GetGiVersionsGiVersionResult']:
        """
        The list of gi_versions.
        """
        return pulumi.get(self, "gi_versions")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def shape(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "shape")

    @_builtins.property
    @pulumi.getter(name="shapeAttribute")
    def shape_attribute(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "shape_attribute")


class AwaitableGetGiVersionsResult(GetGiVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGiVersionsResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            filters=self.filters,
            gi_versions=self.gi_versions,
            id=self.id,
            resource_id=self.resource_id,
            shape=self.shape,
            shape_attribute=self.shape_attribute)


def get_gi_versions(availability_domain: Optional[_builtins.str] = None,
                    compartment_id: Optional[_builtins.str] = None,
                    filters: Optional[Sequence[Union['GetGiVersionsFilterArgs', 'GetGiVersionsFilterArgsDict']]] = None,
                    resource_id: Optional[_builtins.str] = None,
                    shape: Optional[_builtins.str] = None,
                    shape_attribute: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGiVersionsResult:
    """
    This data source provides the list of Gi Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported GI versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_gi_versions = oci.Database.get_gi_versions(compartment_id=compartment_id,
        availability_domain=gi_version_availability_domain,
        resource_id=test_resource["id"],
        shape=gi_version_shape,
        shape_attribute=gi_version_shape_attribute)
    ```


    :param _builtins.str availability_domain: The target availability domain. Only passed if the limit is AD-specific.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str resource_id: If provided, filters the results for the specified resource Id.
    :param _builtins.str shape: If provided, filters the results for the given shape.
    :param _builtins.str shape_attribute: If provided and applicable, return the results based on the shapeAttribute provided
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['shape'] = shape
    __args__['shapeAttribute'] = shape_attribute
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getGiVersions:getGiVersions', __args__, opts=opts, typ=GetGiVersionsResult).value

    return AwaitableGetGiVersionsResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        gi_versions=pulumi.get(__ret__, 'gi_versions'),
        id=pulumi.get(__ret__, 'id'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        shape=pulumi.get(__ret__, 'shape'),
        shape_attribute=pulumi.get(__ret__, 'shape_attribute'))
def get_gi_versions_output(availability_domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetGiVersionsFilterArgs', 'GetGiVersionsFilterArgsDict']]]]] = None,
                           resource_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           shape: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           shape_attribute: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGiVersionsResult]:
    """
    This data source provides the list of Gi Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported GI versions.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_gi_versions = oci.Database.get_gi_versions(compartment_id=compartment_id,
        availability_domain=gi_version_availability_domain,
        resource_id=test_resource["id"],
        shape=gi_version_shape,
        shape_attribute=gi_version_shape_attribute)
    ```


    :param _builtins.str availability_domain: The target availability domain. Only passed if the limit is AD-specific.
    :param _builtins.str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param _builtins.str resource_id: If provided, filters the results for the specified resource Id.
    :param _builtins.str shape: If provided, filters the results for the given shape.
    :param _builtins.str shape_attribute: If provided and applicable, return the results based on the shapeAttribute provided
    """
    __args__ = dict()
    __args__['availabilityDomain'] = availability_domain
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['resourceId'] = resource_id
    __args__['shape'] = shape
    __args__['shapeAttribute'] = shape_attribute
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getGiVersions:getGiVersions', __args__, opts=opts, typ=GetGiVersionsResult)
    return __ret__.apply(lambda __response__: GetGiVersionsResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        gi_versions=pulumi.get(__response__, 'gi_versions'),
        id=pulumi.get(__response__, 'id'),
        resource_id=pulumi.get(__response__, 'resource_id'),
        shape=pulumi.get(__response__, 'shape'),
        shape_attribute=pulumi.get(__response__, 'shape_attribute')))
