# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetManagedPreferredCredentialResult',
    'AwaitableGetManagedPreferredCredentialResult',
    'get_managed_preferred_credential',
    'get_managed_preferred_credential_output',
]

@pulumi.output_type
class GetManagedPreferredCredentialResult:
    """
    A collection of values returned by getManagedPreferredCredential.
    """
    def __init__(__self__, credential_name=None, id=None, is_accessible=None, managed_database_id=None, named_credential_id=None, password_secret_id=None, role=None, status=None, type=None, user_name=None):
        if credential_name and not isinstance(credential_name, str):
            raise TypeError("Expected argument 'credential_name' to be a str")
        pulumi.set(__self__, "credential_name", credential_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_accessible and not isinstance(is_accessible, bool):
            raise TypeError("Expected argument 'is_accessible' to be a bool")
        pulumi.set(__self__, "is_accessible", is_accessible)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if named_credential_id and not isinstance(named_credential_id, str):
            raise TypeError("Expected argument 'named_credential_id' to be a str")
        pulumi.set(__self__, "named_credential_id", named_credential_id)
        if password_secret_id and not isinstance(password_secret_id, str):
            raise TypeError("Expected argument 'password_secret_id' to be a str")
        pulumi.set(__self__, "password_secret_id", password_secret_id)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> _builtins.str:
        """
        The name of the preferred credential.
        """
        return pulumi.get(self, "credential_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAccessible")
    def is_accessible(self) -> _builtins.bool:
        """
        Indicates whether the preferred credential is accessible.
        """
        return pulumi.get(self, "is_accessible")

    @_builtins.property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> _builtins.str:
        return pulumi.get(self, "managed_database_id")

    @_builtins.property
    @pulumi.getter(name="namedCredentialId")
    def named_credential_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Named Credential that contains the database user password metadata.
        """
        return pulumi.get(self, "named_credential_id")

    @_builtins.property
    @pulumi.getter(name="passwordSecretId")
    def password_secret_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Vault service secret that contains the database user password.
        """
        return pulumi.get(self, "password_secret_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        The role of the database user.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the preferred credential.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of preferred credential. Only 'BASIC' is supported currently.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The user name used to connect to the database.
        """
        return pulumi.get(self, "user_name")


class AwaitableGetManagedPreferredCredentialResult(GetManagedPreferredCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedPreferredCredentialResult(
            credential_name=self.credential_name,
            id=self.id,
            is_accessible=self.is_accessible,
            managed_database_id=self.managed_database_id,
            named_credential_id=self.named_credential_id,
            password_secret_id=self.password_secret_id,
            role=self.role,
            status=self.status,
            type=self.type,
            user_name=self.user_name)


def get_managed_preferred_credential(credential_name: Optional[_builtins.str] = None,
                                     managed_database_id: Optional[_builtins.str] = None,
                                     named_credential_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedPreferredCredentialResult:
    """
    This data source provides details about a specific Managed Database Preferred Credential resource in Oracle Cloud Infrastructure Database Management service.

    Gets the preferred credential details for a Managed Database based on credentialName.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_preferred_credential = oci.Database.get_managed_preferred_credential(credential_name=managed_database_preferred_credential_credential_name,
        managed_database_id=test_managed_database["id"])
    ```


    :param _builtins.str credential_name: The name of the preferred credential.
    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str named_credential_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Named Credential that contains the database user password metadata.
    """
    __args__ = dict()
    __args__['credentialName'] = credential_name
    __args__['managedDatabaseId'] = managed_database_id
    __args__['namedCredentialId'] = named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getManagedPreferredCredential:getManagedPreferredCredential', __args__, opts=opts, typ=GetManagedPreferredCredentialResult).value

    return AwaitableGetManagedPreferredCredentialResult(
        credential_name=pulumi.get(__ret__, 'credential_name'),
        id=pulumi.get(__ret__, 'id'),
        is_accessible=pulumi.get(__ret__, 'is_accessible'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        named_credential_id=pulumi.get(__ret__, 'named_credential_id'),
        password_secret_id=pulumi.get(__ret__, 'password_secret_id'),
        role=pulumi.get(__ret__, 'role'),
        status=pulumi.get(__ret__, 'status'),
        type=pulumi.get(__ret__, 'type'),
        user_name=pulumi.get(__ret__, 'user_name'))
def get_managed_preferred_credential_output(credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                                            managed_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            named_credential_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetManagedPreferredCredentialResult]:
    """
    This data source provides details about a specific Managed Database Preferred Credential resource in Oracle Cloud Infrastructure Database Management service.

    Gets the preferred credential details for a Managed Database based on credentialName.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_preferred_credential = oci.Database.get_managed_preferred_credential(credential_name=managed_database_preferred_credential_credential_name,
        managed_database_id=test_managed_database["id"])
    ```


    :param _builtins.str credential_name: The name of the preferred credential.
    :param _builtins.str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param _builtins.str named_credential_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Named Credential that contains the database user password metadata.
    """
    __args__ = dict()
    __args__['credentialName'] = credential_name
    __args__['managedDatabaseId'] = managed_database_id
    __args__['namedCredentialId'] = named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getManagedPreferredCredential:getManagedPreferredCredential', __args__, opts=opts, typ=GetManagedPreferredCredentialResult)
    return __ret__.apply(lambda __response__: GetManagedPreferredCredentialResult(
        credential_name=pulumi.get(__response__, 'credential_name'),
        id=pulumi.get(__response__, 'id'),
        is_accessible=pulumi.get(__response__, 'is_accessible'),
        managed_database_id=pulumi.get(__response__, 'managed_database_id'),
        named_credential_id=pulumi.get(__response__, 'named_credential_id'),
        password_secret_id=pulumi.get(__response__, 'password_secret_id'),
        role=pulumi.get(__response__, 'role'),
        status=pulumi.get(__response__, 'status'),
        type=pulumi.get(__response__, 'type'),
        user_name=pulumi.get(__response__, 'user_name')))
